/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.ActionDebugger;
import br.ufpe.abaco.gui.ActionEvaluatorResult;
import br.ufpe.abaco.gui.HelpMenu;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.OpenedWindows;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;

public class DesktopWindow
extends JInternalFrame {
    static Vector existingWindows = new Vector();
    static JInternalFrame oldActivated = null;
    private int windowMenuPosition = -1;
    static boolean maximized = true;

    static void insertWindow(DesktopWindow desktopWindow) {
        JMenu jMenu = Interface.getInterface().getWindowMenu();
        if (existingWindows.size() == 0) {
            jMenu.getItem(0).setEnabled(true);
            jMenu.getItem(1).setEnabled(true);
            jMenu.addSeparator();
        }
        existingWindows.addElement(desktopWindow);
        desktopWindow.windowMenuPosition = existingWindows.size() - 1;
        WindowMenuItem windowMenuItem = new WindowMenuItem(desktopWindow);
        jMenu.add(windowMenuItem);
        if (desktopWindow.windowMenuPosition < 10) {
            windowMenuItem.setAccelerator(KeyStroke.getKeyStroke(48 + desktopWindow.windowMenuPosition, 8));
        }
    }

    static void removeWindow(DesktopWindow desktopWindow) {
        if (desktopWindow.windowMenuPosition == -1) {
            return;
        }
        JMenu jMenu = Interface.getInterface().getWindowMenu();
        int n = desktopWindow.windowMenuPosition;
        desktopWindow.windowMenuPosition = -1;
        existingWindows.remove(n);
        jMenu.remove(n + 3);
        int n2 = n;
        while (n2 < existingWindows.size()) {
            DesktopWindow desktopWindow2 = (DesktopWindow)existingWindows.elementAt(n2);
            desktopWindow2.windowMenuPosition = n2;
            if (desktopWindow2.windowMenuPosition < 10) {
                jMenu.getItem(n2 + 3).setAccelerator(KeyStroke.getKeyStroke(48 + n2, 8));
            }
            ++n2;
        }
        if (existingWindows.size() == 0) {
            jMenu.getItem(0).setEnabled(false);
            jMenu.getItem(1).setEnabled(false);
            jMenu.remove(2);
        }
    }

    public DesktopWindow(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
        DesktopWindow.insertWindow(this);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
                JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                Interface.getInterface().disableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "paste", "cut", "select all", "search", "replace"}));
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                try {
                    JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                    maximized = jInternalFrame.isMaximum();
                    Interface.getInterface().disableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "paste", "cut", "select all", "search", "replace"}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                JInternalFrame jInternalFrame;
                JMenuItem jMenuItem = Interface.getInterface().getMenuItem("cascade windows");
                if (!jMenuItem.isEnabled()) {
                    jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                    try {
                        jInternalFrame.setMaximum(maximized);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jInternalFrame.setEnabled(false);
                    jInternalFrame.setEnabled(true);
                    maximized = true;
                    jInternalFrame.requestFocus();
                } else {
                    jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                    jInternalFrame.setEnabled(false);
                }
                jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                if (jInternalFrame instanceof ActionDebugger || jInternalFrame instanceof ActionEvaluatorResult) {
                    Interface.getInterface().disableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "paste", "cut", "select all", "search", "replace"}));
                } else if (jInternalFrame instanceof HelpMenu) {
                    Interface.getInterface().disableItens(Interface.getInterface().getMenuItens(new String[]{"paste", "cut", "replace"}));
                    Interface.getInterface().enableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "search", "select all"}));
                } else {
                    Interface.getInterface().enableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "paste", "cut", "select all", "search", "replace"}));
                }
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                DesktopWindow.this.dispose();
                Interface.getInterface().disableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "paste", "cut", "select all", "search", "replace"}));
            }
        });
        this.setSize(300, 200);
        this.setVisible(true);
        Interface.getInterface().getPane().add(this);
        Interface.getInterface().getPane().moveToFront(this);
    }

    public void dispose() {
        DesktopWindow.removeWindow(this);
        super.dispose();
    }

    public static void cascade(OpenedWindows openedWindows) {
        Dimension dimension = openedWindows.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = existingWindows.size();
        Double d = new Double(dimension.getWidth());
        Double d2 = new Double(dimension.getHeight());
        int n5 = d.intValue() - (n4 - 1) * 25;
        int n6 = d2.intValue() - (n4 - 1) * 25;
        int n7 = 0;
        while (n7 < n4) {
            DesktopWindow desktopWindow = (DesktopWindow)existingWindows.elementAt(n7);
            if (n7 != 0) {
                n += 25;
                n2 += 25;
            }
            try {
                if (desktopWindow.isMaximum()) {
                    desktopWindow.setMaximum(false);
                } else if (desktopWindow.isIcon()) {
                    desktopWindow.setIcon(false);
                } else if (desktopWindow.isSelected()) {
                    desktopWindow.setSelected(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            desktopWindow.setLocation(n, n2);
            desktopWindow.setSize(n5, n6);
            if (dimension.getWidth() - (double)n < 25.0) {
                if (dimension.getWidth() - (double)n3 < 25.0) {
                    n = 0;
                    n3 = 25;
                } else {
                    n = n3;
                    n3 += 25;
                }
            }
            if (dimension.getHeight() - (double)n2 < 25.0) {
                n2 = 0;
            }
            try {
                desktopWindow.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++n7;
        }
    }

    public void copy() {
    }

    public void cut() {
    }

    public void paste() {
    }

    public void selectAll() {
    }

    public String getSelectedText() {
        return null;
    }

    public UndoManager getUndoManager() {
        return null;
    }

    public String getValue() {
        return null;
    }

    public String getValue(int n, int n2) throws BadLocationException {
        throw new BadLocationException("", 0);
    }

    public void selectText(int n, int n2) {
    }

    public void replaceTextSelection(String string) {
    }

    public int getCaretPosition() {
        return 0;
    }

    public void setCaretPosition(int n) {
    }

    static class WindowMenuItem
    extends JMenuItem
    implements ActionListener {
        DesktopWindow target;

        WindowMenuItem(DesktopWindow desktopWindow) {
            super(desktopWindow.getTitle());
            this.addActionListener(this);
            this.target = desktopWindow;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.target.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

