/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.EspecParser.TokenMgrError;
import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.compiler.Specification;
import br.ufpe.abaco.gui.AbacoTextEditor;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.ExampleFileFilter;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.runtime.Term;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class Console
extends DesktopWindow
implements ActionListener {
    private JLabel lblType = new JLabel("Type: untyped expression");
    private JTextArea console = new AbacoTextEditor();
    private ImageIcon left = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/StepBack16.gif"));
    private ImageIcon right = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/StepForward16.gif"));
    private JButton forward = new JButton(this.right);
    private JButton backward = new JButton(this.left);
    private JButton execute = new JButton("Execute");
    private JScrollPane consoleScroll = new JScrollPane(this.console);
    private JPanel panelButtons = new JPanel();
    private Vector repository = new Vector();
    private int bufferSize;
    private int markVectorPosition = 0;
    private Specification runner = null;
    ActionListener saveCodeListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(new File("."));
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter("jar", "Java Archive Files");
            jFileChooser.setFileFilter(exampleFileFilter);
            int n = jFileChooser.showSaveDialog(Interface.getInterface());
            if (n != 0) {
                return;
            }
            String string = jFileChooser.getSelectedFile().toString();
            boolean bl = false;
            Console.this.runner.generator().saveGeneratedCode(string, bl);
        }
    };

    public Console(Specification specification, String string) {
        super("Console - [" + string + "]", true, true, true, true);
        this.runner = specification;
        this.getContentPane().setLayout(new BorderLayout());
        this.consoleScroll.setSize(360, 320);
        this.consoleScroll.setHorizontalScrollBarPolicy(31);
        this.console.setLineWrap(true);
        this.getContentPane().add((Component)this.consoleScroll, "Center");
        this.getContentPane().add((Component)this.lblType, "North");
        this.addInternalFrameListener(new ActionEvaluatorListener());
        this.panelButtons.setLayout(new GridLayout(1, 3));
        this.panelButtons.add(this.backward);
        this.backward.addActionListener(this);
        this.panelButtons.add(this.forward);
        this.forward.addActionListener(this);
        this.panelButtons.add(this.execute);
        this.execute.addActionListener(this);
        this.panelButtons.setSize(360, 40);
        this.forward.setEnabled(false);
        this.backward.setEnabled(false);
        this.getContentPane().add((Component)this.panelButtons, "South");
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.execute) {
            boolean bl = false;
            int n = 0;
            if (!this.console.getText().equals("")) {
                n = this.markVectorPosition;
                int n2 = this.repository.size() - 1;
                while (n2 >= n) {
                    this.repository.remove(n2);
                    --n2;
                }
                this.forward.setEnabled(false);
                Runnable runnable = new Runnable(){

                    public void run() {
                        Console.this.execute.setEnabled(false);
                        Console.this.console.setEnabled(false);
                        Console.this.execute();
                        Console.this.execute.setEnabled(true);
                        Console.this.console.setEnabled(true);
                    }
                };
                new Thread(runnable).start();
                return;
            }
        } else if (actionEvent.getSource() == this.backward) {
            this.console.getCaret();
            if (!this.forward.isEnabled()) {
                this.forward.setEnabled(true);
            }
            --this.markVectorPosition;
            if (this.markVectorPosition == 0) {
                this.backward.setEnabled(false);
            }
            this.console.setText((String)this.repository.get(this.markVectorPosition));
        } else if (actionEvent.getSource() == this.forward) {
            this.console.getCaret();
            if (!this.backward.isEnabled()) {
                this.backward.setEnabled(true);
            }
            ++this.markVectorPosition;
            if (this.markVectorPosition == this.repository.size() - 1) {
                this.forward.setEnabled(false);
            }
            this.console.setText((String)this.repository.get(this.markVectorPosition));
        }
    }

    public ByteArrayInputStream getInput() {
        byte[] byArray = this.console.getText().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
        this.repository.addElement(new String(byArray));
        this.markVectorPosition = this.repository.size();
        this.bufferSize = byArray.length;
        return byteArrayInputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void execute() {
        try {
            Term term;
            ByteArrayInputStream byteArrayInputStream = this.getInput();
            int n = this.getBufferSize();
            Term term2 = term = this.runner.parse(byteArrayInputStream);
            this.runner.calcType(term2);
            String string = this.runner.print(term2);
            String string2 = this.runner.engine.sortName(term2.getType());
            if (!string2.equals("")) {
                this.lblType.setText("Type: " + string2);
            } else {
                this.lblType.setText("Type: untyped expression");
            }
            this.console.setText(string);
            this.repository.addElement(string);
            this.markVectorPosition = this.repository.size() - 1;
            this.backward.setEnabled(true);
        }
        catch (CompilerException compilerException) {
            String string = "Parser Error : \n" + compilerException;
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
        }
        catch (IOException iOException) {
            String string = "IO Error! ";
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
        }
        catch (TokenMgrError tokenMgrError) {
            String string = "Error : " + tokenMgrError.toString();
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = "Stack overflow!";
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
        }
        catch (NullPointerException nullPointerException) {
            String string = "Specification compiled no successful! " + ((Throwable)nullPointerException).getMessage();
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
            nullPointerException.printStackTrace();
        }
    }

    public void copy() {
        this.console.copy();
    }

    public void cut() {
        this.console.cut();
    }

    public void paste() {
        this.console.paste();
    }

    public void selectAll() {
        this.console.selectAll();
    }

    public void activate() {
        JMenuItem jMenuItem = Interface.getInterface().getMenuItem("save code");
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(this.saveCodeListener);
    }

    public void deactivate() {
        JMenuItem jMenuItem = Interface.getInterface().getMenuItem("save code");
        jMenuItem.setEnabled(false);
        jMenuItem.removeActionListener(this.saveCodeListener);
    }

    public void dispose() {
        this.runner = null;
        super.dispose();
    }

    class ActionEvaluatorListener
    extends InternalFrameAdapter {
        ActionEvaluatorListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            Console.this.activate();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            Console.this.deactivate();
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            Console.this.deactivate();
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            Console.this.activate();
        }
    }
}

