/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.EspecParser.ParseException;
import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.compiler.PrintListener;
import br.ufpe.abaco.compiler.Specification;
import br.ufpe.abaco.compiler.SpecificationCompiler;
import br.ufpe.abaco.gui.Console;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.Exporter;
import br.ufpe.abaco.gui.OpenedWindows;
import br.ufpe.abaco.gui.Project;
import br.ufpe.abaco.gui.ProjectSource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class CompilerWindow
extends DesktopWindow
implements Runnable,
ActionListener {
    String msg = "";
    JTextArea messages = new JTextArea();
    JButton ok = new JButton("OK");
    JPanel pan = new JPanel();
    Specification runner = null;
    String startSpec;
    Project prj;

    CompilerWindow(OpenedWindows openedWindows, Project project, String string) {
        super(Exporter.exporting ? "Exporting" : "Compiling", true, true, true, true);
        this.startSpec = string;
        this.prj = project;
        this.getContentPane().add((Component)new JScrollPane(this.messages), "Center");
        this.getContentPane().add((Component)new JPanel(), "East");
        this.getContentPane().add((Component)new JPanel(), "West");
        this.getContentPane().add((Component)new JPanel(), "North");
        this.ok.setSize(50, 20);
        this.pan.add(this.ok);
        this.getContentPane().add((Component)this.pan, "South");
        this.setSize(400, 300);
        this.setVisible(true);
        this.ok.addActionListener(this);
        this.setDefaultCloseOperation(2);
        if (openedWindows != null) {
            Dimension dimension = openedWindows.getSize();
            this.setLocation(((int)dimension.getWidth() - 400) / 2, ((int)dimension.getWidth() - 300) / 2);
        }
        this.moveToFront();
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        new Thread(this).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            try {
                this.setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.runner != null) {
                if (Exporter.exporting) {
                    this.runner.export(Exporter.dest, this.startSpec);
                    if (!Exporter.dest.exportMultipleFiles()) {
                        Exporter.printFiles();
                    } else {
                        Exporter.exporting = false;
                    }
                } else {
                    new Console(this.runner, this.startSpec);
                }
            }
        }
    }

    public void run() {
        System.gc();
        ProjectSource projectSource = this.prj.createSpecificationSource();
        try {
            System.gc();
            long l = System.currentTimeMillis();
            SpecificationCompiler.setListener(new GuiListener());
            try {
                Object object;
                InputStream inputStream = null;
                File file = new File("abaco_library.prj");
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                } else {
                    object = ClassLoader.getSystemResource("abaco_library.prj");
                    if (object != null) {
                        inputStream = ((URL)object).openStream();
                    }
                }
                if (inputStream != null) {
                    object = new Project(inputStream);
                    projectSource.parent(((Project)object).createSpecificationSource());
                }
            }
            catch (Exception exception) {
                this.messages.append("Warnning : Can't Find Abaco Library");
            }
            this.runner = SpecificationCompiler.compile(projectSource, this.startSpec);
            SpecificationCompiler.setListener(null);
            if (Exporter.exporting) {
                this.messages.append("Export OK");
            } else {
                this.messages.append("Compilation OK");
            }
        }
        catch (IOException iOException) {
            this.messages.append("Specification Not Found " + iOException.getMessage());
        }
        catch (ParseException parseException) {
            this.messages.append("Parser Error " + parseException.getMessage());
        }
        catch (CompilerException compilerException) {
            this.messages.append(compilerException.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.messages.append("Unable to compile specification");
            nullPointerException.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        SpecificationCompiler.setListener(null);
    }

    class GuiListener
    extends PrintListener {
        int size = 0;

        GuiListener() {
        }

        public void writeLine(String string) {
            this.size += string.length() + 1;
            CompilerWindow.this.messages.append(string + "\n");
            CompilerWindow.this.messages.setCaretPosition(this.size);
        }
    }
}

