/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.gui.ActionDebugger;
import br.ufpe.abaco.gui.ActionEvaluatorResult;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.gui.OpenedWindows;
import br.ufpe.abaco.runtime.AbacoExecutionEngine;
import br.ufpe.abaco.runtime.Term;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ActionEvaluator
extends DesktopWindow {
    private UndoManager undoManager = new UndoManager();
    AbacoExecutionEngine actionPerformer = null;
    JEditorPane corrAction = new JEditorPane();
    private OpenedWindows windows = new OpenedWindows();
    String fileName;
    ActionListener performListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Term term;
                String string = "perform (\n" + ActionEvaluator.this.corrAction.getText() + "\n)";
                Term term2 = term = ActionEvaluator.this.actionPerformer.parse(string);
                String string2 = ActionEvaluator.this.actionPerformer.print(term2);
                ActionEvaluatorResult actionEvaluatorResult = new ActionEvaluatorResult();
                actionEvaluatorResult.setValue(string2);
                ActionEvaluator.this.windows.newWindow(actionEvaluatorResult);
            }
            catch (CompilerException compilerException) {
                String string = "Wrong Expression! ";
                JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
                compilerException.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                String string = "Stack overflow!";
                JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
            }
            catch (NullPointerException nullPointerException) {
                String string = "Specification compiled no successful! " + ((Throwable)nullPointerException).getMessage();
                JOptionPane.showMessageDialog(Interface.getInterface().getPane(), string, "Error", 0);
                nullPointerException.printStackTrace();
            }
        }
    };
    ActionListener debugListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ActionEvaluator.this.corrAction.getText();
            new ActionDebugger(ActionEvaluator.this.actionPerformer, string);
        }
    };

    public void copy() {
        this.corrAction.copy();
    }

    public void cut() {
        this.corrAction.cut();
    }

    public void paste() {
        this.corrAction.paste();
    }

    public void selectAll() {
        this.corrAction.selectAll();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public String getValue() {
        return this.corrAction.getText();
    }

    public String getValue(int n, int n2) throws BadLocationException {
        return this.corrAction.getText(n, n2);
    }

    public void selectText(int n, int n2) {
        this.corrAction.select(n, n2);
    }

    public void replaceTextSelection(String string) {
        this.corrAction.replaceSelection(string);
    }

    public int getCaretPosition() {
        return this.corrAction.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this.corrAction.setCaretPosition(n);
    }

    public String getSelectedText() {
        return this.corrAction.getSelectedText();
    }

    public boolean setVersion(int n) {
        if (n == 1) {
            URL uRL = ClassLoader.getSystemResource("br/ufpe/abaco/ActionInterpreter/actionInterpreterEngine.zip");
            if (uRL == null) {
                System.out.println("Can't Find Action Notation Implementation");
            }
            this.actionPerformer = AbacoExecutionEngine.fromJarFile(uRL);
        } else if (n == 2) {
            // empty if block
        }
        if (this.actionPerformer == null) {
            this.dispose();
        }
        return this.actionPerformer == null;
    }

    public ActionEvaluator(int n) {
        super("Action Editor v" + n, true, true, true, true);
        this.requestFocus();
        this.getContentPane().add(new JScrollPane(this.corrAction));
        this.addInternalFrameListener(new ActionEvaluatorListener());
        this.fileName = null;
        this.setVersion(n);
        this.undoManager.die();
        this.corrAction.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                UndoableEdit undoableEdit = undoableEditEvent.getEdit();
                ActionEvaluator.this.undoManager.addEdit(undoableEditEvent.getEdit());
                Interface.updateUndo(ActionEvaluator.this.undoManager);
            }
        });
    }

    public ActionEvaluator(int n, String string) {
        this(n);
        this.requestFocus();
        this.fileName = string;
        try {
            this.setText(new FileInputStream(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ActionEvaluator(int n, InputStream inputStream) {
        this(n);
        this.requestFocus();
        this.setText(inputStream);
    }

    public void setText(String string) {
        this.corrAction.setText(string);
    }

    public void setText(InputStream inputStream) {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            this.setText(stringBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void activate() {
        JMenuItem jMenuItem = Interface.getInterface().getMenuItem("action perform");
        JMenuItem jMenuItem2 = Interface.getInterface().getMenuItem("export");
        JMenuItem jMenuItem3 = Interface.getInterface().getMenuItem("compile");
        jMenuItem3.setEnabled(false);
        jMenuItem2.setEnabled(false);
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(this.performListener);
        jMenuItem = Interface.getInterface().getMenuItem("action debug");
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(this.debugListener);
        Interface.getInterface().enableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "cut", "paste", "search", "select all", "replace"}));
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.corrAction != null) {
            this.corrAction.requestFocus();
        }
    }

    void deactivate() {
        JMenuItem jMenuItem = Interface.getInterface().getMenuItem("action perform");
        JMenuItem jMenuItem2 = Interface.getInterface().getMenuItem("export");
        JMenuItem jMenuItem3 = Interface.getInterface().getMenuItem("compile");
        jMenuItem3.setEnabled(true);
        jMenuItem2.setEnabled(true);
        jMenuItem.setEnabled(false);
        jMenuItem.removeActionListener(this.performListener);
        jMenuItem = Interface.getInterface().getMenuItem("action debug");
        jMenuItem.setEnabled(false);
        jMenuItem.removeActionListener(this.debugListener);
        OpenedWindows openedWindows = Interface.getInterface().getPane();
        if (openedWindows.getAllFrames().length == 0) {
            Interface.getInterface().enableItens(Interface.getInterface().getMenuItens(new String[]{"copy", "cut", "paste", "search", "select all", "replace"}));
        }
    }

    class ActionEvaluatorListener
    extends InternalFrameAdapter {
        ActionEvaluatorListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ActionEvaluator.this.activate();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            ActionEvaluator.this.deactivate();
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            ActionEvaluator.this.deactivate();
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            ActionEvaluator.this.activate();
        }
    }
}

