/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.ActionInterpreter.Interpreter;
import br.ufpe.abaco.ActionInterpreter.InterpreterListener;
import br.ufpe.abaco.gui.DesktopWindow;
import br.ufpe.abaco.gui.Interface;
import br.ufpe.abaco.runtime.AbacoExecutionEngine;
import br.ufpe.abaco.runtime.Term;
import br.ufpe.abaco.runtime.TermLocation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class ActionDebugger
extends DesktopWindow
implements InterpreterListener {
    AbacoExecutionEngine engine;
    Interpreter interpreter;
    Term action;
    TermLocation actionLocation = new TermLocation();
    String text = null;
    JEditorPane edtAction = new JEditorPane();
    JEditorPane edtIncome = new JEditorPane();
    JEditorPane edtOutcome = new JEditorPane();
    DefaultHighlighter selected = new DefaultHighlighter();
    JSplitPane pane2;
    JSplitPane pane1;
    JButton bttStep = new JButton("Step");
    JPanel panButton = new JPanel();
    Stack incomes = new Stack();
    boolean waited = false;
    boolean endOfPerformance = false;

    synchronized void performWait() {
        this.waited = true;
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.waited = false;
    }

    synchronized void performNext() {
        if (this.endOfPerformance) {
            JOptionPane.showMessageDialog(Interface.getInterface().getPane(), "Performance Already Finished", "Error", 0);
        } else if (this.waited) {
            this.notify();
        }
    }

    public void startPerformance(Term term, String string) {
        int n = this.actionLocation.getBegin(term);
        int n2 = this.actionLocation.getEnd(term);
        if (n != -1 && n2 != -1) {
            this.selected.removeAllHighlights();
            try {
                this.selected.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(Color.cyan));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.edtIncome.setText("Income:\n\n" + string);
            this.edtOutcome.setText("");
            this.incomes.push(string);
            this.performWait();
        } else {
            this.edtAction.select(0, 0);
            this.edtIncome.setText("");
        }
    }

    public void endPerformance(Term term, String string, boolean bl) {
        int n = this.actionLocation.getBegin(term);
        int n2 = this.actionLocation.getEnd(term);
        if (n != -1 && n2 != -1) {
            this.selected.removeAllHighlights();
            try {
                this.selected.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(bl ? Color.green : Color.red));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.edtIncome.setText("Income:\n\n" + this.incomes.pop());
            this.edtOutcome.setText(string);
            this.performWait();
        } else {
            this.edtAction.select(0, 0);
            this.edtIncome.setText("");
        }
    }

    public ActionDebugger(AbacoExecutionEngine abacoExecutionEngine, String string) {
        super("Action Debugger", true, true, true, true);
        this.engine = abacoExecutionEngine.copy();
        this.interpreter = (Interpreter)this.engine.getProperty("abaco.ActionInterpreter");
        try {
            this.action = this.engine.parse(string).copy();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error", 0);
            this.dispose();
            return;
        }
        String string2 = this.engine.print(this.action, this.actionLocation);
        this.edtAction.setText(string2);
        this.interpreter.setListener(this);
        System.out.println("Action = \n" + string2 + "\n Locations = \n" + this.actionLocation);
        this.edtAction.setEditable(false);
        this.edtIncome.setEditable(false);
        this.edtOutcome.setEditable(false);
        this.pane2 = new JSplitPane(0, false, new JScrollPane(this.edtIncome), new JScrollPane(this.edtOutcome));
        this.pane1 = new JSplitPane(1, false, new JScrollPane(this.edtAction), this.pane2);
        this.setSize(600, 400);
        this.pane1.setDividerLocation(300);
        this.pane2.setDividerLocation(200);
        this.getContentPane().add((Component)this.pane1, "Center");
        this.getContentPane().add((Component)this.panButton, "South");
        this.panButton.add(this.bttStep);
        this.bttStep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionDebugger.this.performNext();
            }
        });
        this.edtAction.setHighlighter(this.selected);
        new Thread(){

            public void run() {
                ActionDebugger.this.engine.run(ActionDebugger.this.engine.getOperator("perform _"), ActionDebugger.this.action);
                ActionDebugger.this.endOfPerformance = true;
            }
        }.start();
    }

    public void dispose() {
        super.dispose();
    }
}

