/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import br.ufpe.abaco.gui.AbacoTreeListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AbacoTreeViewer
extends JTree
implements ActionListener,
TreeSelectionListener,
MouseListener,
TreeModel {
    TreeModelListener lt = null;
    Node mainNode = new Node(null, "", "");
    boolean firstInsertion = true;
    JTree tree = this;
    AbacoTreeListener eventHandler;
    static int numero = 0;
    JPopupMenu menuCase1 = null;
    JPopupMenu menuCase2 = null;
    JPopupMenu menuCase3 = null;
    JPopupMenu menuCase4 = null;

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.lt = this.lt != null ? new TreeModelMulticast(this.lt, treeModelListener) : treeModelListener;
        this.updateList();
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.lt instanceof TreeModelMulticast) {
            TreeModelMulticast treeModelMulticast = (TreeModelMulticast)this.lt;
            this.lt = treeModelMulticast.remove(treeModelListener);
        } else if (this.lt == treeModelListener) {
            this.lt = null;
        }
    }

    public Object getChild(Object object, int n) {
        Node node = (Node)object;
        return node.childs.elementAt(n);
    }

    public int getChildCount(Object object) {
        Node node = (Node)object;
        return node.childs.size();
    }

    public int getIndexOfChild(Object object, Object object2) {
        Node node = (Node)object;
        int n = 0;
        while (n < node.childs.size()) {
            if (node.childs.elementAt(n) == object2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Object getRoot() {
        return this.mainNode;
    }

    public boolean isLeaf(Object object) {
        Node node = (Node)object;
        return node.childs.size() == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    void insertItem(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node = this.mainNode;
        while (stringTokenizer.hasMoreTokens()) {
            node = node.get(stringTokenizer.nextToken());
        }
        node.setFullPath(string);
        if (this.firstInsertion) {
            this.updateList();
            this.firstInsertion = false;
        }
    }

    void removeItem(String string) {
        if (this.getSelection().equals(string)) {
            this.setSelectionPath(null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node = this.mainNode;
        while (stringTokenizer.hasMoreTokens()) {
            node = node.get(stringTokenizer.nextToken());
        }
        if (node.childs.size() > 0) {
            node.setFullPath(null);
        } else {
            node.parent.remove(node);
        }
    }

    void removeItemRecursively(String string) {
        String string2 = this.getSelection();
        if (string2 != null && string2.startsWith(string)) {
            this.setSelectionPath(null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node = this.mainNode;
        while (stringTokenizer.hasMoreTokens()) {
            node = node.get(stringTokenizer.nextToken());
        }
        node.parent.remove(node);
    }

    public void removeAll() {
        this.mainNode = new Node(null, "", "");
        this.updateList();
        this.firstInsertion = true;
    }

    void updateList() {
        if (this.lt != null) {
            this.lt.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.mainNode)));
        }
    }

    void addAbacoTreeListener(AbacoTreeListener abacoTreeListener) {
        this.eventHandler = abacoTreeListener;
    }

    AbacoTreeViewer(boolean bl) {
        this.tree.setModel(null);
        this.tree.setModel(this);
        MyCellRenderer myCellRenderer = new MyCellRenderer();
        ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/spec.gif"));
        myCellRenderer.setLeafIcon(imageIcon);
        myCellRenderer.setOpenIcon(imageIcon);
        myCellRenderer.setClosedIcon(imageIcon);
        this.tree.setCellRenderer(myCellRenderer);
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        JFrame jFrame = new JFrame("Teste");
        final AbacoTreeViewer abacoTreeViewer = new AbacoTreeViewer(true);
        abacoTreeViewer.insertItem("A/Opcao 1");
        abacoTreeViewer.insertItem("A/Opcao 2");
        abacoTreeViewer.insertItem("C/C/Opcao 4");
        abacoTreeViewer.insertItem("C/Opcao 3");
        abacoTreeViewer.insertItem("A/Opcao 5");
        abacoTreeViewer.insertItem("B/WOpcao 1");
        abacoTreeViewer.insertItem("C/WOpcao 2");
        abacoTreeViewer.insertItem("A/WOpcao 4");
        abacoTreeViewer.insertItem("B/WOpcao 3");
        abacoTreeViewer.insertItem("A/WOpcao 5");
        abacoTreeViewer.insertItem("C/AOpcao 1");
        abacoTreeViewer.insertItem("A/AOpcao 2");
        abacoTreeViewer.insertItem("B/AOpcao 4");
        abacoTreeViewer.insertItem("A/AOpcao 3");
        abacoTreeViewer.insertItem("B/AOpcao 5");
        abacoTreeViewer.insertMenuItem("Delete", true, true, false);
        abacoTreeViewer.insertMenuItem("Delete Recursive", false, true, false);
        abacoTreeViewer.insertMenuItem("Insert", true, true, true);
        abacoTreeViewer.insertMenuItem("Save", true, true, true);
        abacoTreeViewer.addAbacoTreeListener(new AbacoTreeListener(){

            public void selected(String string) {
                System.out.println("Selecionado " + string);
            }

            public void doubleSelected(String string) {
                System.out.println("Duplo Selecionado " + string);
            }

            public void actionMenu(String string, String string2) {
                System.out.println("Action=" + string);
                if (string.equals("Delete")) {
                    abacoTreeViewer.removeItem(string2);
                } else if (string.equals("Insert")) {
                    abacoTreeViewer.insertItem(string2 + "L");
                }
            }
        });
        jFrame.getContentPane().add((Component)new JScrollPane(abacoTreeViewer), "Center");
        ((Component)jFrame).setSize(500, 400);
        jFrame.show(true);
    }

    String getSelection() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return ((Node)treePath.getLastPathComponent()).fullPath;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Node node = (Node)treeSelectionEvent.getPath().getLastPathComponent();
        if (node.fullPath != null && this.eventHandler != null) {
            this.eventHandler.selected(node.fullPath);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            JPopupMenu jPopupMenu;
            Object object;
            TreePath treePath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && !((Rectangle)(object = this.tree.getPathBounds(treePath))).contains(mouseEvent.getX(), mouseEvent.getY())) {
                treePath = null;
            }
            if (treePath == null) {
                jPopupMenu = this.menuCase3;
                this.tree.setSelectionPath(null);
            } else {
                this.tree.setSelectionPath(treePath);
                object = (Node)treePath.getLastPathComponent();
                jPopupMenu = ((Node)object).fullPath == null ? this.menuCase2 : (((Node)object).childs.size() > 0 ? this.menuCase4 : this.menuCase1);
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getClickCount() == 2 && this.eventHandler != null && this.getSelection() != null) {
            this.eventHandler.doubleSelected(this.getSelection());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void insertMenuItem(String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (this.menuCase1 == null) {
                this.menuCase1 = new JPopupMenu();
            }
            this.menuCase1.add(string).addActionListener(this);
        }
        if (bl2) {
            if (this.menuCase2 == null) {
                this.menuCase2 = new JPopupMenu();
            }
            this.menuCase2.add(string).addActionListener(this);
        }
        if (bl3) {
            if (this.menuCase3 == null) {
                this.menuCase3 = new JPopupMenu();
            }
            this.menuCase3.add(string).addActionListener(this);
        }
        if (bl2 || bl) {
            if (this.menuCase4 == null) {
                this.menuCase4 = new JPopupMenu();
            }
            this.menuCase4.add(string).addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = this.tree.getSelectionPath();
        String string = null;
        if (treePath != null) {
            Object[] objectArray = treePath.getPath();
            string = "";
            int n = 0;
            while (n < objectArray.length) {
                string = string + objectArray[n].toString();
                ++n;
            }
        }
        if (this.eventHandler != null) {
            this.eventHandler.actionMenu(actionEvent.getActionCommand(), string);
        }
    }

    class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon specificationNode = new ImageIcon(ClassLoader.getSystemResource("br/ufpe/abaco/icons/spec.gif"));

        MyCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Node node;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof Node && (node = (Node)object).fullPath == null) {
                this.setIcon(null);
                this.setDisabledIcon(null);
            }
            return component;
        }
    }

    static class TreeModelMulticast
    implements TreeModelListener {
        TreeModelListener l1;
        TreeModelListener l2;

        TreeModelListener remove(TreeModelListener treeModelListener) {
            TreeModelListener treeModelListener2 = this.l1 instanceof TreeModelMulticast ? ((TreeModelMulticast)this.l1).remove(treeModelListener) : this.l1;
            TreeModelListener treeModelListener3 = this.l2 instanceof TreeModelMulticast ? ((TreeModelMulticast)this.l2).remove(treeModelListener) : this.l2;
            if (treeModelListener2 == treeModelListener) {
                return treeModelListener2;
            }
            if (treeModelListener3 == treeModelListener) {
                return treeModelListener3;
            }
            if (treeModelListener2 != this.l1 && treeModelListener3 != this.l2) {
                return new TreeModelMulticast(treeModelListener2, treeModelListener3);
            }
            return this;
        }

        TreeModelMulticast(TreeModelListener treeModelListener, TreeModelListener treeModelListener2) {
            this.l1 = treeModelListener;
            this.l2 = treeModelListener2;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.l1.treeNodesChanged(treeModelEvent);
            this.l2.treeNodesChanged(treeModelEvent);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.l1.treeNodesInserted(treeModelEvent);
            this.l2.treeNodesInserted(treeModelEvent);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.l1.treeNodesRemoved(treeModelEvent);
            this.l2.treeNodesRemoved(treeModelEvent);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.l1.treeNodesChanged(treeModelEvent);
            this.l2.treeStructureChanged(treeModelEvent);
        }
    }

    class Node {
        TreePath nodePath;
        Node parent;
        Vector childs = new Vector();
        String label;
        private String fullPath;

        Node(Node node, String string, String string2) {
            this.parent = node;
            this.label = string;
            this.fullPath = string2;
            if (node != null) {
                Object[] objectArray = node.nodePath.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                int n = 0;
                while (n < objectArray.length) {
                    objectArray2[n] = objectArray[n];
                    ++n;
                }
                objectArray2[objectArray.length] = this;
                this.nodePath = new TreePath(objectArray2);
            } else {
                this.nodePath = new TreePath(this);
            }
        }

        Node get(String string) {
            int n = 0;
            while (n < this.childs.size()) {
                Node node = (Node)this.childs.elementAt(n);
                int n2 = node.label.compareTo(string);
                if (n2 == 0) {
                    return node;
                }
                if (n2 > 0) {
                    Node node2 = new Node(this, string, null);
                    this.childs.insertElementAt(node2, n);
                    if (AbacoTreeViewer.this.lt != null) {
                        AbacoTreeViewer.this.lt.treeNodesInserted(new TreeModelEvent((Object)this, this.nodePath, new int[]{n}, new Object[]{node2}));
                    }
                    return node2;
                }
                ++n;
            }
            Node node = new Node(this, string, null);
            this.childs.addElement(node);
            if (AbacoTreeViewer.this.lt != null) {
                if (this.childs.size() == 1) {
                    AbacoTreeViewer.this.lt.treeNodesChanged(new TreeModelEvent((Object)this, this.nodePath));
                }
                AbacoTreeViewer.this.lt.treeNodesInserted(new TreeModelEvent((Object)this, this.nodePath, new int[]{this.childs.size() - 1}, new Object[]{node}));
            }
            return node;
        }

        void setFullPath(String string) {
            this.fullPath = string;
            if (AbacoTreeViewer.this.lt != null) {
                AbacoTreeViewer.this.lt.treeNodesChanged(new TreeModelEvent((Object)this, this.nodePath));
            }
        }

        String fullPath() {
            return this.fullPath;
        }

        void remove(Node node) {
            int n = 0;
            while (n < this.childs.size()) {
                if (this.childs.elementAt(n) == node) {
                    this.childs.remove(node);
                    if (AbacoTreeViewer.this.lt != null) {
                        AbacoTreeViewer.this.lt.treeNodesRemoved(new TreeModelEvent((Object)this, this.nodePath, new int[]{n}, new Object[]{node}));
                    }
                    if (this.fullPath == null && this.childs.size() == 0) {
                        this.parent.remove(this);
                    }
                }
                ++n;
            }
        }

        public String toString() {
            return this.label;
        }
    }
}

