/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class AbacoTextEditor
extends JTextArea
implements FocusListener {
    ActionListener tildeListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            AbacoTextEditor.this.replaceSelection("~");
        }
    };
    ActionListener enterListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = AbacoTextEditor.this.getText();
            int n2 = n = AbacoTextEditor.this.getCaretPosition();
            while (n2 > 0) {
                if (string.charAt(n2 - 1) == '\n') break;
                --n2;
            }
            int n3 = n2;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c != ' ' && c != '\t' && c != '|') break;
                ++n3;
            }
            if (n3 > n) {
                n3 = n;
            }
            if (n2 > n3) {
                AbacoTextEditor.this.replaceSelection("\n");
            } else {
                AbacoTextEditor.this.replaceSelection("\n" + string.substring(n2, n3));
            }
        }
    };
    static AbacoTextEditor currEditor = null;

    AbacoTextEditor() {
        this.registerKeyboardAction(this.tildeListener, KeyStroke.getKeyStroke("alt T"), 0);
        this.registerKeyboardAction(this.enterListener, KeyStroke.getKeyStroke("alt ENTER"), 0);
    }

    public void focusGained(FocusEvent focusEvent) {
        System.out.println("Focus");
        currEditor = this;
    }

    public void focusLost(FocusEvent focusEvent) {
        currEditor = null;
    }

    public static void sCopy() {
        if (currEditor != null) {
            currEditor.copy();
        }
    }

    public static void sCut() {
        if (currEditor != null) {
            currEditor.cut();
        }
    }

    public static void sPaste() {
        if (currEditor != null) {
            currEditor.paste();
        }
    }

    public static void sSelectAll() {
        if (currEditor != null) {
            currEditor.selectAll();
        }
    }
}

