/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.compiler;

import br.ufpe.abaco.Benchmark;
import br.ufpe.abaco.EspecParser.ASTNeeds;
import br.ufpe.abaco.EspecParser.ASTSpecification;
import br.ufpe.abaco.EspecParser.ParseException;
import br.ufpe.abaco.EspecParser.UnifiedAlgebrasParser;
import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.compiler.PrintListener;
import br.ufpe.abaco.compiler.Specification;
import br.ufpe.abaco.compiler.SpecificationSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class SpecificationCompiler {
    public static PrintStream out = new PrintStream(new OutputStream(){

        public void write(int n) {
            if (currentListener != null) {
                currentListener.writeChar((char)n);
            }
        }
    });
    public static PrintStream err = new PrintStream(new OutputStream(){

        public void write(int n) {
            if (currentListener != null) {
                currentListener.writeChar((char)n);
                currentListener.setError(true);
            }
        }
    });
    static PrintListener currentListener = null;

    public static void setListener(PrintListener printListener) {
        currentListener = printListener;
    }

    public static Specification compile(SpecificationSource specificationSource, String string) throws IOException, ParseException, CompilerException {
        Benchmark.start();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        HashMap<String, ASTSpecification> hashMap = new HashMap<String, ASTSpecification>();
        ASTSpecification aSTSpecification = null;
        vector.addElement("preface");
        vector.addElement(string);
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n++);
            out.println("Parsing Specification: " + string2);
            InputStream inputStream = specificationSource.getSpecification(string2);
            if (inputStream == null) {
                throw new IOException("Specification " + string2 + " not found!!!");
            }
            UnifiedAlgebrasParser unifiedAlgebrasParser = new UnifiedAlgebrasParser(inputStream);
            unifiedAlgebrasParser.fileName(string2);
            ASTSpecification aSTSpecification2 = unifiedAlgebrasParser.spec();
            hashMap.put(string2, aSTSpecification2);
            if (aSTSpecification == null) {
                unifiedAlgebrasParser = new UnifiedAlgebrasParser(specificationSource.getSpecification(string2));
                aSTSpecification2 = unifiedAlgebrasParser.spec();
            }
            ASTNeeds aSTNeeds = (ASTNeeds)aSTSpecification2.jjtGetChild(1);
            int n2 = 0;
            while (n2 < aSTNeeds.arity()) {
                string2 = aSTNeeds.jjtGetChild(n2).toString();
                if (!vector.contains(string2)) {
                    vector.addElement(string2);
                }
                ++n2;
            }
            if (aSTSpecification == null) {
                aSTSpecification = aSTSpecification2;
                continue;
            }
            aSTSpecification.union(aSTSpecification2);
        }
        Benchmark.mark("Fim da Leitura dos Arquivos");
        return new Specification(hashMap, aSTSpecification);
    }
}

