/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.compiler;

import br.ufpe.abaco.compiler.JavaCompiler;
import br.ufpe.agool.code.AgoolClassLoader;
import br.ufpe.agool.code.ByteArrayClassBag;
import br.ufpe.agool.java.AgoolJavaFacade;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class AgoolJavaCompiler
implements JavaCompiler {
    StringBuffer producedSource = new StringBuffer();
    String prefix;
    String filename = null;
    StringBuffer currentClassSource = new StringBuffer();
    AgoolClassLoader loader;
    Hashtable source = new Hashtable();

    AgoolJavaCompiler() {
    }

    public void setPrefix(String string) {
        this.producedSource.append(string);
        this.prefix = string;
    }

    public void filename(String string) {
        if (this.filename != null) {
            this.close();
        }
        this.filename = string;
        this.currentClassSource = new StringBuffer(this.prefix);
    }

    public void append(String string) {
        this.currentClassSource.append(string);
        this.producedSource.append(string);
    }

    public void append(char c) {
        this.currentClassSource.append(c);
        this.producedSource.append(c);
    }

    public void close() {
        this.source.put(this.filename, this.currentClassSource.toString());
        this.currentClassSource = null;
        this.filename = null;
    }

    public ClassLoader compile() {
        AgoolJavaFacade agoolJavaFacade = new AgoolJavaFacade();
        String string = this.producedSource.toString();
        try {
            this.loader = agoolJavaFacade.compileToClass(string);
        }
        catch (Exception exception) {
            System.out.println("Error : " + exception);
            exception.printStackTrace();
            return null;
        }
        return this.loader;
    }

    public void generateJarImplementation(String string, Serializable serializable, boolean bl) {
        try {
            Object object;
            Object object2;
            Object object3;
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(string));
            Iterator iterator = this.source.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (String)this.source.get(object3);
                jarOutputStream.putNextEntry(new ZipEntry((String)object3));
                jarOutputStream.write(((String)object2).getBytes());
                jarOutputStream.closeEntry();
            }
            object3 = this.loader.classBag();
            iterator = ((ByteArrayClassBag)object3).keys();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = new ZipEntry((String)object2 + ".class");
                byte[] byArray = ((ByteArrayClassBag)object3).getBytes((String)object2);
                ((ZipEntry)object).setSize(byArray.length);
                jarOutputStream.putNextEntry((ZipEntry)object);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
            }
            if (bl) {
                AgoolJavaCompiler.saveRuntimeLibrary(jarOutputStream);
            }
            AgoolJavaCompiler.saveClassFile("GuiApplet.class", jarOutputStream);
            AgoolJavaCompiler.saveClassFile("GuiApplet$1.class", jarOutputStream);
            AgoolJavaCompiler.saveClassFile("GuiApplet$StringStack.class", jarOutputStream);
            object2 = new ZipEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry((ZipEntry)object2);
            object = "Manifest-Version: 1.0\nMain-Class: GuiApplet\nClass-Path: runtime.jar\n\n";
            jarOutputStream.write(((String)object).getBytes());
            jarOutputStream.closeEntry();
            jarOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error !!!");
            iOException.printStackTrace();
        }
    }

    static void saveRuntimeLibrary(ZipOutputStream zipOutputStream) throws IOException {
        URL uRL = ClassLoader.getSystemResource("AbacoLibraryFiles.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[256];
        int n = inputStreamReader.read(cArray);
        while (n > 0) {
            stringBuffer.append(cArray, 0, n);
            n = inputStreamReader.read(cArray);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            AgoolJavaCompiler.saveClassFile(string, zipOutputStream);
        }
    }

    static void saveClassFile(String string, ZipOutputStream zipOutputStream) throws IOException {
        URL uRL = ClassLoader.getSystemResource(string);
        InputStream inputStream = uRL.openStream();
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        int n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
    }
}

