/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.parser;

import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.LRItem;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.SemanticAction;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;

public class Production
implements Serializable {
    public static final int LEFT_ASSOCIATIVE = 1;
    public static final int RIGHT_ASSOCIATIVE = 2;
    public static final int ANY_ASSOCIATIVE = 3;
    public static final int NON_ASSOCIATIVE = 4;
    public static final int DEFAULT_ASSOCIATIVITY = 3;
    private static SemanticAction DEFAULT_ACTION = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return new Object();
        }
    };
    private BNFGrammar grammar;
    private NonTerminalSymbol leftSide;
    private GrammarSymbol[] rightSide;
    private SemanticAction action;
    private int reducePrecedence;
    private int shiftPrecedence;
    private int associativity = 3;
    final LRItem[] items;
    final int index;

    Production(BNFGrammar bNFGrammar, NonTerminalSymbol nonTerminalSymbol, int n) {
        this(bNFGrammar, nonTerminalSymbol, new GrammarSymbol[0], n, 0, 3);
    }

    Production(BNFGrammar bNFGrammar, NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray, int n, int n2, int n3) {
        this.grammar = bNFGrammar;
        this.leftSide = nonTerminalSymbol;
        this.rightSide = grammarSymbolArray;
        this.index = n;
        this.action = DEFAULT_ACTION;
        this.items = new LRItem[grammarSymbolArray.length + 1];
        int n4 = 0;
        while (n4 < this.items.length) {
            this.items[n4] = new LRItem(this, n4);
            if (n4 > 0) {
                this.items[n4 - 1].next = this.items[n4];
            }
            ++n4;
        }
        n2 += n2;
        if (n3 == 1) {
            this.setPrecedence(n2 - 1, n2);
        } else if (n3 == 2) {
            this.setPrecedence(n2, n2 - 1);
        } else {
            this.setPrecedence(n2);
        }
        this.associativity = n3;
    }

    Production(BNFGrammar bNFGrammar, NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray, int n, int n2) {
        this(bNFGrammar, nonTerminalSymbol, grammarSymbolArray, n, n2, 0);
    }

    Production(BNFGrammar bNFGrammar, NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray, int n) {
        this(bNFGrammar, nonTerminalSymbol, grammarSymbolArray, n, 0, 0);
    }

    public void setSemanticAction(SemanticAction semanticAction) {
        this.action = semanticAction;
    }

    public void setPrecedence(int n) {
        this.shiftPrecedence = this.reducePrecedence = n;
    }

    public void setPrecedence(int n, int n2) {
        this.shiftPrecedence = n;
        this.reducePrecedence = n2;
    }

    public int getPrecedence() {
        return this.reducePrecedence;
    }

    public int getShiftPrecedence() {
        return this.shiftPrecedence;
    }

    public int getReducePrecedence() {
        return this.reducePrecedence;
    }

    public NonTerminalSymbol getLeftSide() {
        return this.leftSide;
    }

    public GrammarSymbol[] getRightSide() {
        return this.rightSide;
    }

    public TerminalSymbol getRigthMostTerminalSymbol() {
        TerminalSymbol terminalSymbol = null;
        int n = 0;
        while (n < this.rightSide.length) {
            GrammarSymbol grammarSymbol = this.rightSide[n];
            if (grammarSymbol instanceof TerminalSymbol) {
                terminalSymbol = (TerminalSymbol)grammarSymbol;
                break;
            }
            ++n;
        }
        return terminalSymbol;
    }

    public SemanticAction getSemanticAction() {
        return this.action;
    }

    public BNFGrammar getGrammar() {
        return this.grammar;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.leftSide.toString());
        stringBuffer.append(" ::= ");
        if (this.rightSide.length == 0) {
            stringBuffer.append("-empty-");
        } else {
            int n = 0;
            while (n < this.rightSide.length) {
                stringBuffer.append(' ');
                stringBuffer.append(this.rightSide[n].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Production)) {
            return false;
        }
        Production production = (Production)object;
        if (this.leftSide != production.leftSide) {
            return false;
        }
        if (this.rightSide.length != production.rightSide.length) {
            return false;
        }
        int n = 0;
        while (n < this.rightSide.length) {
            if (this.rightSide[n] != production.rightSide[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getAssociativity() {
        return this.associativity;
    }
}

