/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.lexer;

import br.ufpe.abaco.ParserGen.lexer.ArrayOps;
import br.ufpe.abaco.ParserGen.lexer.CharExp;
import br.ufpe.abaco.ParserGen.lexer.FinalExp;
import br.ufpe.abaco.ParserGen.lexer.RejectExp;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.Serializable;

public class RegExp
implements Serializable {
    static RegExp[] emptyList = new RegExp[0];
    static int lastId = 0;
    int id = lastId++;
    String label = "???";
    boolean vazio;
    RegExp[] first = emptyList;
    RegExp[] last = emptyList;
    RegExp[] follow = emptyList;
    static RegExp[] emptyTerm = new RegExp[0];
    RegExp[] subTerms = emptyTerm;
    static final char LAST_CHARACTER = '\u00ff';
    static final char CHOICE = '|';
    static final char SEQUENCE = '.';
    static final char ZERO_MANY = '*';
    static final char ONE_MANY = '+';
    static final char ZERO_ONE = '?';
    RegExp r1;
    RegExp r2;
    char type;

    void insertFollows(RegExp[] regExpArray) {
        this.follow = ArrayOps.concat(this.follow, regExpArray);
    }

    public static RegExp any() {
        return new CharExp('\u0000', '\u00ff');
    }

    public static RegExp notCharacter(char c) {
        return RegExp.choice(new CharExp('\u0000', (char)(c - '\u0001')), new CharExp((char)(c + '\u0001'), '\u00ff'));
    }

    public static RegExp charExp(char c) {
        return new CharExp(c);
    }

    public static RegExp charExp(char c, char c2) {
        return new CharExp(c, c2);
    }

    public static RegExp produce(TerminalSymbol terminalSymbol) {
        return new FinalExp(terminalSymbol);
    }

    public static RegExp reject(TerminalSymbol terminalSymbol) {
        return new RejectExp(terminalSymbol);
    }

    public static RegExp empty() {
        RegExp regExp = new RegExp();
        regExp.label = "\"\"";
        regExp.vazio = true;
        regExp.first = emptyList;
        regExp.last = emptyList;
        return regExp;
    }

    public static RegExp string(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length == 0) {
            return RegExp.empty();
        }
        RegExp regExp = RegExp.charExp((char)byArray[byArray.length - 1]);
        int n = byArray.length - 2;
        while (n >= 0) {
            regExp = RegExp.sequence(RegExp.charExp((char)byArray[n]), regExp);
            --n;
        }
        return regExp;
    }

    public static RegExp sequence(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.label = regExp.label + regExp2.label;
        regExp3.vazio = regExp.vazio && regExp2.vazio;
        regExp3.first = regExp.vazio ? ArrayOps.concat(regExp.first, regExp2.first) : regExp.first;
        regExp3.last = regExp2.vazio ? ArrayOps.concat(regExp.last, regExp2.last) : regExp2.last;
        regExp3.subTerms = new RegExp[]{regExp, regExp2};
        int n = 0;
        while (n < regExp.last.length) {
            regExp.last[n].insertFollows(regExp2.first);
            ++n;
        }
        regExp3.type = (char)46;
        regExp3.r1 = regExp;
        regExp3.r2 = regExp2;
        return regExp3;
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.label = "( " + regExp.label + " )|( " + regExp2.label + " )";
        regExp3.vazio = regExp.vazio || regExp2.vazio;
        regExp3.first = ArrayOps.concat(regExp.first, regExp2.first);
        regExp3.last = ArrayOps.concat(regExp.last, regExp2.last);
        regExp3.subTerms = new RegExp[]{regExp, regExp2};
        regExp3.type = (char)124;
        regExp3.r1 = regExp;
        regExp3.r2 = regExp2;
        return regExp3;
    }

    public static RegExp sequence(RegExp regExp, RegExp regExp2, RegExp regExp3) {
        return RegExp.sequence(regExp, RegExp.sequence(regExp2, regExp3));
    }

    public static RegExp sequence(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4) {
        return RegExp.sequence(regExp, RegExp.sequence(regExp2, RegExp.sequence(regExp3, regExp4)));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3) {
        return RegExp.choice(regExp, RegExp.choice(regExp2, regExp3));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4) {
        return RegExp.choice(regExp, RegExp.choice(regExp2, RegExp.choice(regExp3, regExp4)));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4, RegExp regExp5) {
        return RegExp.choice(regExp, RegExp.choice(regExp2, RegExp.choice(regExp3, RegExp.choice(regExp4, regExp5))));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4, RegExp regExp5, RegExp regExp6) {
        return RegExp.choice(RegExp.choice(regExp, regExp2, regExp3), RegExp.choice(regExp4, regExp5, regExp6));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4, RegExp regExp5, RegExp regExp6, RegExp regExp7) {
        return RegExp.choice(RegExp.choice(regExp, regExp2, regExp3), RegExp.choice(regExp4, regExp5, regExp6, regExp7));
    }

    public static RegExp choice(RegExp regExp, RegExp regExp2, RegExp regExp3, RegExp regExp4, RegExp regExp5, RegExp regExp6, RegExp regExp7, RegExp regExp8) {
        return RegExp.choice(RegExp.choice(regExp, regExp2, regExp3), RegExp.choice(regExp4, regExp5, regExp6, regExp7, regExp8));
    }

    public static RegExp oneMany(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.label = "( " + regExp.label + " )+";
        regExp2.vazio = regExp.vazio;
        regExp2.first = regExp.first;
        regExp2.last = regExp.last;
        int n = 0;
        while (n < regExp.last.length) {
            regExp.last[n].insertFollows(regExp.first);
            ++n;
        }
        regExp2.subTerms = new RegExp[]{regExp};
        regExp2.type = (char)43;
        regExp2.r1 = regExp;
        return regExp2;
    }

    public static RegExp zeroMany(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.label = "( " + regExp.label + " )*";
        regExp2.vazio = true;
        regExp2.first = regExp.first;
        regExp2.last = regExp.last;
        int n = 0;
        while (n < regExp.last.length) {
            regExp.last[n].insertFollows(regExp.first);
            ++n;
        }
        regExp2.subTerms = new RegExp[]{regExp};
        regExp2.type = (char)42;
        regExp2.r1 = regExp;
        return regExp2;
    }

    public static RegExp zeroOne(RegExp regExp) {
        RegExp regExp2 = RegExp.choice(regExp, RegExp.empty());
        regExp2.type = (char)63;
        regExp2.r1 = regExp;
        return regExp2;
    }

    public String toString() {
        String string = "";
        switch (this.type) {
            case '|': {
                string = "(" + this.r1 + "|" + this.r2 + ")";
                break;
            }
            case '.': {
                string = "(" + this.r1 + "." + this.r2 + ")";
                break;
            }
            case '*': {
                string = "(" + this.r1 + ")*";
                break;
            }
            case '+': {
                string = "(" + this.r1 + ")+";
                break;
            }
            case '?': {
                string = "(" + this.r1 + ")?";
            }
        }
        return string;
    }

    public String toString(String string) {
        String string2 = string + this.label + "{ vazio = " + this.vazio + "  first " + ArrayOps.print(this.first) + ", last " + ArrayOps.print(this.last) + ", follow = " + ArrayOps.print(this.follow) + " \n";
        int n = 0;
        while (n < this.subTerms.length) {
            string2 = string2 + this.subTerms[n].toString(string + "  ");
            ++n;
        }
        return string2;
    }
}

