/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen.lexer;

import br.ufpe.abaco.ParserGen.lexer.ArrayOps;
import br.ufpe.abaco.ParserGen.lexer.CharExp;
import br.ufpe.abaco.ParserGen.lexer.CharManager;
import br.ufpe.abaco.ParserGen.lexer.FinalExp;
import br.ufpe.abaco.ParserGen.lexer.RegExp;
import br.ufpe.abaco.ParserGen.lexer.RejectExp;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Vector;

class LexicalProcessor
implements Serializable {
    CharManager classifier = new CharManager();
    PrintWriter pw;
    RegExp r;
    int nDefinitions = 0;
    State startState;
    int lastState = 0;
    int getStateCalls = 0;
    State[] states = new State[1000];
    int nStates = 0;

    void findClasses(RegExp regExp) {
        if (regExp instanceof CharExp) {
            CharExp charExp = (CharExp)regExp;
            this.classifier.insertClass(charExp.start, charExp.end);
        } else {
            int n = 0;
            while (n < regExp.subTerms.length) {
                this.findClasses(regExp.subTerms[n]);
                ++n;
            }
        }
    }

    void findDefinitions(RegExp regExp) {
        if (regExp instanceof CharExp || regExp instanceof FinalExp) {
            ++this.nDefinitions;
        } else {
            int n = 0;
            while (n < regExp.subTerms.length) {
                this.findDefinitions(regExp.subTerms[n]);
                ++n;
            }
        }
    }

    State getState(RegExp[] regExpArray) {
        ++this.getStateCalls;
        int n = 0;
        int n2 = this.nStates - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = ArrayOps.compare(regExpArray, this.states[n3].definition);
            if (n4 == 0) {
                return this.states[n3];
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 >= 0) continue;
            n2 = n3 - 1;
        }
        State state = new State(regExpArray);
        int n5 = this.nStates;
        while (n5 > 0) {
            if (ArrayOps.compare(regExpArray, this.states[n5 - 1].definition) >= 0) {
                this.states[n5] = state;
                this.states[n5].state = n5;
                ++this.nStates;
                return state;
            }
            this.states[n5] = this.states[n5 - 1];
            this.states[n5].state = n5;
            --n5;
        }
        this.states[0] = state;
        this.states[0].state = 0;
        ++this.nStates;
        return state;
    }

    public LexicalProcessor() {
    }

    public LexicalProcessor(RegExp regExp) {
        this.setRegularExpression(regExp);
    }

    public void setRegularExpression(RegExp regExp) {
        this.r = regExp;
        this.findClasses(regExp);
        this.classifier.compile();
        this.startState = this.getState(regExp.first);
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < this.nStates) {
                if (!this.states[n].processed) {
                    this.states[n].processed = true;
                    this.states[n].process();
                    bl = true;
                }
                ++n;
            }
        }
    }

    boolean process(String string) {
        int n = -1;
        Object var3_3 = null;
        byte[] byArray = string.getBytes();
        int n2 = 0;
        int[] nArray = this.classifier.lookupTable;
        int n3 = byArray.length;
        State state = this.startState;
        while (n2 < n3) {
            int n4 = nArray[byArray[n2]];
            if (n4 == -1) {
                return false;
            }
            state = state.links[n4];
            if (state == null) {
                return false;
            }
            ++n2;
        }
        return state.finalState;
    }

    boolean process(String string, Vector vector) {
        return this.process(string, vector, -1);
    }

    boolean process(String string, Vector vector, int n) {
        byte[] byArray = string.getBytes();
        int[] nArray = this.classifier.lookupTable;
        int n2 = byArray.length;
        int n3 = -1;
        State state = null;
        Token token = null;
        int n4 = 0;
        int n5 = 0;
        State state2 = this.startState;
        while (n5 <= n2) {
            Token token2;
            TerminalSymbol[] terminalSymbolArray;
            if (n5 == n2) {
                if (state == null) {
                    return false;
                }
                terminalSymbolArray = state.getTokensTypes();
                if (terminalSymbolArray.length != 1 || !terminalSymbolArray[0].equals(TerminalSymbol.BLANK)) {
                    token2 = new Token(terminalSymbolArray, new String(byArray, n4, n3 - n4 + 1), n4, n);
                    if (token != null) {
                        token.next = token2;
                    }
                    token = token2;
                    vector.addElement(token2);
                }
                state = null;
                state2 = this.startState;
                n4 = n5 = n3 + 1;
                return true;
            }
            int n6 = nArray[byArray[n5]];
            if (n6 == -1) {
                return false;
            }
            state2 = state2.links[n6];
            if (state2 == null) {
                if (state == null) {
                    return false;
                }
                terminalSymbolArray = state.getTokensTypes();
                if (terminalSymbolArray.length != 1 || !terminalSymbolArray[0].equals(TerminalSymbol.BLANK)) {
                    token2 = new Token(terminalSymbolArray, new String(byArray, n4, n3 - n4 + 1), n4, n);
                    if (token != null) {
                        token.next = token2;
                    }
                    token = token2;
                    vector.addElement(token2);
                }
                state = null;
                state2 = this.startState;
                n4 = n5 = n3 + 1;
                continue;
            }
            if (state2.finalState) {
                state = state2;
                n3 = n5;
            }
            ++n5;
        }
        return state2 == this.startState;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.nStates) {
            string = string + this.states[n];
            ++n;
        }
        return string;
    }

    class State
    implements Serializable {
        int state;
        boolean processed = false;
        RegExp[] definition;
        boolean finalState;
        State[] links;
        HashSet tokens;
        int size;
        TerminalSymbol[] cachedResult = null;

        State(RegExp[] regExpArray) {
            this.size = LexicalProcessor.this.classifier.size();
            this.links = new State[this.size];
            this.definition = regExpArray;
            this.finalState = false;
        }

        void process() {
            int n;
            Object object;
            boolean bl = false;
            RegExp[][] regExpArrayArray = new RegExp[this.size][];
            boolean[] blArray = new boolean[this.size];
            int n2 = 0;
            while (n2 < this.definition.length) {
                if (this.definition[n2] instanceof CharExp) {
                    object = (RegExp[])this.definition[n2];
                    int n3 = LexicalProcessor.this.classifier.getClass(object.start);
                    int n4 = LexicalProcessor.this.classifier.getClass(object.end);
                    RegExp[] regExpArray = object.follow;
                    n = n3;
                    while (n <= n4) {
                        blArray[n] = false;
                        ++n;
                    }
                    n = n3;
                    while (n <= n4) {
                        if (n3 <= n && n <= n4) {
                            if (regExpArrayArray[n] == null) {
                                regExpArrayArray[n] = regExpArray;
                            } else if (!blArray[n]) {
                                RegExp[] regExpArray2 = regExpArrayArray[n];
                                RegExp[] regExpArray3 = ArrayOps.concat(regExpArrayArray[n], regExpArray);
                                int n5 = n;
                                while (n5 <= n4) {
                                    if (regExpArrayArray[n5] == regExpArray2) {
                                        blArray[n5] = true;
                                        regExpArrayArray[n5] = regExpArray3;
                                    }
                                    ++n5;
                                }
                            }
                        }
                        ++n;
                    }
                } else if (this.definition[n2] instanceof FinalExp || this.definition[n2] instanceof RejectExp) {
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                this.finalState = true;
                this.tokens = new HashSet();
                bl = false;
                n2 = 0;
                while (n2 < this.definition.length) {
                    if (this.definition[n2] instanceof FinalExp) {
                        this.tokens.add(((FinalExp)this.definition[n2]).tokenType);
                    } else if (this.definition[n2] instanceof RejectExp) {
                        object = ((RejectExp)this.definition[n2]).tokenType;
                        this.tokens.remove(object);
                    }
                    ++n2;
                }
            } else {
                this.tokens = new HashSet();
                this.tokens.add(new TerminalSymbol[0]);
            }
            n2 = 0;
            while (n2 < this.size) {
                blArray[n2] = regExpArrayArray[n2] == null;
                ++n2;
            }
            n2 = 0;
            while (n2 < this.size) {
                if (!blArray[n2]) {
                    State state;
                    object = regExpArrayArray[n2];
                    this.links[n2] = state = LexicalProcessor.this.getState(regExpArrayArray[n2]);
                    n = n2 + 1;
                    while (n < this.size) {
                        if (regExpArrayArray[n] == object) {
                            this.links[n] = state;
                            blArray[n] = true;
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }

        public String toString() {
            String string = "State" + (this.finalState ? "*" : "") + " : " + this.state + "\n";
            string = string + "Definitions : " + ArrayOps.print(this.definition) + "\n";
            int n = 0;
            while (n < this.links.length) {
                if (this.links[n] != null) {
                    string = string + LexicalProcessor.this.classifier.printClass(n) + " -> " + this.links[n].state + "\n";
                }
                ++n;
            }
            return string;
        }

        TerminalSymbol[] getTokensTypes() {
            if (this.cachedResult == null) {
                this.cachedResult = new TerminalSymbol[this.tokens.size()];
                ((AbstractCollection)this.tokens).toArray(this.cachedResult);
                int n = 0;
                while (n < this.cachedResult.length) {
                    int n2 = n;
                    while (n2 < this.cachedResult.length) {
                        if (this.cachedResult[n].priority() > this.cachedResult[n2].priority()) {
                            TerminalSymbol terminalSymbol = this.cachedResult[n];
                            this.cachedResult[n] = this.cachedResult[n2];
                            this.cachedResult[n2] = terminalSymbol;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            return this.cachedResult;
        }
    }
}

