/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ParserGen;

import br.ufpe.abaco.ParserGen.CompilerException;
import br.ufpe.abaco.ParserGen.lexer.LexerFacade;
import br.ufpe.abaco.ParserGen.lexer.RegExp;
import br.ufpe.abaco.ParserGen.lexer.Token;
import br.ufpe.abaco.ParserGen.parser.BNFGrammar;
import br.ufpe.abaco.ParserGen.parser.GrammarSymbol;
import br.ufpe.abaco.ParserGen.parser.NonTerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.Parser;
import br.ufpe.abaco.ParserGen.parser.Production;
import br.ufpe.abaco.ParserGen.parser.SemanticAction;
import br.ufpe.abaco.ParserGen.parser.TerminalSymbol;
import br.ufpe.abaco.ParserGen.parser.TokenAction;

public class RegExpCompiler {
    LexerFacade aLexico = new LexerFacade();
    BNFGrammar aSintatico = new BNFGrammar();
    TerminalSymbol tChar = this.getTerminal("char", false);
    TerminalSymbol tAPar = this.getTerminal("(", true);
    TerminalSymbol tFPar = this.getTerminal(")", true);
    TerminalSymbol tACol = this.getTerminal("[", true);
    TerminalSymbol tFCol = this.getTerminal("]", true);
    TerminalSymbol tOR = this.getTerminal("|", true);
    TerminalSymbol tRange = this.getTerminal("-", true);
    TerminalSymbol tUmMais = this.getTerminal("+", true);
    TerminalSymbol tZeroMais = this.getTerminal("*", true);
    TerminalSymbol tZeroUm = this.getTerminal("?", true);
    NonTerminalSymbol nRegExp = this.aSintatico.getNonTerminal("regExp");
    NonTerminalSymbol nSeqExp = this.aSintatico.getNonTerminal("seqExp");
    NonTerminalSymbol nSingleExp = this.aSintatico.getNonTerminal("singleExp");
    NonTerminalSymbol nRanges = this.aSintatico.getNonTerminal("ranges");
    Parser regExpParser;
    SemanticAction acDefault = new SemanticAction(){

        public Object act(Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    return objectArray[n];
                }
                ++n;
            }
            return null;
        }
    };
    SemanticAction acSequence = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.sequence((RegExp)objectArray[0], (RegExp)objectArray[1]);
        }
    };
    SemanticAction acChoice = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.choice((RegExp)objectArray[0], (RegExp)objectArray[2]);
        }
    };
    SemanticAction acChar = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.charExp(RegExpCompiler.this.string2Char((String)objectArray[0]));
        }
    };
    SemanticAction acZeroUm = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.zeroOne((RegExp)objectArray[0]);
        }
    };
    SemanticAction acUmMais = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.oneMany((RegExp)objectArray[0]);
        }
    };
    SemanticAction acZeroMais = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.zeroMany((RegExp)objectArray[0]);
        }
    };
    SemanticAction acWithRange = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return RegExp.choice(RegExp.charExp('-'), (RegExp)objectArray[2]);
        }
    };
    SemanticAction acRange = new SemanticAction(){

        public Object act(Object[] objectArray) {
            RegExp regExp = RegExp.charExp(RegExpCompiler.this.string2Char((String)objectArray[0]), RegExpCompiler.this.string2Char((String)objectArray[2]));
            if (objectArray.length > 3) {
                regExp = RegExp.choice(regExp, (RegExp)objectArray[3]);
            }
            return regExp;
        }
    };
    SemanticAction acCharRange = new SemanticAction(){

        public Object act(Object[] objectArray) {
            RegExp regExp = RegExp.charExp(RegExpCompiler.this.string2Char((String)objectArray[0]));
            if (objectArray.length > 1) {
                regExp = RegExp.choice(regExp, (RegExp)objectArray[1]);
            }
            return regExp;
        }
    };
    SemanticAction acEmptyRange = new SemanticAction(){

        public Object act(Object[] objectArray) {
            return null;
        }
    };

    void addProduction(SemanticAction semanticAction, NonTerminalSymbol nonTerminalSymbol, GrammarSymbol[] grammarSymbolArray) {
        Production production = this.aSintatico.addProduction(nonTerminalSymbol, grammarSymbolArray);
        if (semanticAction != null) {
            production.setSemanticAction(semanticAction);
        }
    }

    TerminalSymbol getTerminal(String string, boolean bl) {
        TerminalSymbol terminalSymbol = this.aSintatico.getTerminal(string);
        if (bl) {
            terminalSymbol.setAction(new TokenAction(){

                public Object act(String string, int n, int n2) {
                    return null;
                }
            });
        } else {
            terminalSymbol.setAction(new TokenAction(){

                public Object act(String string, int n, int n2) {
                    return string;
                }
            });
        }
        return terminalSymbol;
    }

    char string2Char(String string) {
        char c = string.charAt(0);
        if (c != '\\') {
            return c;
        }
        char c2 = string.charAt(1);
        if (c2 == 'n') {
            return '\n';
        }
        if (c2 == 'r') {
            return '\r';
        }
        if (c2 == 't') {
            return '\t';
        }
        return c2;
    }

    public RegExpCompiler() {
        this.addProduction(this.acDefault, this.nRegExp, new GrammarSymbol[]{this.nSeqExp});
        this.addProduction(this.acChoice, this.nRegExp, new GrammarSymbol[]{this.nSeqExp, this.tOR, this.nRegExp});
        this.addProduction(this.acDefault, this.nSeqExp, new GrammarSymbol[]{this.nSingleExp});
        this.addProduction(this.acSequence, this.nSeqExp, new GrammarSymbol[]{this.nSingleExp, this.nSeqExp});
        this.addProduction(this.acChar, this.nSingleExp, new GrammarSymbol[]{this.tChar});
        this.addProduction(this.acDefault, this.nSingleExp, new GrammarSymbol[]{this.tACol, this.nRanges, this.tFCol});
        this.addProduction(this.acWithRange, this.nSingleExp, new GrammarSymbol[]{this.tACol, this.tRange, this.nRanges, this.tFCol});
        this.addProduction(this.acDefault, this.nSingleExp, new GrammarSymbol[]{this.tAPar, this.nRegExp, this.tFPar});
        this.addProduction(this.acUmMais, this.nSingleExp, new GrammarSymbol[]{this.nSingleExp, this.tUmMais});
        this.addProduction(this.acZeroMais, this.nSingleExp, new GrammarSymbol[]{this.nSingleExp, this.tZeroMais});
        this.addProduction(this.acZeroUm, this.nSingleExp, new GrammarSymbol[]{this.nSingleExp, this.tZeroUm});
        this.addProduction(this.acCharRange, this.nRanges, new GrammarSymbol[]{this.tChar, this.nRanges});
        this.addProduction(this.acRange, this.nRanges, new GrammarSymbol[]{this.tChar, this.tRange, this.tChar, this.nRanges});
        this.addProduction(this.acCharRange, this.nRanges, new GrammarSymbol[]{this.tChar});
        this.addProduction(this.acRange, this.nRanges, new GrammarSymbol[]{this.tChar, this.tRange, this.tChar});
        RegExp regExp = RegExp.charExp('0', '9');
        regExp = RegExp.choice(regExp, RegExp.charExp('a', 'z'));
        regExp = RegExp.choice(regExp, RegExp.charExp('A', 'Z'));
        regExp = RegExp.choice(regExp, RegExp.string(" "));
        regExp = RegExp.choice(regExp, RegExp.string("\n"));
        regExp = RegExp.choice(regExp, RegExp.string("\\n"));
        regExp = RegExp.choice(regExp, RegExp.string("\r"));
        regExp = RegExp.choice(regExp, RegExp.string("\\r"));
        regExp = RegExp.choice(regExp, RegExp.string("\t"));
        regExp = RegExp.choice(regExp, RegExp.string("\\t"));
        regExp = RegExp.choice(regExp, RegExp.string("\\+"));
        regExp = RegExp.choice(regExp, RegExp.string("\\*"));
        regExp = RegExp.choice(regExp, RegExp.string("\\-"));
        regExp = RegExp.choice(regExp, RegExp.string("\\?"));
        regExp = RegExp.choice(regExp, RegExp.string("\\["));
        regExp = RegExp.choice(regExp, RegExp.string("\\]"));
        regExp = RegExp.choice(regExp, RegExp.string("\\("));
        regExp = RegExp.choice(regExp, RegExp.string("\\)"));
        regExp = RegExp.choice(regExp, RegExp.string("\\ "));
        regExp = RegExp.choice(regExp, RegExp.string("\\\\"));
        regExp = RegExp.choice(regExp, RegExp.string("/"));
        regExp = RegExp.choice(regExp, RegExp.string("<"));
        regExp = RegExp.choice(regExp, RegExp.string(">"));
        regExp = RegExp.choice(regExp, RegExp.string("\""));
        regExp = RegExp.choice(regExp, RegExp.string("&"));
        regExp = RegExp.choice(regExp, RegExp.string("%"));
        regExp = RegExp.choice(regExp, RegExp.string(";"));
        regExp = RegExp.choice(regExp, RegExp.string("="));
        regExp = RegExp.choice(regExp, RegExp.string(":"));
        regExp = RegExp.choice(regExp, RegExp.string(","));
        regExp = RegExp.choice(regExp, RegExp.string("."));
        regExp = RegExp.choice(regExp, RegExp.string("|"));
        regExp = RegExp.choice(regExp, RegExp.string("~"));
        regExp = RegExp.choice(regExp, RegExp.string("#"));
        regExp = RegExp.choice(regExp, RegExp.string("="));
        regExp = RegExp.choice(regExp, RegExp.string("_"));
        regExp = RegExp.choice(regExp, RegExp.string("\""));
        regExp = RegExp.choice(regExp, RegExp.string("'"));
        this.aLexico.insertRule(regExp, this.tChar);
        this.aLexico.insertRule(RegExp.string("("), this.tAPar);
        this.aLexico.insertRule(RegExp.string(")"), this.tFPar);
        this.aLexico.insertRule(RegExp.string("["), this.tACol);
        this.aLexico.insertRule(RegExp.string("]"), this.tFCol);
        this.aLexico.insertRule(RegExp.string("|"), this.tOR);
        this.aLexico.insertRule(RegExp.string("-"), this.tRange);
        this.aLexico.insertRule(RegExp.string("+"), this.tUmMais);
        this.aLexico.insertRule(RegExp.string("*"), this.tZeroMais);
        this.aLexico.insertRule(RegExp.string("?"), this.tZeroUm);
        this.aSintatico.setStartSymbol(this.nRegExp);
        this.regExpParser = new Parser(this.aSintatico, true);
    }

    RegExp compile(String string) throws CompilerException {
        Token[] tokenArray = this.aLexico.analyse(string);
        RegExp regExp = (RegExp)this.regExpParser.parse(tokenArray, (byte)1, true);
        return regExp;
    }

    public static void main(String[] stringArray) throws Exception {
        RegExpCompiler regExpCompiler = new RegExpCompiler();
        System.out.println(48);
        System.out.println(122);
        System.out.println(91);
        System.out.println(regExpCompiler.compile("<spec name=[a-z]+"));
        regExpCompiler.regExpParser.saveParserLog();
    }
}

