/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.Exporter;

import br.ufpe.abaco.Exporter.DocumentBuilder;
import br.ufpe.abaco.gui.Exporter;
import java.io.File;
import java.util.StringTokenizer;

public class PlainTextDocumentBuilder
extends DocumentBuilder {
    StringBuffer document = new StringBuffer();
    boolean newLine = false;
    int sectionLevel = 1;
    private boolean multipleFiles;
    private File outputPath;
    String prefix = "    ";

    public PlainTextDocumentBuilder(boolean bl) {
        this.multipleFiles = bl;
        this.outputPath = Exporter.getOutputFileName().endsWith(".txt") ? new File(Exporter.getOutputFileName().substring(0, Exporter.getOutputFileName().lastIndexOf(System.getProperty("file.separator")))) : new File(Exporter.getOutputFileName());
    }

    public boolean useFormattingFile() {
        return false;
    }

    public File getDirectoryBase() {
        return this.outputPath;
    }

    public File getFormattingFilePath() {
        return null;
    }

    public void endSpecification() {
    }

    public void startList(int n) {
    }

    public void startItem() {
    }

    public void endList(int n) {
    }

    public void startSpecification() {
    }

    public void endSection() {
    }

    public boolean exportMultipleFiles() {
        return this.multipleFiles;
    }

    public String generateDocument() {
        if (!this.multipleFiles) {
            return this.document.toString();
        }
        String string = this.document.toString();
        this.document.delete(0, this.document.length());
        return string;
    }

    public void addText(String string) {
        if (this.newLine) {
            this.newLine();
        }
        this.document.append(string + " ");
    }

    public void newLine() {
        this.document.append("\n");
        this.newLine = false;
    }

    public void newParagraph() {
        this.document.append("\n\n");
    }

    public void startSection(String string) {
        this.newParagraph();
        this.document.append(this.sectionLevel + ". " + string);
        this.document.append("\n");
        ++this.sectionLevel;
    }

    public void startFormat(int n) {
        switch (n) {
            case 7: {
                this.document.append("\nintroduces:");
                this.newLine = false;
                break;
            }
            case 8: {
                this.document.append("\nneeds:");
                this.newLine = false;
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                this.document.append("* ");
                this.newLine = false;
                break;
            }
            case 11: {
                this.document.append("re ");
                this.newLine = false;
                break;
            }
            case 12: {
                this.document.append("pp ");
                this.newLine = false;
                break;
            }
            case 13: {
                this.prefix = this.prefix + "| ";
                this.newLine = true;
            }
        }
    }

    public void endFormat(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.document.append(".\n\n");
                this.newLine = false;
                break;
            }
            case 13: {
                this.prefix = this.prefix.substring(0, this.prefix.length() - 2);
                this.newLine = true;
            }
        }
    }

    public void insertSeparator(int n) {
        switch (n) {
            case 20: {
                this.document.append("<= ");
                break;
            }
            case 21: {
                this.document.append(">= ");
                break;
            }
            case 22: 
            case 27: {
                this.document.append("= ");
                break;
            }
            case 23: {
                this.document.append(": ");
                break;
            }
            case 24: {
                this.document.append(":: ");
                break;
            }
            case 25: {
                this.document.append("-> ");
                break;
            }
            case 26: {
                this.document.append("=> ");
            }
        }
    }

    public void addSyntax(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("[[")) {
                this.document.append("[[ ");
                continue;
            }
            if (string2.equals("]]")) {
                this.document.append("]] ");
                continue;
            }
            if (string2.equals("|")) {
                this.document.append("| \n");
                continue;
            }
            this.document.append(string2 + " ");
        }
    }
}

