/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.Exporter;

import br.ufpe.abaco.Exporter.DocumentBuilder;
import br.ufpe.abaco.gui.Exporter;
import java.io.File;
import java.util.StringTokenizer;

public class LatexDocumentBuilder
extends DocumentBuilder {
    StringBuffer document = new StringBuffer();
    boolean newLine = false;
    private boolean useCustomStyFile;
    private boolean useCustomClassFile;
    private boolean multipleFiles;
    private boolean generateToc;
    private boolean generatePreambule;
    private File styFilePath;
    private File classFilePath;
    private File outputPath;
    int sectionLevel = 0;

    public LatexDocumentBuilder(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, File file, File file2) {
        this.useCustomStyFile = bl;
        this.useCustomClassFile = bl2;
        this.multipleFiles = bl3;
        this.generateToc = bl4;
        this.generatePreambule = bl5;
        this.styFilePath = file;
        this.outputPath = Exporter.getOutputFileName().endsWith(".tex") ? new File(Exporter.getOutputFileName().substring(0, Exporter.getOutputFileName().lastIndexOf(System.getProperty("file.separator")))) : new File(Exporter.getOutputFileName());
        this.classFilePath = file2;
    }

    public File getFormattingFilePath() {
        return this.styFilePath;
    }

    public File getDirectoryBase() {
        return this.outputPath;
    }

    public boolean exportMultipleFiles() {
        return this.multipleFiles;
    }

    public boolean useFormattingFile() {
        return this.useCustomStyFile;
    }

    public boolean generateTableOfContents() {
        return this.generateToc;
    }

    public boolean generatePreambule() {
        return this.generatePreambule;
    }

    public boolean useCustomClassFile() {
        return this.useCustomClassFile;
    }

    public File getClassFilePath() {
        return this.classFilePath;
    }

    public String generateDocument() {
        if (!this.multipleFiles) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.useCustomClassFile && this.generatePreambule) {
                string = this.classFilePath.getParent().equals(this.outputPath.getPath()) ? this.classFilePath.getName() : this.classFilePath.getPath();
                stringBuffer.append("\\documentclass{" + string.substring(0, string.lastIndexOf(".cls")) + "}" + "\n");
            } else if (this.generatePreambule) {
                stringBuffer.append("\\documentclass{article}\n");
            }
            if (this.useCustomStyFile && this.generatePreambule) {
                string = this.styFilePath.getParent().equals(this.outputPath.getPath()) ? this.styFilePath.getName() : this.styFilePath.getPath();
                stringBuffer.append("\\usepackage{" + string.substring(0, string.lastIndexOf(".sty")) + "}" + "\n");
            }
            if (this.generatePreambule) {
                stringBuffer.append("\\begin{document}\n");
            }
            if (this.generateToc) {
                stringBuffer.append("\\tableofcontents\n");
            }
            stringBuffer.append("\\flushleft\n");
            this.document.insert(0, stringBuffer.toString());
            if (this.generatePreambule) {
                this.document.append("\\end{document}\n");
            }
            return this.document.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.document.toString());
        this.document.delete(0, this.document.length());
        return stringBuffer.toString();
    }

    public void addText(String string) {
        if (this.newLine) {
            this.newLine();
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '_') {
                this.document.append("\\_");
            } else {
                this.document.append(string.charAt(n));
            }
            ++n;
        }
        this.document.append(" ");
    }

    public void newLine() {
        this.document.append("\\\\\n");
        this.newLine = false;
    }

    public void newParagraph() {
        this.document.append("\n\n");
    }

    public void startSection(String string) {
        this.newParagraph();
        this.document.append("\\");
        int n = 0;
        while (n < this.sectionLevel) {
            this.document.append("sub");
            ++n;
        }
        this.document.append("section{");
        this.document.append("\\textbf{" + string);
        this.document.append("}}\n");
        ++this.sectionLevel;
    }

    public void endSection() {
        --this.sectionLevel;
    }

    public void startList(int n) {
        this.newParagraph();
        if (n == 0) {
            this.document.append("\\begin{enumerate}");
        } else if (n == 1) {
            this.document.append("\\begin{itemize}");
        }
    }

    public void startItem() {
        this.document.append("\n\\item ");
    }

    public void endList(int n) {
        if (n == 0) {
            this.document.append("\n\\end{enumerate}\n");
        } else if (n == 1) {
            this.document.append("\n\\end{itemize}\n");
        }
    }

    public void startFormat(int n) {
        switch (n) {
            case 7: {
                this.newLine = false;
                this.document.append("\n\\item[\\textsf{introduces}] ");
                break;
            }
            case 8: {
                this.newLine = false;
                this.document.append("\n\\item[\\textsf{needs}] ");
                break;
            }
            case 9: {
                this.document.append("\n\\item[\\textsf{op}] ");
                this.newLine = false;
                break;
            }
            case 10: {
                this.document.append("\n\\item[\\textsf{eq}] ");
                this.newLine = false;
                break;
            }
            case 14: {
                this.document.append("\n\\item[]");
                this.newLine = false;
                break;
            }
            case 11: {
                this.document.append("\n\\item[\\textsf{re}] ");
                this.newLine = false;
                break;
            }
            case 12: {
                this.document.append("\n\\item[\\textsf{pp}] ");
                this.newLine = false;
                break;
            }
            case 13: {
                if (!this.newLine) {
                    this.document.append("\\\\");
                }
                this.document.append("\\<");
                this.newLine = false;
            }
        }
    }

    public void endFormat(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.document.append(". \n\n");
                break;
            }
            case 13: {
                this.document.append("\\>");
                this.newLine = true;
            }
        }
    }

    public void insertSeparator(int n) {
        switch (n) {
            case 20: {
                this.document.append("${\\leq}$ ");
                break;
            }
            case 21: {
                this.document.append("${\\geq}$ ");
                break;
            }
            case 22: {
                this.document.append("= ");
                this.newLine = false;
                break;
            }
            case 27: {
                this.document.append("= ");
                this.newLine = true;
                break;
            }
            case 23: {
                this.document.append("${:}$ ");
                break;
            }
            case 24: {
                this.document.append(":: ");
                break;
            }
            case 25: {
                this.document.append("${\\rightarrow}$ ");
                break;
            }
            case 26: {
                this.document.append("${\\implies}$ ");
            }
        }
    }

    public void startSpecification() {
        this.startList(1);
    }

    public void endSpecification() {
        this.endList(1);
    }

    public void addSyntax(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("[[")) {
                this.document.append("\\\\\n\\subitem \\ \\ \\ \\ \\ \\ \\ \\ [[ ");
                continue;
            }
            if (string2.equals("]]")) {
                this.document.append("]] ");
                continue;
            }
            if (string2.equals("|")) {
                this.document.append(" ${\\vert}$\n ");
                continue;
            }
            if (string2.charAt(0) == '\"') {
                if (string2.substring(1, string2.length() - 1).equals("->")) {
                    this.document.append("''{\\tt${\\rightarrow}$}`` ");
                    continue;
                }
                if (string2.substring(1, string2.length() - 1).equals(">=")) {
                    this.document.append("''{\\tt${\\geq}$}`` ");
                    continue;
                }
                if (string2.substring(1, string2.length() - 1).equals("<=")) {
                    this.document.append("''{\\tt${\\leq}$}`` ");
                    continue;
                }
                if (string2.substring(1, string2.length() - 1).equals("=>")) {
                    this.document.append("''{\\tt${\\implies}$}`` ");
                    continue;
                }
                this.document.append("''{\\tt " + string2.substring(1, string2.length() - 1) + "}`` ");
                continue;
            }
            this.document.append(string2 + " ");
        }
    }
}

