/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.Exporter;

import br.ufpe.abaco.Exporter.DocumentBuilder;
import br.ufpe.abaco.gui.Exporter;
import java.io.File;
import java.util.StringTokenizer;

public class HTMLDocumentBuilder
extends DocumentBuilder {
    private boolean useCustomCssFile;
    private boolean multipleFiles;
    private File cssFilePath;
    private File outputPath;
    StringBuffer index = new StringBuffer();
    StringBuffer document = new StringBuffer();
    int sizeLine = 0;
    int nSections = 0;
    int sectionLevel = 0;
    int[] secNumbers = new int[5];
    String prefix = "    ";
    boolean newLine = true;

    public HTMLDocumentBuilder(boolean bl, boolean bl2, File file) {
        this.useCustomCssFile = bl;
        this.multipleFiles = bl2;
        this.cssFilePath = file;
        this.outputPath = Exporter.getOutputFileName().endsWith(".html") ? new File(Exporter.getOutputFileName().substring(0, Exporter.getOutputFileName().lastIndexOf(System.getProperty("file.separator")))) : new File(Exporter.getOutputFileName());
    }

    public File getFormattingFilePath() {
        return this.cssFilePath;
    }

    public File getDirectoryBase() {
        return this.outputPath;
    }

    public boolean exportMultipleFiles() {
        return this.multipleFiles;
    }

    public boolean useFormattingFile() {
        return this.useCustomCssFile;
    }

    public String generateDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.multipleFiles) {
            stringBuffer.append((Object)this.index);
            stringBuffer.append((Object)this.document);
            this.index = this.index.delete(0, this.index.length());
            this.document = this.document.delete(0, this.document.length());
        } else {
            stringBuffer.append("<html><head>");
            if (this.useCustomCssFile) {
                if (this.cssFilePath.getParent().equals(this.outputPath.getPath())) {
                    stringBuffer.append("<LINK REL=StyleSheet HREF=\"" + this.cssFilePath.getName() + "\" TYPE=\"text/css\">" + "\n");
                } else {
                    stringBuffer.append("<LINK REL=StyleSheet HREF=\"" + this.cssFilePath.getPath() + "\" TYPE=\"text/css\">" + "\n");
                }
            }
            stringBuffer.append("</head><body>");
            stringBuffer.append((Object)this.index);
            stringBuffer.append("\n</ul>\n\n");
            stringBuffer.append((Object)this.document);
            stringBuffer.append("</body></html>");
        }
        return stringBuffer.toString();
    }

    public void addText(String string) {
        if (this.newLine) {
            this.newLine = false;
            this.document.append("\n");
            this.document.append(this.prefix);
            this.sizeLine = this.prefix.length();
        }
        this.document.append(string);
        this.sizeLine += string.length() + 1;
        this.document.append(" ");
        if (this.sizeLine > 60) {
            this.newLine = true;
        }
    }

    public void newLine() {
        this.document.append("\n<br>\n");
    }

    public void newParagraph() {
        this.document.append("\n<p>\n");
    }

    public void startSection(String string) {
        String string2 = "";
        this.secNumbers[this.sectionLevel + 1] = 0;
        int n = this.sectionLevel;
        this.secNumbers[n] = this.secNumbers[n] + 1;
        int n2 = 0;
        while (n2 <= this.sectionLevel) {
            if (n2 > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + this.secNumbers[n2];
            ++n2;
        }
        this.newParagraph();
        this.document.append("<a name=\"sec" + this.nSections + "\"><!-- --></a>\n");
        this.document.append("<h" + (this.sectionLevel > 3 ? 4 : this.sectionLevel + 1) + ">");
        this.document.append(string2);
        this.document.append(" ");
        this.document.append(string);
        this.document.append("</h" + (this.sectionLevel > 3 ? 4 : this.sectionLevel + 1) + ">\n");
        if (this.secNumbers[this.sectionLevel] == 1) {
            this.index.append("<ul>\n");
        }
        this.index.append("<li><a href=\"#sec" + this.nSections + "\">" + string2 + " " + string + "</a>\n");
        ++this.nSections;
        ++this.sectionLevel;
    }

    public void endSection() {
        if (this.secNumbers[this.sectionLevel] > 0) {
            this.index.append("</ul>\n");
        }
        --this.sectionLevel;
    }

    public void startList(int n) {
        this.newParagraph();
        if (n == 0) {
            this.document.append("<ol>");
        } else if (n == 1) {
            this.document.append("<ul>");
        }
    }

    public void startItem() {
        this.document.append("\n<li> ");
    }

    public void endList(int n) {
        if (n == 0) {
            this.document.append("\n</ol>\n");
        } else if (n == 1) {
            this.document.append("\n</ul>\n");
        }
    }

    public void startFormat(int n) {
        switch (n) {
            case 7: {
                this.document.append("\nintroduces:");
                this.newLine = true;
                break;
            }
            case 8: {
                this.document.append("\nneeds:");
                this.newLine = true;
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                this.document.append("* ");
                break;
            }
            case 11: {
                this.document.append("re ");
                break;
            }
            case 12: {
                this.document.append("pp ");
                break;
            }
            case 13: {
                this.prefix = this.prefix + "| ";
                this.newLine = true;
            }
        }
    }

    public void endFormat(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.document.append(".\n\n");
                this.newLine = false;
                break;
            }
            case 13: {
                this.prefix = this.prefix.substring(0, this.prefix.length() - 2);
                this.newLine = true;
            }
        }
    }

    public void insertSeparator(int n) {
        switch (n) {
            case 20: {
                this.document.append("<= ");
                break;
            }
            case 21: {
                this.document.append(">= ");
                break;
            }
            case 22: 
            case 27: {
                this.document.append("= ");
                this.newLine = true;
                break;
            }
            case 23: {
                this.document.append(": ");
                break;
            }
            case 24: {
                this.document.append(":: ");
                break;
            }
            case 25: {
                this.document.append("-> ");
                break;
            }
            case 26: {
                this.document.append("=> ");
            }
        }
    }

    public void startSpecification() {
        this.document.append("\n<p><pre>\n");
    }

    public void endSpecification() {
        this.document.append("\n</pre>\n");
    }

    public void addSyntax(String string) {
        this.document.append("<BLOCKQUOTE>\n");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("[[")) {
                this.document.append("[[ ");
                continue;
            }
            if (string2.equals("]]")) {
                this.document.append("]] ");
                continue;
            }
            if (string2.equals("|")) {
                this.document.append("|  <br> \n");
                continue;
            }
            this.document.append(string2 + " ");
        }
        this.document.append("\n</BLOCKQUOTE>\n");
    }
}

