/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.abaco.ActionInterpreter;

import br.ufpe.abaco.ActionInterpreter.DivergeException;
import br.ufpe.abaco.ActionInterpreter.EscapeException;
import br.ufpe.abaco.ActionInterpreter.Evaluator;
import br.ufpe.abaco.ActionInterpreter.Facet;
import br.ufpe.abaco.ActionInterpreter.FailException;
import br.ufpe.abaco.ActionInterpreter.InterpreterListener;
import br.ufpe.abaco.ActionInterpreter.PerformanceException;
import br.ufpe.abaco.ActionInterpreter.StandardEvaluators;
import br.ufpe.abaco.runtime.AbacoExecutionEngine;
import br.ufpe.abaco.runtime.GenericNativeTerm;
import br.ufpe.abaco.runtime.NativeCode1;
import br.ufpe.abaco.runtime.Operator;
import br.ufpe.abaco.runtime.Term;
import native_code.StringTerm;

public class Interpreter
extends NativeCode1 {
    Operator giveOp;
    Operator thenOp;
    Operator henceOp;
    Operator produceOp;
    Operator abstractionofOp;
    Operator nothingOp;
    Operator translateOp;
    Operator evaluateOp;
    Operator implementedByOp;
    Operator yielderImplementedByOp;
    AbacoExecutionEngine spec;
    int outcomeType;
    InterpreterListener listener = null;
    int evaluatedActions;
    Evaluator[] evaluators = new Evaluator[100];
    Evaluator doNothing = new Evaluator(){

        public Term doEvaluation(Term term) {
            return term;
        }
    };
    DivergeException diver = new DivergeException();
    Facet[] definedFacets = new Facet[0];
    Evaluator standardYielderEvaluator = new Evaluator(){

        public Term doEvaluation(Term term) throws PerformanceException {
            boolean bl = false;
            Term[] termArray = new Term[term.arity()];
            int n = 0;
            while (n < termArray.length) {
                Term term2 = term.getArg(n);
                termArray[n] = Interpreter.this.evaluateYielder(term2);
                if (termArray[n] != term2) {
                    bl = true;
                }
                if (termArray[n] == null) {
                    Interpreter.this.fail(termArray[n]);
                }
                ++n;
            }
            if (!bl) {
                return term;
            }
            return Interpreter.this.runner.run(term.operator(), termArray);
        }
    };

    public void setListener(InterpreterListener interpreterListener) {
        this.listener = interpreterListener;
    }

    public void setEngine(AbacoExecutionEngine abacoExecutionEngine) {
        super.setEngine(abacoExecutionEngine);
        this.spec = abacoExecutionEngine;
        abacoExecutionEngine.putProperty("abaco.ActionInterpreter", this);
        this.outcomeType = abacoExecutionEngine.sortIndex("outcome");
        StandardEvaluators.insertEvaluators(this);
        this.giveOp = abacoExecutionEngine.getOperator("give _");
        this.thenOp = abacoExecutionEngine.getOperator("_ then _");
        this.henceOp = abacoExecutionEngine.getOperator("_ hence _");
        this.produceOp = abacoExecutionEngine.getOperator("produce _");
        this.abstractionofOp = abacoExecutionEngine.getOperator("abstraction of _");
        this.nothingOp = abacoExecutionEngine.getOperator("nothing");
        this.translateOp = abacoExecutionEngine.getOperator("translate _");
        this.implementedByOp = abacoExecutionEngine.getOperator("implemented by _");
        this.evaluateOp = abacoExecutionEngine.getOperator("evaluate _");
        this.yielderImplementedByOp = abacoExecutionEngine.getOperator("yielder implemented by _");
    }

    public Term run(Term term) {
        this.evaluatedActions = 0;
        long l = System.currentTimeMillis();
        GenericNativeTerm genericNativeTerm = new GenericNativeTerm(this.interpretAction(term));
        genericNativeTerm.setType(this.outcomeType);
        long l2 = System.currentTimeMillis() - l;
        if (l2 == 0L) {
            ++l2;
        }
        return genericNativeTerm;
    }

    public Operator getOperator(String string) {
        return this.spec.getOperator(string);
    }

    void resizeTable(int n) {
        if (this.evaluators.length > n) {
            return;
        }
        Evaluator[] evaluatorArray = new Evaluator[n + 20];
        int n2 = 0;
        while (n2 < this.evaluators.length) {
            evaluatorArray[n2] = this.evaluators[n2];
            ++n2;
        }
        this.evaluators = evaluatorArray;
    }

    public void insertEvaluator(String string, Evaluator evaluator) {
        Operator operator = this.getOperator(string);
        int n = operator.getPosition();
        this.resizeTable(n);
        this.evaluators[n] = evaluator;
        evaluator.setEvaluator(this);
    }

    public void fail(Term term) throws PerformanceException {
        throw new FailException(term);
    }

    public void diverge() throws PerformanceException {
        throw this.diver;
    }

    public void escape(Term term) throws PerformanceException {
        throw new EscapeException(term);
    }

    public void evaluateAction(Term term) throws PerformanceException {
        Object object;
        int n;
        ++this.evaluatedActions;
        Operator operator = term.operator();
        if (operator == null) {
            this.fail(term);
        }
        Evaluator evaluator = (n = operator.getPosition()) < 0 || n >= this.evaluators.length ? null : this.evaluators[n];
        if (this.listener != null) {
            object = new StringBuffer();
            this.getIncome((StringBuffer)object);
            this.listener.startPerformance(term, ((StringBuffer)object).toString());
        }
        try {
            if (evaluator != null) {
                evaluator.doEvaluation(term);
            } else {
                object = this.spec.run(this.translateOp, term);
                if (((Term)object).operator() == this.translateOp) {
                    this.fail(term);
                }
                if (((Term)object).operator() == this.implementedByOp) {
                    String string = ((StringTerm)((Term)object).getArg(0)).value();
                    try {
                        Class<?> clazz = Class.forName(string);
                        Evaluator evaluator2 = (Evaluator)clazz.newInstance();
                        this.insertEvaluator(term.operator().name, evaluator2);
                        evaluator2.doEvaluation(term);
                    }
                    catch (Exception exception) {
                        this.fail(term);
                    }
                } else {
                    this.evaluateAction((Term)object);
                }
            }
            if (this.listener != null) {
                object = new StringBuffer("Outcome: completing\n\n");
                this.getOutcome((StringBuffer)object);
                this.listener.endPerformance(term, ((StringBuffer)object).toString(), true);
            }
        }
        catch (FailException failException) {
            if (this.listener != null) {
                this.listener.endPerformance(term, "Outcome: failing\n\n", false);
            }
            throw failException;
        }
        catch (DivergeException divergeException) {
            if (this.listener != null) {
                this.listener.endPerformance(term, "Outcome: diverging\n\n", false);
            }
            throw divergeException;
        }
        catch (EscapeException escapeException) {
            if (this.listener != null) {
                this.listener.endPerformance(term, "Outcome: escaping\n\n", false);
            }
            throw escapeException;
        }
    }

    void defineFacet(Facet facet) {
        Facet[] facetArray = new Facet[this.definedFacets.length + 1];
        int n = 0;
        while (n < this.definedFacets.length) {
            facetArray[n] = this.definedFacets[n];
            ++n;
        }
        facetArray[this.definedFacets.length] = facet;
        this.definedFacets = facetArray;
    }

    public Term evaluateYielder(Term term) throws PerformanceException {
        Operator operator = term.operator();
        if (operator == null) {
            return term;
        }
        int n = operator.getPosition();
        Evaluator evaluator = n < 0 || n >= this.evaluators.length ? null : this.evaluators[n];
        if (operator == this.nothingOp) {
            this.fail(term);
        }
        if (evaluator != null) {
            return evaluator.doEvaluation(term);
        }
        Term term2 = this.runner.run(this.evaluateOp, term);
        if (term2.operator() == this.evaluateOp) {
            this.insertEvaluator(term.operator().name, this.standardYielderEvaluator);
            return this.standardYielderEvaluator.doEvaluation(term);
        }
        if (term2.operator() == this.yielderImplementedByOp) {
            String string = ((StringTerm)term2.getArg(0)).value();
            try {
                Class<?> clazz = Class.forName(string);
                Evaluator evaluator2 = (Evaluator)clazz.newInstance();
                this.insertEvaluator(term.operator().name, evaluator2);
                return evaluator2.doEvaluation(term);
            }
            catch (Exception exception) {
                this.fail(term);
            }
        } else {
            return this.standardYielderEvaluator.doEvaluation(term2);
        }
        return null;
    }

    public boolean isOfType(Term term, Term term2) {
        return this.spec.isSubSort(term, term2.getType());
    }

    public String interpretAction(Term term) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.definedFacets.length) {
            this.definedFacets[n].initialize();
            ++n;
        }
        try {
            this.evaluateAction(term);
            stringBuffer.append("Outcome : Completing\n");
            this.getOutcome(stringBuffer);
        }
        catch (FailException failException) {
            stringBuffer.append("Outcome : Failing\n" + failException);
        }
        catch (DivergeException divergeException) {
            stringBuffer.append("Outcome : Diverging\n" + divergeException);
        }
        catch (EscapeException escapeException) {
            stringBuffer.append("Outcome : Escaping\n");
        }
        catch (PerformanceException performanceException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    void getOutcome(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.definedFacets.length) {
            stringBuffer.append(this.definedFacets[n].facetName());
            stringBuffer.append(":\n");
            this.definedFacets[n].producedData(stringBuffer, "    ");
            stringBuffer.append("\n");
            ++n;
        }
    }

    void getIncome(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.definedFacets.length) {
            stringBuffer.append(this.definedFacets[n].facetName());
            stringBuffer.append(":\n");
            this.definedFacets[n].incommingData(stringBuffer, "    ");
            stringBuffer.append("\n");
            ++n;
        }
    }
}

