/*
 * Decompiled with CFR 0.152.
 */
import br.ufpe.abaco.runtime.AbacoExecutionEngine;
import br.ufpe.abaco.runtime.Term;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;

public class GuiApplet
extends Applet
implements ActionListener {
    AbacoExecutionEngine spec;
    Panel pan;
    TextArea text;
    Button[] tools = new Button[5];
    String[] actions = new String[5];
    Button bttPrev;
    Button bttNext;
    StringStack currStack = null;
    boolean independentWindow = false;
    Font fixedFont = new Font("Monospaced", 0, 12);

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bttPrev) {
            if (this.currStack != null && this.currStack.prev != null) {
                this.currStack = this.currStack.prev;
                this.text.setText(this.currStack.text);
            }
        } else if (object == this.bttNext) {
            if (this.currStack != null && this.currStack.next != null) {
                this.currStack = this.currStack.next;
                this.text.setText(this.currStack.text);
            }
        } else {
            int n = 0;
            while (n < this.tools.length) {
                if (object != null && object == this.tools[n]) {
                    String string = this.text.getText();
                    if (this.currStack != null) {
                        this.currStack.text = string;
                    }
                    try {
                        if (this.actions[n] != null) {
                            int n2 = this.actions[n].indexOf(95);
                            if (n2 < 0) {
                                return;
                            }
                            string = this.actions[n].substring(0, n2) + " ( \n " + string + "\n ) ";
                            if (n2 < this.actions[n].length() - 1) {
                                string = string + this.actions[n].substring(n2 + 1);
                            }
                        }
                        Term term = this.spec.parse(string);
                        string = this.spec.print(term);
                        this.currStack = new StringStack(string, this.currStack);
                        this.text.setText(string);
                    }
                    catch (Exception exception) {
                        this.message("Error: " + exception);
                    }
                    return;
                }
                ++n;
            }
        }
    }

    void message(String string) {
        JOptionPane.showMessageDialog(this, string, "System Message", 0);
    }

    void setStandAlone() {
        this.independentWindow = true;
    }

    String removeCoding(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 92 && n + 1 < byArray.length) {
                if (byArray[++n] == 110) {
                    stringBuffer.append('\n');
                } else if (byArray[n] == 114) {
                    stringBuffer.append('\r');
                } else if (byArray[n] == 116) {
                    stringBuffer.append('\t');
                } else if (byArray[n] == 92) {
                    stringBuffer.append('\\');
                } else {
                    --n;
                    stringBuffer.append('\\');
                }
            } else {
                stringBuffer.append((char)byArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void createActionButtons() {
        Object object;
        String string;
        if (this.independentWindow) {
            this.tools[0] = new Button("Evaluate");
            this.actions[0] = null;
            this.pan.add((Component)this.tools[0], "Center");
            this.tools[0].addActionListener(this);
            return;
        }
        int n = 0;
        while (n < 5) {
            string = this.getParameter("label" + n);
            object = this.getParameter("action" + n);
            if (string == null) {
                this.tools[n] = null;
                this.actions[n] = null;
            } else {
                this.tools[n] = new Button(string);
                this.actions[n] = object;
                this.pan.add((Component)this.tools[n], "Center");
                this.tools[n].addActionListener(this);
            }
            ++n;
        }
        string = this.getParameter("Contents");
        if (string != null) {
            string = this.removeCoding(string);
            this.text.setText(string);
        }
        if ((string = this.getParameter("ContentsURL")) != null) {
            try {
                object = new URL(this.getDocumentBase(), string);
                InputStream inputStream = ((URL)object).openStream();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = inputStream.read();
                while (n2 > 0) {
                    stringBuffer.append((char)n2);
                    n2 = inputStream.read();
                }
                this.text.setText(stringBuffer.toString());
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init() {
        System.out.println("Inited");
    }

    public void start() {
        System.out.println("Started");
        this.currStack = new StringStack("", null);
        this.setLayout(new BorderLayout());
        this.text = new TextArea();
        this.text.setFont(this.fixedFont);
        this.add((Component)this.text, "Center");
        this.pan = new Panel();
        this.bttPrev = new Button("<<--");
        this.bttPrev.setFont(this.fixedFont);
        this.bttPrev.addActionListener(this);
        this.bttNext = new Button("-->>");
        this.bttNext.setFont(this.fixedFont);
        this.bttNext.addActionListener(this);
        this.pan.add((Component)this.bttPrev, "Center");
        this.createActionButtons();
        this.pan.add((Component)this.bttNext, "Center");
        this.add((Component)this.pan, "South");
        this.spec = AbacoExecutionEngine.createEngine();
        this.spec.createParser();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("teste");
        GuiApplet guiApplet = new GuiApplet();
        guiApplet.setStandAlone();
        guiApplet.start();
        frame.add(guiApplet);
        ((Component)frame).setSize(600, 400);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.show(true);
    }

    class StringStack {
        StringStack prev;
        StringStack next;
        String text;

        StringStack(String string, StringStack stringStack) {
            this.text = string;
            this.prev = stringStack;
            this.next = null;
            if (this.prev != null) {
                this.prev.next = this;
            }
        }
    }
}

