/*
 
 * DecObjectFactory.java
 
 *
 
 * Created on 8 de Junho de 2006, 01:44
 
 *
 
 * To change this template, choose Tools | Template Manager
 
 * and open the template in the editor.
 
 */

package plp.orientadaObjetos2.util;

import plp.orientadaObjetos1.memoria.Ambiente;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.comando.Sequencial;
import plp.orientadaObjetos1.comando.Skip;
import plp.orientadaObjetos1.comando.Write;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.declaracao.variavel.SimplesDecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.ValorInteiro;
import plp.orientadaObjetos1.expressao.valor.ValorString;
import plp.orientadaObjetos1.util.TipoPrimitivo;
import plp.orientadaObjetos2.declaracao.procedimento.DecProcedimentoSimplesOO2;

/**
 * 
 * Essa classe � respons�vel por gerar Defini��o de Classe para o Object.
 * 
 * 
 * 
 * @author Willy
 * 
 */

public class DefObjectFactory {

	/** Creates a new instance of DecObjectFactory */

	public DefObjectFactory() {

	}

	public static Id OBJECT_ID = new Id("Object");

	/**
	 * 
	 * Cria uma Defini��o de Classe para o Object
	 * 
	 * 
	 * 
	 * @param o
	 *            ambiente que contem o mapeamento entre identificadores e
	 * 
	 * seus tipos.
	 * 
	 * @return a definicao de classe do Object
	 * 
	 */

	public static DefClasse createObject(Ambiente ambiente) throws ClasseNaoDeclaradaException {

		Id id = OBJECT_ID;

		DecVariavel var = new SimplesDecVariavel(new TipoPrimitivo(1), new Id("valor"), new ValorInteiro(1));

		DecProcedimento proc = new DecProcedimentoSimplesOO2(new Id("toString"), new ListaDeclaracaoParametro(),
				new Sequencial(new Write(new ValorString("Eu sou um objeto")), new Skip()), "public");
		// Var n pode ser nulo!!! PROBLEMA!!!!
		DefClasse def = new DefClasse(OBJECT_ID, var, proc);

		// NECESSARIO porque a interface ambiente nao tem o metodo
		// getDefClasse
		try {
			if (ambiente instanceof AmbienteExecucao) {
				((AmbienteExecucao) ambiente).mapDefClasse(id, def);
			} else {
				((AmbienteCompilacao) ambiente).mapDefClasse(id, def);
			}
		} catch (ClasseJaDeclaradaException ex) {
			if (ambiente instanceof AmbienteExecucao) {
				def = ((AmbienteExecucao) ambiente).getDefClasse(id);
			} else {
				def = ((AmbienteCompilacao) ambiente).getDefClasse(id);
			}
		}
		return def;
	}

}
