package plp.orientadaObjetos2.memoria;

import java.util.HashMap;
import java.util.Map;

import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorNull;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.ContextoExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;

public class ContextoExecucaoOO2 extends ContextoExecucao implements AmbienteExecucaoOO2 {

	private Map<Id, Id> mapSuperClasse;

	public ContextoExecucaoOO2() {
		super();
		mapSuperClasse = new HashMap<Id, Id>();
	}

	public ContextoExecucaoOO2(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException {
		super(ambiente);
		mapSuperClasse = ((AmbienteExecucaoOO2) ambiente).getMapSuperClasse();
		HashMap<Id, Valor> aux = new HashMap<Id, Valor>();
		aux.put(new Id("super"), new ValorNull());
		getPilha().push(aux);
	}

	public ContextoExecucaoOO2(ListaValor entrada) {
		super(entrada);
		mapSuperClasse = new HashMap<Id, Id>();
		HashMap<Id, Valor> aux = new HashMap<Id, Valor>();
		aux.put(new Id("super"), new ValorNull());
		getPilha().push(aux);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see plp.orientadaObjetos2.memoria.AmbienteExecucao#mapSuperClasse(plp.orientadaObjetos1.expressao.leftExpression.Id,
	 *      plp.orientadaObjetos1.expressao.leftExpression.Id)
	 */
	public void mapSuperClasse(Id classe, Id superClasse) throws ClasseNaoDeclaradaException {
		mapSuperClasse.put(classe, superClasse);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see plp.orientadaObjetos2.memoria.AmbienteExecucao#getSuperClasse(plp.orientadaObjetos1.expressao.leftExpression.Id)
	 */
	public DefClasse getSuperClasse(Id classe) throws ClasseNaoDeclaradaException {

		return getDefClasse(mapSuperClasse.get(classe));
	}

	public Map<Id, Id> getMapSuperClasse() {
		return mapSuperClasse;
	}

}