package plp.orientadaObjetos2.memoria;

import java.util.HashMap;

import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos1.memoria.*;

public class ContextoCompilacaoOO2 extends ContextoCompilacao implements AmbienteCompilacaoOO2 {

	HashMap<Id, Id> mapSuperClasse;

	public ContextoCompilacaoOO2(ListaValor entrada) {
		super(entrada);
		mapSuperClasse = new HashMap<Id, Id>();
	}

	/**
	 * Mapeia o id da sub-classe em uma super-classe.
	 */
	public void mapSuperClasse(Id classe, Id superClasse) throws ClasseNaoDeclaradaException {
		mapSuperClasse.put(classe, superClasse);
	}

	/**
	 * Dado o id de uma classe, recupera a definicao da super-classe.
	 */
	public DefClasse getSuperClasse(Id classe) throws ClasseNaoDeclaradaException {
		return getDefClasse(mapSuperClasse.get(classe));
	}

}