package plp.orientadaObjetos2.memoria;

import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.DefClasse;

public interface AmbienteCompilacaoOO2 extends AmbienteCompilacao {

	/**
	 * Mapeia um identificador de classe com o identificador da super-classe.
	 * 
	 * @param classe
	 *            identificador da sub-classe
	 * @param superClasse
	 *            identificador da super-classe
	 * @throws ClasseNaoDeclaradaException
	 *             Quando a super-classe nao foi declarada
	 */
	public void mapSuperClasse(Id classe, Id superClasse) throws ClasseNaoDeclaradaException;

	/**
	 * Dado um identificador da classe, recupera a super-classe
	 * 
	 * @param classe
	 *            identificador da classe base
	 * @return Definicao da super classe
	 * @throws ClasseNaoDeclaradaException
	 *             Quando a classe ainda nao foi definida
	 */
	public DefClasse getSuperClasse(Id classe) throws ClasseNaoDeclaradaException;

}
