package plp.orientadaObjetos2.expressao.leftExpression;

import java.util.HashMap;
import java.util.Stack;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.leftExpression.AcessoAtributo;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos2.expressao.Super;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;

public class AcessoAtributoSuper extends AcessoAtributo {

	/**
	 * O objeto super.
	 */
	private Super varSuper;

	/**
	 * Construtor.
	 * 
	 * @param varSuper
	 *            O objeto super.
	 * @param id
	 *            O identificador sendo acessado.
	 */
	public AcessoAtributoSuper(Super varSuper, Id id) {
		super(id);
		this.varSuper = varSuper;
	}

	/**
	 * O valor do atributo acessado no ambiente.
	 * 
	 * @param ambiente
	 *            o ambiente contendoo mapeamento de identificadores a valores.
	 * @return o valor do atributo acessado.
	 * @throws VariavelNaoDeclaradaException
	 * @throws VariavelJaDeclaradaException
	 * @throws ObjetoNaoDeclaradoException
	 */
	public Valor avaliar(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException, VariavelJaDeclaradaException,
			ObjetoNaoDeclaradoException {
		return obterValorDeIdNoAmbiente(ambiente);
	}

	/**
	 * Obt�m a express�o que acessa o identificador.
	 * 
	 * @return a expressao que acessa o identificador.
	 */
	public Expressao getExpressaoObjeto() {
		return varSuper;
	}

	/**
	 * Verifica se o super est� associado a um objeto e se o atributo existe.
	 * 
	 * @param ambiente
	 *            o ambiente com o mapeamento de identificadores a tipos.
	 * @return true, se o this est� associado a um objeto e se o atributo
	 *         existe, ou false, caso contr�rio.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) {
		boolean resposta = false;
		try {
			resposta = varSuper.checaTipo(ambiente);
			if (resposta) {
				Tipo tipo = varSuper.getTipo(ambiente);
				DefClasse defClasse = ambiente.getDefClasse(tipo.getTipo());
				defClasse.getTipoAtributo(super.getId());
				resposta = true;
			}
		} catch (VariavelNaoDeclaradaException atrib) {
			resposta = false;
		} catch (ClasseNaoDeclaradaException clas) {
			resposta = false;
		}
		return resposta;
	}

	/**
	 * Obt�m o tipo do atributo acessado.
	 * 
	 * @param ambiente
	 *            o ambiente com o mapeamento de identificadores a tipos.
	 * @return true, se foi associado um tipo a esse identificador acessado no
	 *         escopo corrente.
	 * @throws VariavelNaoDeclaradaException
	 * @throws ClasseNaoDeclaradaException
	 */
	public Tipo getTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException, ClasseNaoDeclaradaException {
		// Logo abaixo obtenho a definicao da Classe (seus m�todos e atributos).
		// this.getTipo() devera retornar uma instancia de TipoClasse e assim,
		// TipoClasse.getTipo()
		// retorna o id (contendo o nome da classe) associado ao tipo dela
		DefClasse defClasse = ((AmbienteExecucaoOO2) ambiente).getSuperClasse(varSuper.getTipo(ambiente).getTipo());
		// Em seguida retorno o tipo do atributo, caso ele esteja definido na
		// classe.
		// caso n�o esteja, uma exce��o ser� lan�ada
		return defClasse.getTipoAtributo(super.getId());
	}

	/**
	 * Retorna o valor do Objeto representado por um certo id
	 * 
	 * @param ambiente �
	 *            o Ambiente de Execu��o
	 * @return o valor do Objeto representado por um certo id
	 */
	private Valor obterValorDeIdNoAmbiente(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ObjetoNaoDeclaradoException {
		// Pegando o objeto no ambiente
		ValorRef referencia = (ValorRef) varSuper.avaliar(ambiente);
		Objeto objeto = ambiente.getObjeto(referencia);
		// Recuperando o mapeamento de valores do objeto (atributos do objeto)
		AmbienteExecucao aux = objeto.getEstado();

		HashMap<Id, Valor> mapping = aux.getPilha().pop();

		// Recuperando o valor do atributo "id" do objeto
		Valor valor = aux.getValor(super.getId());
		aux.getPilha().push(mapping);

		return valor;
	}
}