/* Arquivo ExpInstanceOf.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Modificações iniciais para que o instanceof 
 * reconheça interfaces
 */

package plp.orientadaObjetos2.expressao.binaria;

/*
 * A execucao de um comando ocorre em um determinado ambiente. O resultado de
 * tal execucao � a modifica��o deste ambiente, i.e., comandos tem efeito
 * colateral.
 */
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface;
import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface.IdTipo;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.AmbienteCompilacaoICABS;
import plp.interfaceclasseabstrata.memoria.AmbienteExecucaoICABS;
import plp.interfaceclasseabstrata.memoria.DefInterface;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.binaria.ExpBinaria;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.leftExpression.LeftExpression;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorBooleano;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoClasse;
import plp.orientadaObjetos1.util.TipoPrimitivo;
import plp.orientadaObjetos2.declaracao.classe.DecClasseSimplesOO2;
import plp.orientadaObjetos2.util.DefObjectFactory;

public class ExpInstanceOf extends ExpBinaria {

	/**
	 * Constr�i uma expressao instanceof com as sub-expressoes especificadas.
	 * Assume-se que estas sub-expressoes resultam em <code>ValorBooleano</code>
	 * quando avaliadas.
	 * 
	 * @param idObjeto
	 *            expressao que representa o identificador do objeto
	 * @param classe
	 *            expressao que representa a classe
	 */
	public ExpInstanceOf(Expressao idObjeto, Expressao classe) {
		super(idObjeto, classe, "instanceof");
	}

	/**
	 * Retorna o valor da expressao instanceof.
	 */
	public Valor avaliar(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException, VariavelJaDeclaradaException,
			ObjetoNaoDeclaradoException {

		LeftExpression classe = (LeftExpression) getDir();

		ValorRef valorRefObjeto = getValorRefObjeto(ambiente);
		Objeto objeto = getObjeto(ambiente, valorRefObjeto);
		DefClasse classeDoObjeto = getClasseDoObjeto(ambiente, objeto);

		if (classeDoObjeto.getIdClasse().equals(classe.getId()))
			return new ValorBooleano(true);

		LinkedHashSet<IdTipo> conj = RelacaoClasseInterface.getInstancia().getFechoSet(classeDoObjeto.getIdClasse(),
				RelacaoClasseInterface.ANY);

		if (conj == null)
			return new ValorBooleano(false);

		for (IdTipo idTipo : conj) {
			if (idTipo.getId().equals(classe.getId()))
				return new ValorBooleano(true);
		}
		return new ValorBooleano(false);
	}

	private ValorRef getValorRefObjeto(AmbienteExecucao ambiente) {
		ValorRef valorRefObjeto = null;
		LeftExpression idObjeto = (LeftExpression) getEsq();

		Stack pilha = ambiente.getPilha();
		Iterator iterator = pilha.iterator();

		while (iterator.hasNext()) {
			HashMap element = (HashMap) iterator.next();

			valorRefObjeto = (ValorRef) element.get(idObjeto.getId());

			if (valorRefObjeto != null) {
				break;
			}
		}

		return valorRefObjeto;
	}

	private Objeto getObjeto(AmbienteExecucao ambiente, ValorRef valorRefObjeto) {
		Objeto objeto = null;

		Stack pilhaObjetos = ambiente.getPilhaObjeto();
		Iterator iterator = pilhaObjetos.iterator();

		while (iterator.hasNext()) {
			HashMap element = (HashMap) iterator.next();

			objeto = (Objeto) element.get(valorRefObjeto);

			if (objeto != null) {
				break;
			}
		}

		return objeto;
	}

	private DefClasse getClasseDoObjeto(AmbienteExecucao ambiente, Objeto objeto) {
		DefClasse classeDoObjeto = null;

		Stack pilhaClasses = ambiente.getPilhaDefClasse();
		Iterator iterator = pilhaClasses.iterator();

		while (iterator.hasNext()) {
			HashMap element = (HashMap) iterator.next();

			classeDoObjeto = (DefClasse) element.get(objeto.getClasse());

			if (classeDoObjeto != null) {
				break;
			}
		}
		return classeDoObjeto;
	}

	/**
	 * Realiza a verificacao de tipos desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se os tipos da expressao s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 * @exception VariavelNaoDeclaradaException
	 *                se existir um identificador nao declarado no ambiente.
	 * @exception VariavelNaoDeclaradaException
	 *                se existir um identificador declarado mais de uma vez no
	 *                mesmo bloco do ambiente.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseNaoDeclaradaException {

		LeftExpression idObjeto = (LeftExpression) getEsq();
		LeftExpression classeInterface = (LeftExpression) getDir();

		Tipo tipoObjeto = ambiente.getTipo(idObjeto.getId());

		boolean nClasse = false, nInterface = false;

		try {
			ambiente.getDefClasse(classeInterface.getId());
		} catch (ClasseNaoDeclaradaException e) {
			nClasse = true;
		}
		try {
			((AmbienteCompilacaoICABS) ambiente).getDefInterface(classeInterface.getId());
		} catch (InterfaceNaoDeclaradaException e) {
			nInterface = true;
		}
		// Se o lado direito da expressão não for nem uma classe e nem uma
		// interface, jogar uma exceção
		if (nClasse && nInterface)
			throw new ClasseNaoDeclaradaException(classeInterface.getId());

		return (tipoObjeto instanceof TipoClasse);
	}

	/**
	 * Retorna os tipos possiveis desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException, ClasseNaoDeclaradaException {
		return TipoPrimitivo.TIPO_BOOLEANO;
	}

}