package plp.orientadaObjetos2.expressao;

import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.util.Tipo;

/**
 * Representa uma expressao utilizando o token "super"
 */
public class Super implements Expressao {
	/**
	 * Obt�m o valor do objeto super no ambiente e o avalia.
	 * 
	 * @param ambiente
	 *            o ambiente de execu�ao, que apresenta o mapeamento entre
	 *            identificadores e valores.
	 * @return o valor do objeto this no escopo do ambiente atual.
	 * @throws VariavelNaoDeclaradaException
	 *             Quando no escopo atual nao pode ser acessado o super.
	 * @throws VariavelJaDeclaradaException
	 *             Se por acaso se tentasse inserir no ambiente corrente mais de
	 *             um "this" com o mesmo escopo.
	 */
	public Valor avaliar(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException, VariavelJaDeclaradaException {
		return obterValorDoObjetoSuperNoAmbiente(ambiente);
	}

	/**
	 * Checa o tipo do objeto super.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o, contendo o mapeamento entre
	 *            identificadores e tipos.
	 * @return true, se o tipo do objeto super pode ser checado sem problemas,
	 *         false, caso contr�rio.
	 * @throws VariavelNaoDeclaradaException
	 *             Se nao houver nenhum objeto super no contexto corrente.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException {
		// Como sempre h� uma classe instanciada em orientacao a objeto
		// o checaTipo() de this retorna true
		return true;
	}

	/**
	 * Obt�m o tipo do objeto super
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o, contendo o mapeamento entre
	 *            identificadoes e tipos.
	 * @return o tipo do objeto super no ambiente.
	 * @throws VariavelNaoDeclaradaException
	 *             Se nao houver nenhum objeto super no contexto atual.
	 */
	public Tipo getTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException {
		return ambiente.getTipo(new Id("super"));
	}

	/**
	 * Retorna o valor do Objeto super no ambiente
	 * 
	 * @param ambiente �
	 *            o Ambiente de Execu��o
	 * @return o valor do Objeto super no ambiente
	 */
	private Valor obterValorDoObjetoSuperNoAmbiente(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException {
		return ambiente.getValor(new Id("super"));
	}

}