/* Arquivo DecProcedimentoSimplesOO2.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos2.declaracao.procedimento;

import java.util.Stack;

import plp.orientadaObjetos1.declaracao.procedimento.DecParametro;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimentoSimples;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.comando.Comando;
import plp.orientadaObjetos1.comando.Procedimento;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.util.ListaTipo;
import plp.orientadaObjetos2.comando.ProcedimentoOO2;
import plp.orientadaObjetos2.util.ModificadorEnum;

public class DecProcedimentoSimplesOO2 extends DecProcedimentoSimples {

	/**
	 * Modificador de acesso do procedimento. TODO: Alterar o parser para que
	 * this.modificador seja um ModificadorEnum.
	 */
	private String modificador;

	/**
	 * Construtor
	 * 
	 * @param nome
	 *            do procedimento
	 * @param parametrosFormais
	 *            do procedimento
	 * @param comando
	 *            corpo com o comando a ser executado
	 * @param modificador
	 *            modificador de acesso.
	 */
	public DecProcedimentoSimplesOO2(Id nome, ListaDeclaracaoParametro parametrosFormais, Comando comando,
			String modificador) {
		super(nome, parametrosFormais, comando);
		this.modificador = modificador;
	}

	/**
	 * Obt�m o procedimento representado por nome.
	 * 
	 * 
	 * @param nome
	 *            O nome do procedimento procurado.
	 * @return o procedimento identificado por nome.
	 * @throws ProcedimentoNaoDeclaradoException
	 *             quando n�o existe nenhum procedimento declarado com esse
	 *             nome.
	 */
	/*
	 * public Procedimento getProcedimento(Id nome) throws
	 * ProcedimentoNaoDeclaradoException { if(getNome().equals(nome)){
	 * ModificadorEnum mod = modificador.equals("private") ?
	 * ModificadorEnum.privado : ModificadorEnum.publico;
	 * 
	 * return new ProcedimentoOO2(getParametrosFormais(), getComando(), mod); }
	 * else { throw new ProcedimentoNaoDeclaradoException(nome); } }
	 */

	public Procedimento getProcedimento(Id nome, ListaTipo lt) throws ProcedimentoNaoDeclaradoException {
		if (getNome().equals(nome) && (lt.length() == getParametrosFormais().length())) {
			ListaDeclaracaoParametro l = getParametrosFormais();
			Stack<DecParametro> pilhaParam = new Stack<DecParametro>();
			while ((l != null) && (l.getHead() != null)) {
				pilhaParam.push(l.getHead());
				l = (ListaDeclaracaoParametro) l.getTail();
			}
			while (!pilhaParam.isEmpty()) {
				DecParametro dp = pilhaParam.pop();
				if (!dp.getTipo().equals(lt.head())) {
					throw new ProcedimentoNaoDeclaradoException(nome);
				}
				lt = lt.tail();
			}
			ModificadorEnum mod = modificador.equals("private") ? ModificadorEnum.privado : ModificadorEnum.publico;
			return new ProcedimentoOO2(getParametrosFormais(), getComando(), mod);
		} else {
			throw new ProcedimentoNaoDeclaradoException(nome);
		}
	}

	/**
	 * @return modificador de acesso
	 */
	public String getModificador() {
		return modificador;
	}

	/**
	 * Atualiza o modificador de acesso
	 */
	public void setModificador(String modificador) {
		this.modificador = modificador;
	}
}
