/* Arquivo DecClasseSimplesOO2.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos2.declaracao.classe;

import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface;
import plp.interfaceclasseabstrata.declaracao.classes.DecClasseAbstrata;
import plp.interfaceclasseabstrata.declaracao.classes.DeclaracaoClasse;
import plp.interfaceclasseabstrata.declaracao.classes.DecClasseICABS;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.interfaceclasseabstrata.memoria.DefClasseAbstrata;
import plp.interfaceclasseabstrata.memoria.DefClasseConcreta;
import plp.orientadaObjetos1.declaracao.procedimento.DecProcedimento;
import plp.orientadaObjetos1.declaracao.variavel.CompostaDecVariavel;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.util.TipoClasse;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;
import plp.orientadaObjetos2.util.DefObjectFactory;

public class DecClasseSimplesOO2 extends DeclaracaoClasse {

	protected Id superClasse;

	/**
	 * Construtor. Utiliza o identificador da super-classe e reusa, com o super,
	 * o construtor de DecClasseSimples.
	 * 
	 * @param nomeClasse
	 *            nome da classe sendo declarada.
	 * @param superClasse
	 *            identificador da super-classe. Caso <i>null</i>, eh utilizado
	 *            Object,
	 * @param atributos
	 *            declaracao dos atributos da classe
	 * @param metodos
	 *            declaracao dos metodos da classe
	 */
	public DecClasseSimplesOO2(Id nomeClasse, Id superClasse, DecVariavel atributos, DecProcedimento metodos) {
		super(nomeClasse, atributos, metodos);
		this.superClasse = superClasse != null ? superClasse : DefObjectFactory.OBJECT_ID;
	}

	/**
	 * Realiza uma checagem de tipos antes da execucao. Erros semanticos sao
	 * verificados durante essa checagem, Um dos erros a serem validados na
	 * declaracao de classe OO2 eh se a super classe jah foi definida.
	 * 
	 * Os demais itens a serem checados ja estao implementados no metodo
	 * checaTipo de DecClasseSimples.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		if (nomeClasse.equals(DefObjectFactory.OBJECT_ID)) {
			return super.checaTipo(ambiente);
		}

		AmbienteCompilacaoOO2 ambienteOO2 = (AmbienteCompilacaoOO2) ambiente;

		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			// TODO Rever esse m�todo createObject
			DefObjectFactory.createObject(ambienteOO2);
		}

		DefClasse defSuperClasse = ambienteOO2.getDefClasse(this.superClasse); // Pegam
																				// a
																				// Definição
																				// da
																				// superclasse
		DecVariavel atributosHerdados = defSuperClasse.getDecVariavel(); // Pegam
																			// as
																			// variáveis
																			// da
																			// superclasse

		/*
		 * Criam a nova classe, contendo os atributos da interface e os
		 * atributos dessa nova classe. Alteracao referente a classe abstrata,
		 * acrescenta o flag para saber se eh abstrata
		 */

		DefClasse defClasse = null;
		if (this instanceof DecClasseAbstrata) {
			defClasse = new DefClasseAbstrata(nomeClasse, new CompostaDecVariavel(atributos, atributosHerdados),
					metodos);
		} else
			defClasse = new DefClasseConcreta(nomeClasse, new CompostaDecVariavel(atributos, atributosHerdados),
					metodos);
		ambienteOO2.mapDefClasse(nomeClasse, defClasse);
		ambienteOO2.mapSuperClasse(nomeClasse, superClasse);

		boolean resposta = true;
		ambiente.incrementa();
		if (atributos != null) {
			resposta = atributos.checaTipo(ambiente);
		}
		ambiente.mapTipo(new Id("this"), new TipoClasse(nomeClasse));
		ambiente.mapTipo(new Id("super"), new TipoClasse(superClasse));
		if (metodos != null) {
			resposta = resposta && metodos.checaTipo(ambiente);
		}
		ambiente.restaura();

		/* Relacionamento extendsImplements */
		RelacaoClasseInterface.getInstancia().map(nomeClasse, superClasse, RelacaoClasseInterface.CLASS);
		/* Fim do código de relacionamento extendsImplements */
		return resposta;
	}

	/**
	 * Realiza um mapeamento entre a classe sendo declarada e sua super-classe.
	 * Para isso, eh usado o ambiente de execucao.
	 * 
	 * Note que o metodo eh completamento re-escrito. Nao eh feita uma chamada a
	 * super, porque a definicao da classe corrente precisa reusar os atributos
	 * da super-classe.
	 */

	// Por que que não são verificados os métodos? Para ver se eles estão
	// corretos (o elabora de DeclaracaoClasseSimples)
	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException {

		DefClasse defSuperClasse;

		if (superClasse.equals(DefObjectFactory.OBJECT_ID)) {
			// TODO Rever esse m�todo createObject
			DefObjectFactory.createObject(ambiente);
		}

		defSuperClasse = ((AmbienteExecucaoOO2) ambiente).getDefClasse(this.superClasse);
		DecVariavel atributosHerdados = defSuperClasse.getDecVariavel();

		/*
		 * Criam a nova classe, contendo os atributos da interface e os
		 * atributos dessa nova classe. Alteracao referente a classe abstrata,
		 * acrescenta o flag para saber se eh abstrata
		 */
		ambiente.mapDefClasse(nomeClasse, new DefClasse(nomeClasse, new CompostaDecVariavel(atributos,
				atributosHerdados), metodos));
		// ambiente.mapDefClasse(nomeClasse, new DefClasse(nomeClasse,
		// atributos, metodos));
		((AmbienteExecucaoOO2) ambiente).mapSuperClasse(nomeClasse, superClasse);

		return ambiente;
	}

}