/* Arquivo ChamadaMetodoOO2.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 *  
 */

package plp.orientadaObjetos2.comando;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.comando.ChamadaMetodo;
import plp.orientadaObjetos1.comando.ChamadaProcedimento;
import plp.orientadaObjetos1.comando.Procedimento;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.ListaExpressao;
import plp.orientadaObjetos1.expressao.This;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.memoria.Ambiente;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos1.util.ListaTipo;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos2.expressao.Super;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;
import plp.orientadaObjetos2.memoria.ContextoExecucaoOO2;
import plp.orientadaObjetos2.util.ModificadorEnum;

public class ChamadaMetodoOO2 extends ChamadaMetodo {

	public ChamadaMetodoOO2(Expressao expressao, Id nomeMetodo, ListaExpressao parametrosReais) {
		super(expressao, nomeMetodo, parametrosReais);
	}

	/*
	 * public AmbienteExecucao executar(AmbienteExecucao ambiente) throws
	 * VariavelJaDeclaradaException, VariavelNaoDeclaradaException,
	 * ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
	 * ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException,
	 * ClasseNaoDeclaradaException, ClasseJaDeclaradaException,
	 * InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
	 * AssinaturaJaDeclaradaException,
	 * AssinaturaNaoDeclaradaException,EntradaInvalidaException {
	 * 
	 * ValorRef vr = (ValorRef) expressao.avaliar(ambiente); // recupera o id do
	 * objeto Objeto objeto = ambiente.getObjeto(vr); // recupera o objeto Id
	 * idClasse = objeto.getClasse(); // recupera o tipo do objeto DefClasse
	 * defClasse = ambiente.getDefClasse(idClasse); // recupera a defini��o da
	 * classe if (expressao instanceof Super) { defClasse =
	 * ((AmbienteExecucaoOO2) ambiente).getSuperClasse(defClasse.getIdClasse()); }
	 * Procedimento metodo = getMetodoNaHierarquia(ambiente, defClasse);
	 * AmbienteExecucao aux = new ContextoExecucaoOO2(ambiente);
	 * 
	 * aux.changeValor(new Id("this"), vr); aux.changeValor(new Id("super"),
	 * vr);
	 * 
	 * ListaValor valoresDosParametros = parametrosReais.avaliar(ambiente); new
	 * ChamadaProcedimento(metodo, parametrosReais,
	 * valoresDosParametros).executar(aux); return ambiente; }
	 */

	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException, ClasseNaoDeclaradaException,
			ClasseJaDeclaradaException, InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
			AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException, EntradaInvalidaException {

		ValorRef vr = (ValorRef) expressao.avaliar(ambiente); // recupera o id
		// do objeto
		Objeto objeto = ambiente.getObjeto(vr); // recupera o objeto
		Id idClasse = objeto.getClasse(); // recupera o tipo do objeto
		DefClasse defClasse = ambiente.getDefClasse(idClasse); // recupera a
		// defini��o da
		// classe
		if (expressao instanceof Super) {
			defClasse = ((AmbienteExecucaoOO2) ambiente).getSuperClasse(defClasse.getIdClasse());
		}
		ListaValor valoresDosParametros = parametrosReais.avaliar(ambiente);
		Procedimento metodo = getMetodoNaHierarquia(ambiente, defClasse, ChamadaMetodo.getTipos(ambiente,
				valoresDosParametros));
		AmbienteExecucao aux = new ContextoExecucaoOO2(ambiente);

		aux.changeValor(new Id("this"), vr);
		aux.changeValor(new Id("super"), vr);

		new ChamadaProcedimento(metodo, parametrosReais, valoresDosParametros).executar(aux);
		return ambiente;
	}

	/*
	 * public boolean checaTipo(AmbienteCompilacao ambiente) throws
	 * VariavelNaoDeclaradaException, VariavelJaDeclaradaException,
	 * ClasseNaoDeclaradaException { boolean resposta; // Antes de incrementar o
	 * ambiente, verifico se o m�todo // � v�lido para a definicao de classe
	 * obtida a partir de expressao. // Se n�o for v�lido, a exce��o
	 * ProcedimentoNaoDeclaradoException ser� // lan�ada e checaTipo retornar�
	 * false.
	 * 
	 * Tipo tipoClasse = expressao.getTipo(ambiente); DefClasse defClasse =
	 * ambiente.getDefClasse(tipoClasse.getTipo());
	 * 
	 * try { ProcedimentoOO2 metodo = getMetodoNaHierarquia(ambiente,
	 * defClasse); ambiente.incrementa(); resposta = new
	 * ChamadaProcedimento(metodo, parametrosReais) .checaTipo(ambiente);
	 * ambiente.restaura(); // verifica o modificador de acesso!
	 * 
	 * if (!(expressao instanceof This) && metodo.getModificador() ==
	 * ModificadorEnum.privado) { System.out.println("Metodo: " + nomeMetodo + "
	 * privado"); return false; } // if(!(eMetodoDaClasse(nomeMetodo,
	 * defClasse)) && // metodo.getModificador() == ModificadorEnum.privado) { //
	 * resposta = false; // } } catch (ProcedimentoNaoDeclaradoException e) {
	 * System.out .println("Procedimento " + nomeMetodo + " nao encontrado");
	 * resposta = false; } return resposta; }
	 */

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ClasseNaoDeclaradaException {
		boolean resposta;
		// Antes de incrementar o ambiente, verifico se o m�todo
		// � v�lido para a definicao de classe obtida a partir de expressao.
		// Se n�o for v�lido, a exce��o ProcedimentoNaoDeclaradoException ser�
		// lan�ada e checaTipo retornar� false.

		Tipo tipoClasse = expressao.getTipo(ambiente);
		DefClasse defClasse = ambiente.getDefClasse(tipoClasse.getTipo());

		try {
			ProcedimentoOO2 metodo = getMetodoNaHierarquia(ambiente, defClasse, parametrosReais.getTipos(ambiente));
			ambiente.incrementa();
			resposta = new ChamadaProcedimento(metodo, parametrosReais).checaTipo(ambiente);
			ambiente.restaura();
			// verifica o modificador de acesso!

			if (!(expressao instanceof This) && metodo.getModificador() == ModificadorEnum.privado) {
				System.out.println("Metodo: " + nomeMetodo + " privado");
				return false;
			}
			// if(!(eMetodoDaClasse(nomeMetodo, defClasse)) &&
			// metodo.getModificador()
			// == ModificadorEnum.privado) {
			// resposta = false;
			// }
		} catch (ProcedimentoNaoDeclaradoException e) {
			System.out.println("Procedimento " + nomeMetodo + " nao encontrado");
			resposta = false;
		}
		return resposta;
	}

	/*
	 * Recupera um metodo chamado percorrendo a hierarquia.
	 * 
	 * A hierarquia dos ambientes parece que nao estah muito legal.
	 * 
	 * Isso porque tanto o ambiente de compilacao quanto execucao possuem
	 * aspectos em comum, inclusive o mapeamento do identificador da classe em
	 * sua respectiva superclasse. Nao eh algo inerente de OO2
	 * 
	 * Talvez valha a pena solicitar a equipe de apoio refatorar essa
	 * hierarquia.
	 * 
	 * O codigo abaixo ficou feio devido a esse problema.
	 */
	/*
	 * private ProcedimentoOO2 getMetodoNaHierarquia(Ambiente ambiente,
	 * DefClasse defClasse) throws ProcedimentoNaoDeclaradoException {
	 * 
	 * try { return (ProcedimentoOO2)defClasse.getMetodo(nomeMetodo); } catch
	 * (ProcedimentoNaoDeclaradoException e) { // procura na super-classe, se a
	 * mesma existir. try { DefClasse superClasse = null; if (ambiente
	 * instanceof AmbienteExecucao) { AmbienteExecucaoOO2 ambienteOO =
	 * (AmbienteExecucaoOO2) ambiente;
	 * 
	 * superClasse = ambienteOO.getSuperClasse(defClasse.getIdClasse()); } else {
	 * AmbienteCompilacaoOO2 ambienteOO = (AmbienteCompilacaoOO2) ambiente;
	 * superClasse = ambienteOO.getSuperClasse(defClasse.getIdClasse()); }
	 * 
	 * return getMetodoNaHierarquia(ambiente, superClasse); } catch
	 * (ClasseNaoDeclaradaException cnde) { throw new
	 * ProcedimentoNaoDeclaradoException(nomeMetodo); } } }
	 */

	private ProcedimentoOO2 getMetodoNaHierarquia(Ambiente ambiente, DefClasse defClasse, ListaTipo lt)
			throws ProcedimentoNaoDeclaradoException {

		try {
			Procedimento proc = defClasse.getMetodo(nomeMetodo, lt);
			return (ProcedimentoOO2) proc;
		} catch (ProcedimentoNaoDeclaradoException e) { // procura na
			// super-classe, se a
			// mesma existir.
			try {
				DefClasse superClasse = null;
				if (ambiente instanceof AmbienteExecucao) {
					AmbienteExecucaoOO2 ambienteOO = (AmbienteExecucaoOO2) ambiente;

					superClasse = ambienteOO.getSuperClasse(defClasse.getIdClasse());

				} else {
					AmbienteCompilacaoOO2 ambienteOO = (AmbienteCompilacaoOO2) ambiente;
					superClasse = ambienteOO.getSuperClasse(defClasse.getIdClasse());
				}

				return getMetodoNaHierarquia(ambiente, superClasse, lt);

			} catch (ClasseNaoDeclaradaException cnde) {
				throw new ProcedimentoNaoDeclaradoException(nomeMetodo);
			}

		}
	}

}
