package plp.orientadaObjetos2.comando;

import plp.orientadaObjetos1.comando.Comando;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.leftExpression.LeftExpression;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorBooleano;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.ContextoExecucao;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos2.expressao.binaria.ExpInstanceOf;
import plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2;

/**
 * Comando de cast de objeto e atribui��o deste a uma express�o esquerda.
 */
public class Cast implements Comando {

	/**
	 * Lado esquerdo do cast.
	 */
	private LeftExpression av;

	/**
	 * Identificador do objeto a ser atribuido.
	 */
	private Id idObjeto;

	/**
	 * Tipo da classe para fazer cast.
	 */
	private Tipo classeCast;

	/**
	 * Construtor.
	 * 
	 * @param av
	 *            Lado esquerdo da atribui��o.
	 * @param classe
	 *            Identificador com o nome da classe.
	 * @param classeCast
	 *            Tipo da classe para ser dado o cast.
	 */
	public Cast(LeftExpression av, Id idObjeto, Tipo classeCast) {
		this.av = av;
		this.idObjeto = idObjeto;
		this.classeCast = classeCast;
	}

	/**
	 * Execu��o de cast de um objeto a uma left expression.
	 * 
	 * @param ambiente
	 *            O ambiente contendo o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente de execu��o atualizado.
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException {

		ExpInstanceOf expInstanceOf = new ExpInstanceOf(idObjeto, classeCast.getTipo());

		if (!(av instanceof Id)) {
			throw new ObjetoNaoDeclaradoException(av.getId());
		} else {
			Valor valorRefEsquerda = av.avaliar(ambiente);
			Valor valorRefDireita = ambiente.getValor(idObjeto);
			if ((!(valorRefEsquerda instanceof ValorRef)) || (!(valorRefDireita instanceof ValorRef)))
				throw new ObjetoNaoDeclaradoException((valorRefEsquerda instanceof ValorRef) ? idObjeto : av.getId());
			if (((ValorBooleano) expInstanceOf.avaliar(ambiente)).valor()) {
				Objeto objetoAnterior = ambiente.getObjeto((ValorRef) valorRefEsquerda);
				Objeto novoObjeto = ambiente.getObjeto((ValorRef) valorRefDireita);
				((ContextoExecucao) ambiente).atualizarObjeto((ValorRef) valorRefEsquerda, novoObjeto);
				System.out.println(valorRefEsquerda.toString());
			} else {
				throw new ClassCastException("'" + idObjeto + " não é uma instância de " + classeCast + "'");
			}

		}

		if (!((ValorBooleano) expInstanceOf.avaliar(ambiente)).valor()) {

		}

		return ambiente;
	}

	/**
	 * Verifica se a atribui��o � poss�vel comparando os tipos do objeto e da
	 * left expression bem como verificando se esta tamb�m � filha da classe
	 * representada por <code>classeCast</code>.
	 * 
	 * @param ambiente
	 *            O ambiente de compila��o, com o mapeamento entre
	 *            identificadores e tipos.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException {

		AmbienteCompilacaoOO2 ambienteOO = (AmbienteCompilacaoOO2) ambiente;

		boolean result = av.checaTipo(ambiente) && ambiente.getTipo(av.getId()).equals(classeCast);

		if (!result) {
			return result;
		}

		return eValido(ambienteOO, classeCast.getTipo());
	}

	/**
	 * Verifica recusivamente se o a classe do objeto representado por
	 * <code>idObjeto</code> tem como subclasse <code>classeCast</code>.
	 * 
	 * @param ambiente
	 *            O ambiente de compila��o.
	 */
	private boolean eValido(AmbienteCompilacaoOO2 ambiente, Id idClasse) throws VariavelNaoDeclaradaException {
		try {
			Id idSuperClasse = ambiente.getSuperClasse(idClasse).getIdClasse();

			if (!idSuperClasse.equals(ambiente.getTipo(idObjeto).getTipo())) {
				return eValido(ambiente, idSuperClasse);
			}
		} catch (ClasseNaoDeclaradaException ex) {
			return false;
		}
		return true;
	}

}