package plp.orientadaObjetos2.comando;

import plp.orientadaObjetos1.comando.Atribuicao;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.leftExpression.LeftExpression;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoClasse;

public class AtribuicaoOO2 extends Atribuicao {

	public AtribuicaoOO2(LeftExpression av, Expressao expressao) {
		super(av, expressao);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see plp.orientadaObjetos1.comando.Comando#checaTipo(plp.orientadaObjetos1.memoria.AmbienteCompilacao)
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseNaoDeclaradaException {
		boolean atribuicao = false;

		if ((getExpressao().getTipo(ambiente) instanceof TipoClasse)
				&& (getExpressao().getTipo(ambiente) instanceof TipoClasse)) {

			Tipo esquerda = ambiente.getTipo(getAv().getId());
			Tipo direita = getExpressao().getTipo(ambiente);

			DefClasse classeEsquerda = ambiente.getDefClasse(esquerda.getTipo());
			DefClasse classeDireita = ambiente.getDefClasse(direita.getTipo());

			try {
				DefClasse superClasse = ((plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2) ambiente)
						.getSuperClasse(classeDireita.getIdClasse());
				while (superClasse != null) {
					if (superClasse.equals(classeEsquerda)) {
						atribuicao = true;
						break;
					}
					superClasse = ((plp.orientadaObjetos2.memoria.AmbienteCompilacaoOO2) ambiente)
							.getSuperClasse(superClasse.getIdClasse());
				}
			} catch (NullPointerException e) {
				return false;
			}
		}

		// return (getExpressao().checaTipo(ambiente)
		// &&
		// (getAv().getTipo(ambiente).equals(getExpressao().getTipo(ambiente))
		// || getExpressao().getTipo(ambiente).equals(TipoClasse.TIPO_NULL)))
		// || atribuicao;

		Tipo t1 = getAv().getTipo(ambiente);
		Tipo t2 = getExpressao().getTipo(ambiente);
		return (getExpressao().checaTipo(ambiente) && (t1.equals(t2) || getExpressao().getTipo(ambiente).equals(
				TipoClasse.TIPO_NULL)))
				|| atribuicao;

	}

}
