/* Arquivo ContextoExecucao.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Adicionado mapDefInterface e getDefInterface
 * Carlos Eduardo Pontual - 14/04/08 - Adicionado pilhaDefInterface
 * Carlos Eduardo Pontual - 18/04/08 - Substituição do método getDefInterface para 
 * 		suportar implementação de múltiplas interfaces por uma classe
 * Carlos Eduardo Pontual - 21/04/08 - Alteração no método getElemento e remoção
 * 		da excecao GetElemento, além de alterar os métodos que chamam getElemento
 */

package plp.orientadaObjetos1.memoria;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;

import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorBooleano;
import plp.orientadaObjetos1.expressao.valor.ValorInteiro;
import plp.orientadaObjetos1.expressao.valor.ValorNull;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.expressao.valor.ValorString;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoPrimitivo;

public class ContextoExecucao implements AmbienteExecucao {

	/**
	 * A pilha de blocos de contexto.
	 */
	private Stack<HashMap<Id, Valor>> pilha;

	/**
	 * A pilha de classes do contexto.
	 */
	private Stack<HashMap<Id, DefClasse>> pilhaDefClasse;

	/**
	 * A pilha de objetos de contexto.
	 */

	private Stack<HashMap<ValorRef, Objeto>> pilhaObjeto;

	/**
	 * A pilha de blocos de contexto.
	 */
	private ListaValor entrada;

	/**
	 * A pilha de blocos de contexto.
	 */
	private ListaValor saida;

	/**
	 * A refer�ncia do objeto a ser inserido na pilha de objetos
	 */
	private ValorRef proxRef;

	/**
	 * Construtor utilizado quando queremos ler do teclado.
	 */
	public ContextoExecucao() {
		pilha = new Stack<HashMap<Id, Valor>>();

		pilhaObjeto = new Stack<HashMap<ValorRef, Objeto>>(); // esta
		// pilha nao
		// cresce
		pilhaObjeto.push(new HashMap<ValorRef, Objeto>()); // tem de
		// incrementar
		// no come�o

		pilhaDefClasse = new Stack<HashMap<Id, DefClasse>>(); // esta
		// pilha nao
		// cresce
		pilhaDefClasse.push(new HashMap<Id, DefClasse>()); // tem de
		// incrementar
		// no come�o
		this.entrada = null;
		this.saida = new ListaValor();
	}

	/**
	 * Construtor da classe.
	 */
	public ContextoExecucao(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException {
		proxRef = ambiente.getRef();
		this.pilhaObjeto = ambiente.getPilhaObjeto();
		this.pilhaDefClasse = ambiente.getPilhaDefClasse();
		this.entrada = ambiente.getEntrada();
		this.saida = ambiente.getSaida();
		pilha = new Stack<HashMap<Id, Valor>>();
		HashMap<Id, Valor> aux = new HashMap<Id, Valor>();
		aux.put(new Id("this"), new ValorNull());
		pilha.push(aux);

	}

	/**
	 * Construtor.
	 * 
	 * @param entrada
	 *            Entrada para o contexto de execu��o.
	 */
	public ContextoExecucao(ListaValor entrada) {
		pilha = new Stack<HashMap<Id, Valor>>();

		pilhaObjeto = new Stack<HashMap<ValorRef, Objeto>>(); // esta
		// pilha nao
		// cresce
		pilhaObjeto.push(new HashMap<ValorRef, Objeto>()); // tem de
		// incrementar
		// no come�o

		pilhaDefClasse = new Stack<HashMap<Id, DefClasse>>(); // esta
		// pilha nao
		// cresce
		pilhaDefClasse.push(new HashMap<Id, DefClasse>()); // tem de
		// incrementar
		// no come�o

		this.entrada = entrada;
		this.saida = new ListaValor();
	}

	/**
	 * Obt�m a pilha de valores associados a identificadores
	 * 
	 * @return a pilha de valores associados a identificadores.
	 */
	public Stack<HashMap<Id, Valor>> getPilha() {
		return this.pilha;
	}

	/**
	 * Retorna a pilha com as defini�oes das classes.
	 * 
	 * @return a pilha com as defini�oes das classes.
	 */
	public Stack<HashMap<Id, DefClasse>> getPilhaDefClasse() {
		return this.pilhaDefClasse;
	}

	/**
	 * Obt�m a pilha com os objetos e seus valores.
	 * 
	 * @return a pilha com os objetos e seus valores.
	 */
	public Stack<HashMap<ValorRef, Objeto>> getPilhaObjeto() {
		return this.pilhaObjeto;
	}

	/**
	 * L� da entrada padr�o e associa o conte�do a um determinado identificador.
	 * 
	 * @param tipoIdLido
	 *            Tipo do identificador ao qual ser� associado o valor lido.
	 * @return o valor lido.
	 * @throws EntradaInvalidaException
	 *             Quando a entrada fornecida n�o pode ser atribu�da ao tipo do
	 *             identificador.
	 */
	public Valor read(Tipo tipoIdLido) throws EntradaInvalidaException {
		String valorLido = leEntrada();
		if (valorLido != null) {
			valorLido = valorLido.trim();
			if (tipoIdLido instanceof TipoPrimitivo) {
				TipoPrimitivo tipo = (TipoPrimitivo) tipoIdLido;
				try {
					if (tipo.eBooleano()) {
						return new ValorBooleano(Boolean.getBoolean(valorLido));
					} else if (tipo.eInteiro()) {
						return new ValorInteiro(Integer.parseInt(valorLido));
					} else if (tipo.eString()) {
						return new ValorString(valorLido);
					}
				} catch (NumberFormatException e) {
					throw new EntradaInvalidaException("O tipo da entrada e o da vari�vel"
							+ " a ser lida s�o diferentes!");
				}
			}
		}
		throw new EntradaInvalidaException("O tipo da vari�vel a ser lida n�o � um tipo Primitivo!");
	}

	/**
	 * Este m�todo l� uma entrada que pode ser de uma tail ou do teclado
	 * 
	 * @return Obt�m uma entrada que pode ser de uma tail ou do teclado
	 * @exception Lan�a
	 *                uma exce��o se a tail com os valores nao tiver mais
	 *                elementos.
	 */
	private String leEntrada() throws EntradaInvalidaException {
		if (this.entrada == null) {
			return leDaEntradaPadrao();
		} else {
			// Se nao tivermos mais nada na tail de valores
			if (entrada.length() == 0) {
				throw new EntradaInvalidaException("N�mero de argumentos menor do que o n�mero de reads!");
			}
			return leDaListaValor();
		}
	}

	/**
	 * Este m�todo l� da entrada padr�o
	 * 
	 * @return o que o usu�rio digitou na entrada padr�o
	 */
	private String leDaEntradaPadrao() {
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
			return in.readLine();
		} catch (IOException e) {
			System.out.println("Erro no valor lido da entrada padr�o");
		}
		return "";
	}

	/**
	 * Este m�todo l� da entrada padr�o
	 * 
	 * @return o que o usu�rio digitou na entrada padr�o
	 */
	private String leDaListaValor() {
		String retorno = entrada.getHead().toString();
		entrada = (ListaValor) entrada.getTail();
		return retorno;
	}

	/**
	 * Obt�m a sa�da.
	 * 
	 * @return a sa�da.
	 */
	public ListaValor getSaida() {
		return saida;
	}

	/**
	 * Obt�m a entrada.
	 * 
	 * @return a entrada.
	 */
	public ListaValor getEntrada() {
		return entrada;
	}

	/**
	 * Escreve um valor 'v' na sa�da.
	 * 
	 * @param v
	 *            O valor a ser escrito.
	 * @return o ambiente de execu��o, que representa o estado atual.
	 */
	public AmbienteExecucao write(Valor v) {
		saida.write(v);
		return this;
	}

	/**
	 * Incrementa a pilha do ambiente, passando para o pr�ximo estado.
	 */
	public void incrementa() {
		pilha.push(new HashMap<Id, Valor>());
	}

	/**
	 * Restaura o estado do ambiente.
	 */
	public void restaura() {
		pilha.pop();
	}

	/**
	 * Mapeia um identificador a um valor.
	 * 
	 * @param idArg
	 *            Identificador.
	 * @param valorId
	 *            Valor que vai ser associado ao identificador.
	 * @throws VariavelJaDeclaradaException
	 *             Quando a vari�vel j� foi declarada.
	 */
	public void mapValor(Id idArg, Valor valorId) throws VariavelJaDeclaradaException {
		HashMap<Id, Valor> aux = pilha.peek();
		if (aux.put(idArg, valorId) != null) {
			throw new VariavelJaDeclaradaException(idArg);
		}

	}

	/**
	 * Mapeia um identificador a um defini��o de classe.
	 * 
	 * @param idArg
	 *            o nome da classe
	 * @param defClasse
	 *            Defini��o da Classe.
	 * @throws ClasseJaDeclaradaException
	 *             quando a classe j� foi declarada.
	 */
	public void mapDefClasse(Id idArg, DefClasse defClasse) throws ClasseJaDeclaradaException {
		HashMap<Id, DefClasse> aux = pilhaDefClasse.peek();
		if (aux.put(idArg, defClasse) != null) {
			throw new ClasseJaDeclaradaException(idArg);
		}
	}

	/**
	 * Mapeia um valor refer�ncia a um objeto.
	 * 
	 * @param valorRef
	 *            Valor refer�ncia.
	 * @param objeto
	 *            Objeto.
	 * @throws ObjetoJaDeclaradoException
	 *             Quando esse objeto j� foi declarado.
	 */
	public void mapObjeto(ValorRef valorRef, Objeto objeto) throws ObjetoJaDeclaradoException {
		HashMap<ValorRef, Objeto> aux = pilhaObjeto.peek();
		if (aux.put(valorRef, objeto) != null) {
			throw new ObjetoJaDeclaradoException(objeto.getClasse());
		}
	}

	public void atualizarObjeto(ValorRef valorRef, Objeto objeto) throws ObjetoNaoDeclaradoException {
		HashMap<ValorRef, Objeto> aux = pilhaObjeto.peek();
		if (aux.put(valorRef, objeto) == null) {
			aux.remove(valorRef);
			throw new ObjetoNaoDeclaradoException(objeto.getClasse());
		}
	}

	/**
	 * Altera o valor associado a um identificador.
	 * 
	 * @param idArg
	 *            Identificador.
	 * @param valorId
	 *            O valor a ser associado ao identificador.
	 * @throws VariavelNaoDeclaradaException
	 *             Quando a vari�vel n�o foi declarada.
	 */
	public void changeValor(Id idArg, Valor valorId) throws VariavelNaoDeclaradaException {
		Valor resultado = null;
		for (int i = 1; i <= pilha.size(); i++) {
			HashMap<Id, Valor> aux = pilha.elementAt(pilha.size() - i);
			resultado = aux.get(idArg);
			if (resultado != null) {
				aux.put(idArg, valorId);
				break;
			}
		}
		if (resultado == null)
			throw new VariavelNaoDeclaradaException(idArg);
	}

	/**
	 * Obt�m o valor associado a um determinado identificador.
	 * 
	 * @param idArg
	 *            Identificador
	 * @return o valor associado a um determinado identificador.
	 * @throws VariavelNaoDeclaradaException
	 *             Quando a vari�vel n�o foi declarada.
	 */

	public Valor getValor(Id idArg) throws VariavelNaoDeclaradaException {
		return getElemento(idArg, pilha, new VariavelNaoDeclaradaException(idArg));
	}

	/**
	 * Obt�m a defini��o da classe cujo nome � idArg
	 * 
	 * @param idArg
	 *            Nome da classe.
	 * @return a defini��o da classe.
	 * @throws ClasseNaoDeclaradaException
	 *             quando nao foi declarada nenhuma classe com esse nome.
	 */
	public DefClasse getDefClasse(Id idArg) throws ClasseNaoDeclaradaException {
		return getElemento(idArg, pilhaDefClasse, new ClasseNaoDeclaradaException(idArg));
	}

	/**
	 * Obt�m o objeto associado a um dado valor referencia.
	 * 
	 * @param valorRef
	 *            Valor refer�ncia
	 * @return o objeto associado a um dado valor referencia.
	 * @throws ObjetoNaoDeclaradoException
	 *             Quando o objeto n�o foi declarado.
	 */
	public Objeto getObjeto(ValorRef valorRef) throws ObjetoNaoDeclaradoException {
		return getElemento(valorRef, pilhaObjeto, new ObjetoNaoDeclaradoException(new Id(valorRef.toString())));
	}

	/**
	 * Obt�m a pr�xima refer�ncia de acordo com o contexto atual de execu��o.
	 * 
	 * @return a pr�xima refer�ncia de acordo com o contexto atual de execu��o.
	 */
	public ValorRef getProxRef() {
		ValorRef aux = new ValorRef(proxRef.valor());
		proxRef = proxRef.incrementa();
		return aux;
	}

	/**
	 * Obt�m o valor referencia atual.
	 * 
	 * @return o valor referencia atual.
	 */
	public ValorRef getRef() {
		if (proxRef == null)
			proxRef = new ValorRef(ValorRef.VALOR_INICIAL);
		return proxRef;
	}

	/**
	 * Retorna a representa��o textual do contexto de execu��o.
	 * 
	 * @return a representa��o textual do contexto de execu��o.
	 */
	public String toString() {
		String resposta = null;
		Valor valor = null;
		Objeto objeto = null;
		Stack<HashMap<Id, Valor>> auxStack = new Stack<HashMap<Id, Valor>>();
		Stack<HashMap<ValorRef, Objeto>> auxStackObjeto = new Stack<HashMap<ValorRef, Objeto>>();

		while (!pilha.empty()) {
			HashMap<Id, Valor> aux = pilha.pop();
			auxStack.push(aux);
			for (Id id : aux.keySet()) {
				valor = aux.get(id);
				resposta = id + " " + valor + "\n";
			}
		}
		while (!auxStack.empty()) {
			pilha.push(auxStack.pop());
		}
		while (!pilhaObjeto.empty()) {
			HashMap<ValorRef, Objeto> aux = pilhaObjeto.pop();
			auxStackObjeto.push(aux);
			for (ValorRef valorRef : aux.keySet()) {
				objeto = aux.get(valorRef);
				resposta = valorRef + " " + objeto + "\n";
			}
		}
		while (!auxStackObjeto.empty()) {
			pilhaObjeto.push(auxStackObjeto.pop());
		}
		return resposta;
	}

	/**
	 * Obt�m um novo contexto de execu��o com a mesma entrada, sa�da e pilha de
	 * mapeamentos id/valor.
	 * 
	 * @return um novo contexto de execu��o com a mesma entrada, sa�da e pilha
	 *         de mapeamentos id/valor.
	 */
	public ContextoExecucao getContextoIdValor() {
		ContextoExecucao ambiente = new ContextoExecucao(this.getEntrada());
		ambiente.pilha = this.pilha;
		ambiente.saida = this.saida;
		return ambiente;
	}

	public static <T, U, V extends Exception> T getElemento(U idArg, Stack<HashMap<U, T>> pilha, V excecao) throws V {
		T resultado = null;
		for (int i = 1; i <= pilha.size(); i++) {
			HashMap<U, T> aux = pilha.elementAt(pilha.size() - i);
			resultado = aux.get(idArg);
			if (resultado != null)
				break;
		}
		if (resultado == null)
			throw excecao;
		return resultado;
	}
}