/* Arquivo ContextoCompilacao.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado mapAssinaturas e getParametrosAssinaturas
 * Carlos Eduardo Pontual - 14/04/08: Adicionado mapDefInterface e getDefInterface
 * Carlos Eduardo Pontual - 14/04/08: Adicionado pilhaAssinaturas e pilhaDefInterface
 * Carlos Eduardo Pontual - 20/04/08: Os métodos adicionados nas três últimas modificações foram movidos
 * 		para o ContextoCompilacaoICABS.java
 * Carlos Eduardo Pontual - 21/04/08 - Alteração nos metodos que chamam 
 * 		ContextoExecucao.getElemento
 */

package plp.orientadaObjetos1.memoria;

import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos1.util.Tipo;

/**
 * Representa o contexto de compila�ao.
 */
public class ContextoCompilacao implements AmbienteCompilacao {

	/**
	 * A pilha de tipos do contexto. Onde o tipo do id pode ser um tipo
	 * primitivo ou uma classe.
	 */
	private Stack<HashMap<Id, Tipo>> pilha;

	/**
	 * A pilha de procedimentos do contexto.
	 */
	private Stack<HashMap<Id, Vector<ListaDeclaracaoParametro>>> pilhaProcedimento;

	/**
	 * A pilha de classes do contexto.
	 */
	private Stack<HashMap<Id, DefClasse>> pilhaDefClasse;

	/**
	 * A tail de valores inicias do contexto.
	 */
	private ListaValor entrada;

	/**
	 * O Construtor da classe.
	 */
	public ContextoCompilacao(ListaValor entrada) {
		pilha = new Stack<HashMap<Id, Tipo>>();
		pilhaProcedimento = new Stack<HashMap<Id, Vector<ListaDeclaracaoParametro>>>();
		// esta pilha nao cresce, podia ser só um hash
		pilhaDefClasse = new Stack<HashMap<Id, DefClasse>>();
		pilhaDefClasse.push(new HashMap<Id, DefClasse>()); // tem de
		// incrementar no
		// come�o
		this.entrada = entrada;
	}

	/**
	 * Incrementa a pilha do ambiente, passando para o pr�ximo estado.
	 */
	public void incrementa() {
		pilha.push(new HashMap<Id, Tipo>());
		pilhaProcedimento.push(new HashMap<Id, Vector<ListaDeclaracaoParametro>>());
	}

	/**
	 * Restaura o estado do ambiente.
	 */
	public void restaura() {
		pilha.pop();
		pilhaProcedimento.pop();
	}

	/**
	 * Mapeia um identificador a um tipo.
	 * 
	 * @param idArg
	 *            Identificador
	 * @param tipoId
	 *            Tipo que deve ser associado ao identificador.
	 * @throws VariavelJaDeclaradaException
	 *             quando o id j� foi declarado.
	 */
	public void mapTipo(Id idArg, Tipo tipoId) throws VariavelJaDeclaradaException {
		HashMap<Id, Tipo> aux = pilha.peek();
		if (aux.put(idArg, tipoId) != null) {
			throw new VariavelJaDeclaradaException(idArg);
		}
	}

	/**
	 * Mapeia um identificador representando um m�todo aos seus par�metros.
	 * 
	 * @param idArg
	 *            identificador do m�todo.
	 * @param parametrosId
	 *            Par�metros do m�todo
	 * @throws ProcedimentoJaDeclaradoException
	 *             quando o procedimento j� foi declarado.
	 */

	public void mapParametrosProcedimento(Id idArg, ListaDeclaracaoParametro parametrosId)
			throws ProcedimentoJaDeclaradoException {
		Vector<ListaDeclaracaoParametro> procedimentos = null;
		HashMap<Id, Vector<ListaDeclaracaoParametro>> aux = pilhaProcedimento.peek();
		try {
			procedimentos = getParametrosProcedimento(idArg);
			aux.remove(idArg);
		} catch (ProcedimentoNaoDeclaradoException e) {
			procedimentos = new Vector<ListaDeclaracaoParametro>();
		}
		for (ListaDeclaracaoParametro ldp : procedimentos)
			if (ldp.equals(parametrosId))
				throw new ProcedimentoJaDeclaradoException(idArg);
		procedimentos.add(parametrosId);
		if (aux.put(idArg, procedimentos) != null) {
			throw new ProcedimentoJaDeclaradoException(idArg);
		}
	}

	/**
	 * Mapeia um identificador a um defini��o de classe.
	 * 
	 * @param idArg
	 *            o nome da classe
	 * @param defClasse
	 *            Defini��o da Classe.
	 * @throws ClasseJaDeclaradaException
	 *             quando a classe j� foi declarada.
	 */
	public void mapDefClasse(Id idArg, DefClasse defClasse) throws ClasseJaDeclaradaException {
		HashMap<Id, DefClasse> aux = pilhaDefClasse.peek();
		if (aux.put(idArg, defClasse) != null) {
			throw new ClasseJaDeclaradaException(idArg);
		}
	}

	/**
	 * Obt�m o tipo associado a um dado identificador
	 * 
	 * @param idArg
	 *            Identificador
	 * @return Tipo associado a um dado identificador
	 * @throws VariavelNaoDeclaradaException
	 *             quando id n�o foi declarado.
	 */
	public Tipo getTipo(Id idArg) throws VariavelNaoDeclaradaException {
		return ContextoExecucao.getElemento(idArg, pilha, new VariavelNaoDeclaradaException(idArg));
	}

	/**
	 * Obt�m a tail de par�metros associada a um identificador que representa
	 * nome do m�todo.
	 * 
	 * @param idArg
	 *            Identificador que representa o nome do m�todo.
	 * @return Lista de par�metros Lista de par�metros associada a um
	 *         identificador que representa nome do m�todo.
	 * @throws ProcedimentoNaoDeclaradoException
	 *             quando n�o foi declarado nenhum m�todo com esse id.
	 */
	public Vector<ListaDeclaracaoParametro> getParametrosProcedimento(Id idArg)
			throws ProcedimentoNaoDeclaradoException {
		return ContextoExecucao.getElemento(idArg, pilhaProcedimento, new ProcedimentoNaoDeclaradoException(idArg));
	}

	/**
	 * Obt�m a defini��o da classe cujo nome � idArg
	 * 
	 * @param idArg
	 *            Nome da classe.
	 * @return a defini��o da classe.
	 * @throws ClasseNaoDeclaradaException
	 *             quando nao foi declarada nenhuma classe com esse nome.
	 */
	public DefClasse getDefClasse(Id idArg) throws ClasseNaoDeclaradaException {
		return ContextoExecucao.getElemento(idArg, pilhaDefClasse, new ClasseNaoDeclaradaException(idArg));
	}

	/**
	 * Obt�m o tipo da entrada atual para este ambiente.
	 * 
	 * @return o tipo da entrada.
	 * @throws VariavelNaoDeclaradaException
	 *             quando a entrada atual � uma vari�vel n�o declarada.
	 */
	public Tipo getTipoEntrada() throws VariavelNaoDeclaradaException {
		Tipo aux = entrada.getHead().getTipo(this);
		entrada = (ListaValor) entrada.getTail();
		return aux;
	}

}