/* Arquivo AmbienteCompilacao.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado mapAssinaturas e getParametrosAssinaturas
 * Carlos Eduardo Pontual - 14/04/08: Adicionado mapDefInterface e getDefInterface
 * Carlos Eduardo Pontual - 20/04/08: Os métodos adicionados nas duas últimas modificações foram movidos
 * 		para o AmbienteCompilacaoICABS.java
 */

package plp.orientadaObjetos1.memoria;

import java.util.Vector;

import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.util.Tipo;

/**
 * Classe que representa o ambiente de compilação, contendo o mapeamento entre
 * identificadores e tipos.
 */
public interface AmbienteCompilacao extends Ambiente {
	/**
	 * Mapeia um identificador a um tipo.
	 * 
	 * @param idArg
	 *            Identificador
	 * @param tipoId
	 *            Tipo que deve ser associado ao identificador.
	 * @throws VariavelJaDeclaradaException
	 *             quando o id já foi declarado.
	 */
	public void mapTipo(Id idArg, Tipo tipoId) throws VariavelJaDeclaradaException;

	/**
	 * Obtém o tipo associado a um dado identificador
	 * 
	 * @param idArg
	 *            Identificador
	 * @return Tipo associado a um dado identificador
	 * @throws VariavelNaoDeclaradaException
	 *             quando id não foi declarado.
	 */
	public Tipo getTipo(Id idArg) throws VariavelNaoDeclaradaException;

	/**
	 * Mapeia um identificador representando um m�todo aos seus par�metros.
	 * 
	 * @param idArg
	 *            identificador do m�todo.
	 * @param parametrosId
	 *            Par�metros do m�todo
	 * @throws ProcedimentoJaDeclaradoException
	 *             quando o procedimento j� foi declarado.
	 */
	public void mapParametrosProcedimento(Id idArg, ListaDeclaracaoParametro parametrosId)
			throws ProcedimentoJaDeclaradoException;

	/**
	 * Obt�m a tail de par�metros associada a um identificador que representa
	 * nome do m�todo.
	 * 
	 * @param idArg
	 *            Identificador que representa o nome do m�todo.
	 * @return Lista de par�metros Lista de par�metros associada a um
	 *         identificador que representa nome do m�todo.
	 * @throws ProcedimentoNaoDeclaradoException
	 *             quando n�o foi declarado nenhum m�todo com esse id.
	 */
	// public ListaDeclaracaoParametro getParametrosProcedimento(Id idArg)
	// throws ProcedimentoNaoDeclaradoException;
	public Vector<ListaDeclaracaoParametro> getParametrosProcedimento(Id idArg)
			throws ProcedimentoNaoDeclaradoException;

	/**
	 * Mapeia um identificador a um defini��o de classe.
	 * 
	 * @param idArg
	 *            o nome da classe
	 * @param defClasse
	 *            Defini��o da Classe.
	 * @throws ClasseJaDeclaradaException
	 *             quando a classe j� foi declarada.
	 */
	public void mapDefClasse(Id idArg, DefClasse defClasse) throws ClasseJaDeclaradaException;

	/**
	 * Obt�m a defini��o da classe cujo nome � idArg
	 * 
	 * @param idArg
	 *            Nome da classe.
	 * @return a defini��o da classe.
	 * @throws ClasseNaoDeclaradaException
	 *             quando nao foi declarada nenhuma classe com esse nome.
	 */
	public DefClasse getDefClasse(Id idArg) throws ClasseNaoDeclaradaException;

	/**
	 * Obt�m o tipo da entrada atual para este ambiente.
	 * 
	 * @return o tipo da entrada.
	 * @throws VariavelNaoDeclaradaException
	 *             quando a entrada atual � uma vari�vel n�o declarada.
	 */
	public Tipo getTipoEntrada() throws VariavelNaoDeclaradaException;

}
