package plp.orientadaObjetos1.expressao.valor;

import plp.orientadaObjetos1.memoria.Ambiente;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoPrimitivo;

/**
 * Objetos desta classe encapsulam valor inteiro.
 */
public class ValorInteiro implements ValorConcreto {

	private int valor;

	/**
	 * Cria <code>ValorInteiro</code> contendo o valor fornecido.
	 */
	public ValorInteiro(int valor) {
		this.valor = valor;
	}

	/**
	 * Retorna o valor inteiro encapsulado pelo objeto deste tipo.
	 */
	public int valor() {
		return valor;
	}

	/**
	 * Retorna o valor deste valor primitivo, i.e., ele mesmo.
	 */
	public Valor avaliar(AmbienteExecucao amb) {
		return this;
	}

	/**
	 * Determina igualdade entre objetos deste tipo
	 */
	public boolean equals(ValorConcreto obj) {
		if (obj instanceof ValorInteiro) {
			return valor == ((ValorInteiro) obj).valor();
		} else {
			return false;
		}
	}

	/**
	 * Retorna texto representando o valor inteiro do objeto desta classe.
	 */
	public String toString() {
		return String.valueOf(valor);
	}

	/**
	 * Realiza a verificacao de tipos desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se os tipos da expressao s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao amb) {
		return true;
	}

	/**
	 * Retorna os tipos possiveis desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(AmbienteCompilacao amb) {
		return TipoPrimitivo.TIPO_INTEIRO;
	}

	/**
	 * Retorna os tipos possiveis desta expressao. Inserido para possibilitar o
	 * uso do overload
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(Ambiente ambiente) {
		return TipoPrimitivo.TIPO_INTEIRO;
	}

}
