package plp.orientadaObjetos1.expressao.valor;

import plp.orientadaObjetos1.memoria.Ambiente;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoPrimitivo;

/**
 * Este valor primitivo encapsula um valor booleano.
 */
public class ValorBooleano implements ValorConcreto {

	private boolean valor;

	/**
	 * Cria um objeto encapsulando o valor booleano fornecido.
	 */
	public ValorBooleano(boolean valor) {
		this.valor = valor;
	}

	/**
	 * Retorna o valor deste valor primitivo, i.e, ele mesmo.
	 */
	public Valor avaliar(AmbienteExecucao amb) {
		return this;
	}

	/**
	 * Retorna o valor booleano encapsulado pelo objeto do tipo
	 * <code>ValorBooleano</code>
	 */
	public boolean valor() {
		return valor;
	}

	/**
	 * Determina igualdade entre valores do tipo <code>ValorBooleano</code>
	 */
	public boolean equals(ValorConcreto obj) {
		if (obj instanceof ValorBooleano) {
			return valor == ((ValorBooleano) obj).valor();
		} else {
			return false;
		}
	}

	/**
	 * Retorna texto representando o valor booleano
	 */
	public String toString() {
		return String.valueOf(valor);
	}

	/**
	 * Realiza a verificacao de tipos desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se os tipos da expressao s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao amb) {
		return true;
	}

	/**
	 * Retorna os tipos possiveis desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(AmbienteCompilacao amb) {
		return TipoPrimitivo.TIPO_BOOLEANO;
	}

	/**
	 * Retorna os tipos possiveis desta expressao. Inserido para possibilitar o
	 * uso do overload
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(Ambiente ambiente) {
		return TipoPrimitivo.TIPO_BOOLEANO;
	}
}