package plp.orientadaObjetos1.expressao.binaria;

import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.util.TipoPrimitivo;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorBooleano;

/**
 * Um objeto desta classe representa uma Disjuncao Logica.
 */
public class ExpOr extends ExpBinaria {

	/**
	 * Controi uma expressao de disjuncao logica com as sub-expressoes
	 * especificadas.Estas devem ser tais que sua avaliacao resulta em
	 * <code>ValorBooleano</code>
	 * 
	 * @param esq
	 *            expressao da esquerda
	 * @param dir
	 *            expressao da direita
	 */
	public ExpOr(Expressao esq, Expressao dir) {
		super(esq, dir, "or");
	}

	/**
	 * Retorna o valor da expressao de disjuncao logica
	 */
	public Valor avaliar(AmbienteExecucao ambiente) throws VariavelNaoDeclaradaException, VariavelJaDeclaradaException,
			ObjetoNaoDeclaradoException {
		return obterComparacaoOR(ambiente);
	}

	/**
	 * Realiza a verificacao de tipos desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se os tipos da expressao s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 * @exception VariavelNaoDeclaradaException
	 *                se existir um identificador nao declarado no ambiente.
	 * @exception VariavelNaoDeclaradaException
	 *                se existir um identificador declarado mais de uma vez no
	 *                mesmo bloco do ambiente.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseNaoDeclaradaException {
		boolean result;
		if (super.checaTipo(ambiente) && ((TipoPrimitivo) getEsq().getTipo(ambiente)).eBooleano()
				&& ((TipoPrimitivo) getDir().getTipo(ambiente)).eBooleano()) {
			result = true;
		} else {
			result = false;
		}
		return result;
	}

	/**
	 * Retorna os tipos possiveis desta expressao.
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return os tipos possiveis desta expressao.
	 */
	public Tipo getTipo(AmbienteCompilacao ambiente) {
		return TipoPrimitivo.TIPO_BOOLEANO;
	}

	/**
	 * Retorna o resultado de uma comparacao booleana OR
	 * 
	 * @param ambiente �
	 *            o Ambiente de Execu��o
	 * @return o resultado de uma comparacao booleana OR
	 */
	private ValorBooleano obterComparacaoOR(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ObjetoNaoDeclaradoException {
		return new ValorBooleano(((ValorBooleano) getEsq().avaliar(ambiente)).valor()
				|| ((ValorBooleano) getDir().avaliar(ambiente)).valor());
	}
}