package plp.orientadaObjetos1.declaracao.variavel;

import java.util.LinkedHashSet;

import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface;
import plp.interfaceclasseabstrata.declaracao.RelacaoClasseInterface.IdTipo;
import plp.interfaceclasseabstrata.memoria.DefClasseAbstrata;
import plp.orientadaObjetos1.comando.New;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.valor.ValorNull;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.util.TipoClasse;

/**
 * Classe que representa a declara�ao de uma vari�vel do tipo objeto.
 */
public class DecVariavelObjeto implements DecVariavel {
	/**
	 * Tipo da vari�vel declarado.
	 */
	private Tipo tipo;
	/**
	 * Identificador representando o objeto.
	 */
	private Id objeto;
	/**
	 * Idenficador representando a classe da qual objeto � uma inst�ncia.
	 */
	private Id classe;

	/**
	 * Construtor.
	 * 
	 * @param tipo
	 *            Tipo declarado da vari�vel.
	 * @param objeto
	 *            Identificador do objeto.
	 * @param classe
	 *            Classe da qual objeto � uma inst�ncia.
	 */
	public DecVariavelObjeto(Tipo tipo, Id objeto, Id classe) {
		this.tipo = tipo;
		this.objeto = objeto;
		this.classe = classe;
	}

	/**
	 * Retorna o tipo do identificador a ser declarado no AmbienteCompilacao
	 * 
	 * @param id
	 *            o identificador da declaracao
	 * @return o tipo do identificador
	 */
	public Tipo getTipo(Id id) throws VariavelNaoDeclaradaException {
		if (this.objeto.equals(id)) {
			return tipo;
		} else {
			throw new VariavelNaoDeclaradaException(id);
		}
	}

	/**
	 * Cria um mapeamento do identificador para o objeto no ambiente de
	 * execu��o.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pela inicializa��o da vari�vel.
	 */
	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException {
		AmbienteExecucao aux = new SimplesDecVariavel(tipo, objeto, new ValorNull()).elabora(ambiente);
		aux = new New(objeto, classe).executar(aux);
		return aux;
	}

	/**
	 * 
	 * Verifica se o tipo da classe associada � v�lido (se existe).
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre objetos e suas
	 *            classes.
	 * @return <code>true</code> a classe existe <code>false</code> caso
	 *         contrario.
	 * 
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException {
		boolean resposta = false;

		// checar se a classe eh concreta para poder ser instanciada
		DefClasse defClasse = ambiente.getDefClasse(classe);

		if (defClasse instanceof DefClasseAbstrata) {

			System.out.println("Erro:  Classe abstrata nao pode ser instanciada!");
			return false;
		}

		// checar se o tipo do objeto declarado eh o mesmo da classe a ser
		// instanciada, caso sim, faz-se o mapeamento no ambiente e retorna true
		TipoClasse tpClasse = new TipoClasse(classe);
		if (tpClasse.eValido(ambiente) && tipo.eValido(ambiente)) {
			if (tpClasse.equals(tipo)) {
				ambiente.mapTipo(objeto, tpClasse);
				resposta = true;
			}
		}
		// caso nao, checar se o tipo do objeto eh um super tipo do objeto a ser
		// instanciado, caso sim, faz-se o mapeamentono ambiente e retorna true
		if (!resposta) {

			LinkedHashSet<IdTipo> conj = RelacaoClasseInterface.getInstancia().getFechoSet(classe,
					RelacaoClasseInterface.CLASS);

			if (conj == null)
				return false;

			for (IdTipo idTipo : conj) {
				tpClasse = new TipoClasse(idTipo.getId());
				if (tpClasse.eValido(ambiente) && tipo.eValido(ambiente)) {
					if (tpClasse.equals(tipo)) {
						ambiente.mapTipo(objeto, tpClasse);
						return true;
					}
				}
			}
		}
		return resposta;
	}
}