package plp.orientadaObjetos1.declaracao.variavel;

import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.expressao.leftExpression.Id;

/**
 * Declara��o de vari�vel composta.
 */
public class CompostaDecVariavel implements DecVariavel {
	/**
	 * Primeira declara��o de vari�vel.
	 */
	private DecVariavel declaracao1;
	/**
	 * Restante da declara��o de vari�veis.
	 */
	private DecVariavel declaracao2;

	/**
	 * Construtor.
	 * 
	 * @param parametro1
	 *            Primeira declara�ao de vari�vel.
	 * @param parametro2
	 *            Restante da declara��o de vari�veis.
	 */
	public CompostaDecVariavel(DecVariavel declaracao1, DecVariavel declaracao2) {
		this.declaracao1 = declaracao1;
		this.declaracao2 = declaracao2;
	}

	/**
	 * Obt�m o tipo de uma vari�vel nessa declara��o.
	 * 
	 * @param id
	 *            O identificador da vari�vel.
	 * @return o tipo deste identificador nessa declara�ao.
	 * @throws VariavelNaoDeclaradaException
	 *             Quando nao h� nenhuma vari�vel declarada com esse id na
	 *             declara��o.
	 */
	public Tipo getTipo(Id id) throws VariavelNaoDeclaradaException {
		Tipo tipo = null;
		try {
			if (declaracao1 != null)

				tipo = declaracao1.getTipo(id);
		} catch (VariavelNaoDeclaradaException e) {
			if (declaracao2 != null)
				tipo = declaracao2.getTipo(id);
		}
		if (declaracao1 == null) {
			if (declaracao2 != null)
				tipo = declaracao2.getTipo(id);
		}
		return tipo;

	}

	/**
	 * Cria um mapeamento dos identificadores para os valores das express�es
	 * desta declara��o composta no AmbienteExecucao
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pelas inicializa��es das vari�veis.
	 */
	public AmbienteExecucao elabora(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ObjetoNaoDeclaradoException, ObjetoJaDeclaradoException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException {

		AmbienteExecucao ambienteAux = ambiente;
		// checar se a declaracao eh nula
		// mudanca necessaria pois uma classe agora pode nao conter declaracao
		// de variavel
		if (declaracao1 != null) {
			ambienteAux = declaracao1.elabora(ambiente);
		}
		if (declaracao2 != null) {
			ambienteAux = declaracao2.elabora(ambiente);
		}

		return ambienteAux;
		// return declaracao2.elabora(declaracao1.elabora(ambiente));
	}

	/**
	 * Verifica se as declara��es est�o bem tipadas, ou seja, se as express�es
	 * de inicializa��o est�o bem tipadas.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declara��o s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ClasseNaoDeclaradaException, ClasseJaDeclaradaException {
		boolean resposta1 = true, resposta2 = true;
		// checar se a declaracao eh nula
		// mudanca necessaria pois uma classe agora pode nao conter declaracao
		// de variavel
		if (declaracao1 != null) {
			resposta1 = declaracao1.checaTipo(ambiente);
		}
		if (declaracao2 != null) {
			resposta2 = declaracao2.checaTipo(ambiente);
		}

		return (resposta1 && resposta2);

		// return declaracao1.checaTipo(ambiente) &&
		// declaracao2.checaTipo(ambiente);
	}
}
