/* Arquivo DecProcedimentoSimples.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.declaracao.procedimento;

import java.util.Stack;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.comando.Comando;
import plp.orientadaObjetos1.comando.Procedimento;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.util.ListaTipo;

/**
 * Representa uma declara��o de procedimento simples.
 */
public class DecProcedimentoSimples implements DecProcedimento {
	/**
	 * Identificador do procedimento.
	 */
	private Id nome;
	/**
	 * Par�metros do procedimento.
	 */
	private ListaDeclaracaoParametro parametrosFormais;
	/**
	 * Comando, que pode ser simples ou composto, executado pelo procedimento.
	 */
	private Comando comando;

	/**
	 * Construtor.
	 * 
	 * @param nome
	 *            Nome do procedimento.
	 * @param parametrosFormais
	 *            Par�metros do procedimento.
	 * @param comando
	 *            Comando(s) executado(s) pelo procedimento.
	 */
	public DecProcedimentoSimples(Id nome, ListaDeclaracaoParametro parametrosFormais, Comando comando) {
		this.nome = nome;
		this.parametrosFormais = parametrosFormais;
		this.comando = comando;
	}

	/**
	 * Obt�m o procedimento representado por nome.
	 * 
	 * @param nome
	 *            O nome do procedimento procurado.
	 * @return o procedimento identificado por nome.
	 * @throws ProcedimentoNaoDeclaradoException
	 *             quando n�o existe nenhum procedimento declarado com esse
	 *             nome.
	 */
	/*
	 * public Procedimento getProcedimento(Id nome) throws
	 * ProcedimentoNaoDeclaradoException { if(this.nome.equals(nome)){ return
	 * new Procedimento(parametrosFormais, comando); } else { throw new
	 * ProcedimentoNaoDeclaradoException(nome); } }
	 */
	public Procedimento getProcedimento(Id nome, ListaTipo lt) throws ProcedimentoNaoDeclaradoException {
		if (this.nome.equals(nome) && (lt.length() == parametrosFormais.length())) {
			ListaDeclaracaoParametro l = parametrosFormais;
			Stack<DecParametro> pilhaParam = new Stack<DecParametro>();
			while ((l != null) && (l.getHead() != null)) {
				pilhaParam.push(l.getHead());
				l = (ListaDeclaracaoParametro) l.getTail();
			}
			while (!pilhaParam.isEmpty()) {
				DecParametro dp = pilhaParam.pop();
				if (!dp.getTipo().equals(lt.head())) {
					throw new ProcedimentoNaoDeclaradoException(nome);
				}
				lt = lt.tail();
			}

			return new Procedimento(parametrosFormais, comando);
		} else {
			throw new ProcedimentoNaoDeclaradoException(nome);
		}
	}

	/**
	 * Verifica se a declara��o est� bem tipada, ou seja, se os comandos est�o
	 * bem tipados.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos dos comandos s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException,
			ClasseNaoDeclaradaException, ClasseJaDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		boolean resposta;
		if (parametrosFormais.checaTipo(ambiente)) {
			ambiente.mapParametrosProcedimento(nome, parametrosFormais);
			ambiente.incrementa();
			ambiente = parametrosFormais.declaraParametro(ambiente);
			// alteracao para passar o checa tipo de metodos abstratos
			if (comando != null)
				resposta = comando.checaTipo(ambiente);
			else
				resposta = true;
			// fim codigo alteracao
			ambiente.restaura();
		} else {
			resposta = false;
		}
		return resposta;
	}

	public Comando getComando() {
		return comando;
	}

	public Id getNome() {
		return nome;
	}

	public ListaDeclaracaoParametro getParametrosFormais() {
		return parametrosFormais;
	}

}
