/* Arquivo DecProcedimentoComposta.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.declaracao.procedimento;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.comando.Procedimento;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.util.ListaTipo;

/**
 * Classe que representa mais de uma declara��o de procedimento.
 */
public class DecProcedimentoComposta implements DecProcedimento {
	/**
	 * Primeira Declara��o de procedimento.
	 */
	private DecProcedimento declaracao1;
	/**
	 * Restante da declara��o de procedimento composta.
	 */
	private DecProcedimento declaracao2;

	/**
	 * Construtor
	 * 
	 * @param parametro1
	 *            Primeira Declara��o de procedimento.
	 * @param parametro2
	 *            Restante da declara��o de procedimento composta.
	 */
	public DecProcedimentoComposta(DecProcedimento declaracao1, DecProcedimento declaracao2) {
		this.declaracao1 = declaracao1;
		this.declaracao2 = declaracao2;
	}

	/**
	 * Obt�m o procedimento Obt�m o procedimento identificado por id.
	 * 
	 * @param id
	 *            O identificador do procedimento.
	 * @return o procedimento Obt�m o procedimento identificado por id.
	 * @throws ProcedimentoNaoDeclaradoException
	 *             se n�o houver nenhum procedimento identificado por id.
	 */
	/*
	 * public Procedimento getProcedimento(Id id) throws
	 * ProcedimentoNaoDeclaradoException { Procedimento procedimento = null; try {
	 * if(declaracao1 != null) procedimento = declaracao1.getProcedimento(id); }
	 * catch(ProcedimentoNaoDeclaradoException e) {
	 * 
	 * if(declaracao2 != null) procedimento = declaracao2.getProcedimento(id); }
	 * return procedimento; }
	 */

	public Procedimento getProcedimento(Id id, ListaTipo lt) throws ProcedimentoNaoDeclaradoException {
		Procedimento procedimento = null;
		try {
			if (declaracao1 != null)
				procedimento = declaracao1.getProcedimento(id, lt);
		} catch (ProcedimentoNaoDeclaradoException e) {

			if (declaracao2 != null)
				procedimento = declaracao2.getProcedimento(id, lt);
		}
		return procedimento;
	}

	/**
	 * Verifica se a declara��o est� bem tipada, ou seja, se a express�o de
	 * inicializa��o est� bem tipada.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declara��o s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException,
			ClasseNaoDeclaradaException, ClasseJaDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		return declaracao1.checaTipo(ambiente) && declaracao2.checaTipo(ambiente);
	}

	public DecProcedimento getDeclaracao1() {
		return declaracao1;
	}

	public DecProcedimento getDeclaracao2() {
		return declaracao2;
	}
}
