/* Arquivo DecProcedimento.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.declaracao.procedimento;

import plp.interfaceclasseabstrata.declaracao.CorpoClasse;
import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.util.ListaTipo;
import plp.orientadaObjetos1.comando.Procedimento;

import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;

/**
 * Interface que representa uma declara��o de Procedimento.
 */
public interface DecProcedimento extends CorpoClasse {

	/**
	 * Retorna o procedimento a ser declarado na Declara��o da Classe
	 * 
	 * @param id
	 *            o identificador da declaracao de procedimento
	 * @return o procedimento da declara��o
	 */
	/*
	 * public Procedimento getProcedimento(Id nomeProcedimento) throws
	 * ProcedimentoNaoDeclaradoException;
	 */
	public Procedimento getProcedimento(Id nomeProcedimento, ListaTipo lista) throws ProcedimentoNaoDeclaradoException;

	/**
	 * Verifica se a declara��o est� bem tipada, ou seja, se a express�o de
	 * inicializa��o est� bem tipada.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            seus tipos.
	 * @return <code>true</code> se os tipos da declara��o s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoJaDeclaradoException, ProcedimentoNaoDeclaradoException,
			ClasseNaoDeclaradaException, ClasseJaDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException;
}
