/* Arquivo Sequencial.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.comando;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.comando.Comando;

/**
 * Representa um comando sequencial, ou seja, um comando seguido de outro
 * comando.
 */
public class Sequencial implements Comando {
	/**
	 * O primeiro comando.
	 */
	private Comando comando1;
	/**
	 * O segundo comando.
	 */
	private Comando comando2;

	/**
	 * Construtor.
	 * 
	 * @param comando1
	 *            O primeiro comando
	 * @param comando2
	 *            O segundo comando.
	 */
	public Sequencial(Comando comando1, Comando comando2) {
		this.comando1 = comando1;
		this.comando2 = comando2;
	}

	/**
	 * Executa os comandos sequencialmente.
	 * 
	 * @param ambiente
	 *            o ambiente de execu��o.
	 * @return o ambiente depois de modificado pela execu��o dos comandos.
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException, ClasseJaDeclaradaException,
			ClasseNaoDeclaradaException, InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
			AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException, EntradaInvalidaException {

		ambiente = comando1.executar(ambiente);
		ambiente = comando2.executar(ambiente);
		return ambiente;
	}

	/**
	 * Realiza a verificacao de tipos dos comandos
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se os comandos s�o bem tipados;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException, InterfaceJaDeclaradaException,
			InterfaceNaoDeclaradaException, AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException {
		boolean resposta1 = comando1.checaTipo(ambiente);
		boolean resposta2 = comando2.checaTipo(ambiente);
		return resposta1 && resposta2;
	}
}
