package plp.orientadaObjetos1.comando;

import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.util.Tipo;

/**
 * Representa um comando de leitura.
 */
public class Read implements IO {
	/**
	 * O identificador ao qual ser� atribu�do o valor lido.
	 */
	private Id id;
	/**
	 * O tipo do identificador cujo novo valor ser� lido.
	 */
	private Tipo tipoId;

	/**
	 * Construtor.
	 * 
	 * @param id
	 *            O identificador ao qual ser� a atribu�do o valor lido.
	 */
	public Read(Id id) {
		this.id = id;
	}

	/**
	 * L� da entrada padr�o.
	 * 
	 * @param ambiente
	 *            o ambiente de execu��o.
	 * @return o ambiente depois de modificado pela execu��o do comando read.
	 * 
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, EntradaInvalidaException {
		ambiente.changeValor(id, ambiente.read(this.tipoId));
		return ambiente;
	}

	/**
	 * Realiza a verificacao de tipos da entrada
	 * 
	 * @param ambiente
	 *            o ambiente de compila��o.
	 * @return <code>true</code> se a express�o da entrada est� bem tipada;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException {
		// Alteramos a implementa��o, pois em tempo de compila��o n�o se pode
		// saber
		// o tipo da entrada que ser� lida.

		// Tipo tipo = ambiente.getTipoEntrada();
		// Tipo tipo2 = id.getTipo(ambiente);

		this.tipoId = id.getTipo(ambiente);
		return id.checaTipo(ambiente);

		// return id.getTipo(ambiente).equals(ambiente.getTipoEntrada());
	}

}
