/*
 * New.java
 *
 * Historico de mudancas necessaria a implementacao de LOO2
 *
 * a) Implementacao dos metodos publicos para recuperar av e
 *    classe.
 *
 * b) Adiciona no ambiente as vari�veis da superclasse, colocando no fundo
 *    da pilha.
 */
package plp.orientadaObjetos1.comando;

import java.util.HashMap;
import java.util.Stack;

import plp.interfaceclasseabstrata.memoria.DefClasseAbstrata;
import plp.orientadaObjetos1.memoria.ContextoExecucao;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.DefClasse;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.declaracao.variavel.DecVariavel;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.leftExpression.LeftExpression;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.util.TipoClasse;
import plp.orientadaObjetos2.memoria.AmbienteExecucaoOO2;

/**
 * Comando de cria��o de objeto e atribui��o deste a uma express�o esquerda.
 */
public class New implements Comando {

	/**
	 * Lado esquerdo da atribui��o.
	 */

	private LeftExpression av;

	/**
	 * Identificador da classe, com o seu nome.
	 */
	private Id classe;

	/**
	 * Construtor.
	 * 
	 * @param av
	 *            Lado esquerdo da atribui��o.
	 * @param classe
	 *            Identificador com o nome da classe.
	 */
	public New(LeftExpression av, Id classe) {
		this.av = av;
		this.classe = classe;
	}

	/**
	 * Execu��o da atribui��o de um novo objeto criado a uma left expression.
	 * 
	 * @param ambiente
	 *            O ambiente contendo o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente de execu��o atualizado.
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ClasseJaDeclaradaException, ClasseNaoDeclaradaException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException {

		DefClasse defClasse = ambiente.getDefClasse(classe);
		DecVariavel decVariavel = defClasse.getDecVariavel();

		AmbienteExecucao aux = ambiente;

		try {
			DefClasse defSuperClasse = ((AmbienteExecucaoOO2) ambiente).getSuperClasse(classe);

			DecVariavel atributosHerdados = defSuperClasse.getDecVariavel();

			HashMap<Id, Valor> mapVarSuper = atributosHerdados.elabora(ambiente).getPilha().peek();
			// uma classe pode nao ter atributos
			// mudanca interfaceClasseAbstrata
			if (decVariavel != null)
				aux = decVariavel.elabora(new ContextoExecucao(ambiente));

			Stack<HashMap<Id, Valor>> stack = new Stack<HashMap<Id, Valor>>();
			HashMap<Id, Valor> auxMapVarSuper;
			while (!aux.getPilha().isEmpty()) {
				auxMapVarSuper = aux.getPilha().pop();

				stack.push(auxMapVarSuper);
			}

			aux.getPilha().push(mapVarSuper);

			while (!stack.isEmpty()) {
				auxMapVarSuper = stack.pop();

				aux.getPilha().push(auxMapVarSuper);
			}
			// } else {
			// ambiente.getRef();
			// }
		} catch (Exception e) {
			if (decVariavel != null)
				aux = decVariavel.elabora(new ContextoExecucao(ambiente));
		}
		if (decVariavel == null)
			ambiente.getRef();

		Objeto objeto;
		if (aux != null)
			objeto = new Objeto(classe, aux.getContextoIdValor());
		else
			objeto = new Objeto(classe, ambiente);
		ValorRef vr = ambiente.getProxRef();
		ambiente.mapObjeto(vr, objeto);
		ambiente = new Atribuicao(av, vr).executar(ambiente);

		return ambiente;
	}

	/**
	 * Verifica se a atribui��o � poss�vel comparando os tipos do objeto e da
	 * left expression.
	 * 
	 * @param ambiente
	 *            O ambiente de compila��o, com o mapeamento entre
	 *            identificadores e tipos.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseJaDeclaradaException, ClasseNaoDeclaradaException {

		// preciso verificar que a classe nao eh abstrata
		DefClasse defClasse = ambiente.getDefClasse(classe);
		if (defClasse instanceof DefClasseAbstrata) {

			System.out.println("Erro: Classe abstrata nao pode ser instanciada!");
			return false;
		}

		TipoClasse tpClasse = new TipoClasse(classe);

		return av.checaTipo(ambiente) && tpClasse.eValido(ambiente) && tpClasse.equals(av.getTipo(ambiente));
	}

	public LeftExpression getAv() {
		return av;
	}

	public Id getClasse() {
		return classe;
	}
}