/* Arquivo ChamadaProcedimento.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.comando;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.declaracao.procedimento.ListaDeclaracaoParametro;
import plp.orientadaObjetos1.excecao.declaracao.ClasseJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoJaDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.ProcedimentoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.expressao.ListaExpressao;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos1.util.ListaTipo;

/**
 * Classe que representa uma chamada de um procedimento.
 */
public class ChamadaProcedimento implements Comando {

	/**
	 * � o procedimento
	 */
	private Procedimento procedimento;

	/**
	 * S�o os parametros do procedimento
	 */
	private ListaExpressao parametrosReais;

	/**
	 * Valores que serao atribu�dos aos parametros reais
	 */
	private ListaValor valoresParametros;

	/**
	 * Contrutor Default.
	 * 
	 * @param procedimento �
	 *            o procedimento
	 * @param parametrosReais
	 *            sao os par�metros do procedimento
	 * @param valoresParametros
	 *            sao os valores dos parametros
	 */
	public ChamadaProcedimento(Procedimento procedimento, ListaExpressao parametrosReais, ListaValor valoresParametros) {
		this.procedimento = procedimento;
		this.parametrosReais = parametrosReais;
		this.valoresParametros = valoresParametros;
	}

	/**
	 * Contrutor Default.
	 * 
	 * @param procedimento �
	 *            o procedimento
	 * @param parametrosReais
	 *            sao os par�metros do procedimento
	 */
	public ChamadaProcedimento(Procedimento procedimento, ListaExpressao parametrosReais) {
		this.procedimento = procedimento;
		this.parametrosReais = parametrosReais;
		this.valoresParametros = null;
	}

	/**
	 * Executa este comando.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pela execu��o do comando.
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ObjetoNaoDeclaradoException, ObjetoJaDeclaradoException, ClasseNaoDeclaradaException,
			ClasseJaDeclaradaException, InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
			AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException, EntradaInvalidaException {

		ambiente.incrementa();
		ambiente = bindParameters(ambiente, procedimento.getParametrosFormais());
		ambiente = procedimento.getComando().executar(ambiente);
		ambiente.restaura();
		return ambiente;
	}

	/**
	 * insere no contexto o resultado da associacao entre cada parametro formal
	 * e seu correspondente parametro atual
	 */
	private AmbienteExecucao bindParameters(AmbienteExecucao ambiente, ListaDeclaracaoParametro parametrosFormais)
			throws VariavelJaDeclaradaException, VariavelNaoDeclaradaException, ObjetoNaoDeclaradoException {
		ListaValor listaValor = this.valoresParametros;
		if (listaValor == null) {
			listaValor = parametrosReais.avaliar(ambiente);
		}
		while (listaValor.length() > 0) {
			ambiente.mapValor(parametrosFormais.getHead().getId(), listaValor.getHead());
			parametrosFormais = ((ListaDeclaracaoParametro) parametrosFormais.getTail());
			listaValor = (ListaValor) listaValor.getTail();
		}
		return ambiente;
	}

	/**
	 * Realiza a verificacao de tipos desta chamada de procedimento, onde os
	 * tipos dos parametros formais devem ser iguais aos tipos dos parametros
	 * reais na ordem em que se apresentam.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            tipos.
	 * 
	 * @return <code>true</code> se a chamada de procedimeno est� bem tipada;
	 *         <code>false</code> caso contrario.
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ProcedimentoNaoDeclaradoException, ClasseNaoDeclaradaException {
		boolean resposta;
		ambiente.incrementa();
		ListaDeclaracaoParametro parametrosFormais = procedimento.getParametrosFormais();
		ListaTipo listaTipo = parametrosReais.getTipos(ambiente);
		// tem o mesmo numero de parametros formais e reais?
		if (listaTipo.length() == parametrosFormais.length()) {
			// a funcao tem algum parametro?
			if (listaTipo.head() == null || parametrosFormais.getHead() == null) {
				resposta = true;
			} else {
				resposta = true;
				// tem parametros formais de tipos diferentes
				// de parametros reais na ordem em que se apresentam?
				while (listaTipo != null && parametrosFormais != null) {
					if (!listaTipo.head().equals(parametrosFormais.getHead().getTipo())) {
						resposta = false;
						break;
					}
					listaTipo = listaTipo.tail();
					parametrosFormais = ((ListaDeclaracaoParametro) parametrosFormais.getTail());
				}
			}
		} else {
			resposta = false;
		}
		ambiente.restaura();
		return resposta;
	}
}