/* Arquivo ChamadaMetodo.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 13/04/08: Adicionado tratamento de exceções de assinaturas e interfaces
 */

package plp.orientadaObjetos1.comando;

import java.util.Stack;

import plp.interfaceclasseabstrata.excecoes.AssinaturaJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.memoria.*;
import plp.orientadaObjetos1.util.ListaTipo;
import plp.orientadaObjetos1.util.Tipo;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.ListaExpressao;
import plp.orientadaObjetos1.excecao.declaracao.*;
import plp.orientadaObjetos1.excecao.execucao.EntradaInvalidaException;
import plp.orientadaObjetos1.expressao.valor.Valor;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;

/**
 * Classe que representa a chamada de um m�todo.
 */
public class ChamadaMetodo implements Comando {
	/**
	 * A express�o que chama o m�todo.
	 */
	protected Expressao expressao;
	/**
	 * O identificador que representa o nome do m�todo.
	 */
	protected Id nomeMetodo;
	/**
	 * Par�metros passados para o m�todo.
	 */
	protected ListaExpressao parametrosReais;

	/**
	 * Construtor.
	 * 
	 * @param expressao
	 *            A expressao chamadora do m�todo.
	 * @param nomeMetodo
	 *            O nome do m�todo.
	 * @param parametrosReais
	 *            Os par�metros passados para a execu��o do m�todo.
	 * @param
	 */
	public ChamadaMetodo(Expressao expressao, Id nomeMetodo, ListaExpressao parametrosReais) {
		this.expressao = expressao;
		this.nomeMetodo = nomeMetodo;
		this.parametrosReais = parametrosReais;
	}

	/**
	 * Executa uma chamada de m�todo.
	 * 
	 * @param ambiente
	 *            O ambiente de execu��o, que guarda o mapeamento de
	 *            identificadores a valores.
	 * @return o Ambiente de Execu��o atualizado.
	 */
	/*
	 * public AmbienteExecucao executar(AmbienteExecucao ambiente) throws
	 * VariavelJaDeclaradaException, VariavelNaoDeclaradaException,
	 * ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
	 * ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException,
	 * ClasseNaoDeclaradaException, ClasseJaDeclaradaException,
	 * InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
	 * AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException,
	 * EntradaInvalidaException{
	 * 
	 * ValorRef vr = (ValorRef) expressao.avaliar(ambiente); // recupera o id do
	 * objeto Objeto objeto = ambiente.getObjeto(vr); // recupera o objeto Id
	 * idClasse = objeto.getClasse(); // recupera o tipo do objeto DefClasse
	 * defClasse = ambiente.getDefClasse(idClasse); // recupera a defini��o da
	 * classe Procedimento metodo = defClasse.getMetodo(nomeMetodo); // recupera
	 * o procedimento // cria um novo ambiente para a execucao, pois // n�o deve
	 * levar em conta as vari�veis definidas na main AmbienteExecucao aux = new
	 * ContextoExecucao(ambiente); // � change pois no construtor do ambiente
	 * aux.changeValor(new Id("this"),vr); // invocado na linha anterior ja �
	 * feito // um mapeamento
	 * 
	 * ListaValor valoresDosParametros = parametrosReais.avaliar(ambiente); new
	 * ChamadaProcedimento(metodo, parametrosReais,
	 * valoresDosParametros).executar(aux); return ambiente; }
	 */

	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ProcedimentoNaoDeclaradoException, ProcedimentoJaDeclaradoException,
			ObjetoJaDeclaradoException, ObjetoNaoDeclaradoException, ClasseNaoDeclaradaException,
			ClasseJaDeclaradaException, InterfaceJaDeclaradaException, InterfaceNaoDeclaradaException,
			AssinaturaJaDeclaradaException, AssinaturaNaoDeclaradaException, EntradaInvalidaException {

		ValorRef vr = (ValorRef) expressao.avaliar(ambiente); // recupera o id
		// do objeto
		Objeto objeto = ambiente.getObjeto(vr); // recupera o objeto
		Id idClasse = objeto.getClasse(); // recupera o tipo do objeto
		DefClasse defClasse = ambiente.getDefClasse(idClasse); // recupera a
		// defini��o da
		// classe

		ListaValor valoresDosParametros = parametrosReais.avaliar(ambiente);
		Procedimento metodo = defClasse.getMetodo(nomeMetodo, getTipos(ambiente, valoresDosParametros)); // recupera
																											// o
																											// procedimento
		// cria um novo ambiente para a execucao, pois
		// n�o deve levar em conta as vari�veis definidas na main
		AmbienteExecucao aux = new ContextoExecucao(ambiente);
		// � change pois no construtor do ambiente
		aux.changeValor(new Id("this"), vr); // invocado na linha anterior ja
		// � feito
		// um mapeamento
		new ChamadaProcedimento(metodo, parametrosReais, valoresDosParametros).executar(aux);
		return ambiente;
	}

	/**
	 * Realiza a verifica��o de tipos desta chamada de m�todo, onde o tipo do
	 * m�todo deve estar na defini��o da classe obtida a partir de express�o.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            tipos.
	 * @return <code>true</code> se a chamada de m�todo est� bem tipada;
	 *         <code>false</code> caso contrario.
	 */
	/*
	 * public boolean checaTipo(AmbienteCompilacao ambiente) throws
	 * VariavelNaoDeclaradaException, VariavelJaDeclaradaException,
	 * ClasseNaoDeclaradaException { boolean resposta; //Antes de incrementar o
	 * ambiente, verifico se o m�todo //� v�lido para a definicao de classe
	 * obtida a partir de expressao. //Se n�o for v�lido, a exce��o
	 * ProcedimentoNaoDeclaradoException ser� //lan�ada e checaTipo retornar�
	 * false. Tipo tipoClasse = expressao.getTipo(ambiente); DefClasse defClasse =
	 * ambiente.getDefClasse(tipoClasse.getTipo()); try{ Procedimento metodo =
	 * defClasse.getMetodo(nomeMetodo); ambiente.incrementa();
	 * ambiente.mapTipo(new Id("this"),tipoClasse); resposta = new
	 * ChamadaProcedimento(metodo, parametrosReais).checaTipo(ambiente);
	 * ambiente.restaura(); } catch(ProcedimentoNaoDeclaradoException e){
	 * resposta = false; } return resposta; }
	 */

	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			VariavelJaDeclaradaException, ClasseNaoDeclaradaException {
		boolean resposta;
		// Antes de incrementar o ambiente, verifico se o m�todo
		// � v�lido para a definicao de classe obtida a partir de expressao.
		// Se n�o for v�lido, a exce��o ProcedimentoNaoDeclaradoException ser�
		// lan�ada e checaTipo retornar� false.
		Tipo tipoClasse = expressao.getTipo(ambiente);
		DefClasse defClasse = ambiente.getDefClasse(tipoClasse.getTipo());
		try {
			Procedimento metodo = defClasse.getMetodo(nomeMetodo, parametrosReais.getTipos(ambiente));
			ambiente.incrementa();
			ambiente.mapTipo(new Id("this"), tipoClasse);
			resposta = new ChamadaProcedimento(metodo, parametrosReais).checaTipo(ambiente);
			ambiente.restaura();
		} catch (ProcedimentoNaoDeclaradoException e) {
			resposta = false;
		}
		return resposta;
	}

	// Método inserido para uso do overload

	public static ListaTipo getTipos(Ambiente ambiente, ListaValor valoresDosParametros) {
		ListaValor l = valoresDosParametros;
		Stack<Valor> pilhaValor = new Stack<Valor>();
		while ((l != null) && (l.getHead() != null)) {
			pilhaValor.push(l.getHead());
			l = (ListaValor) l.getTail();
		}
		ListaTipo lt = new ListaTipo();
		while (!pilhaValor.isEmpty()) {
			Valor v = pilhaValor.pop();
			lt = new ListaTipo(v.getTipo(ambiente), lt);
		}
		return lt;
	}
}
