/*
 * Atribuicao.java
 * 
 * Historico de mudancas necessaria a implementacao de LOO2
 * 
 * a) Implementacao dos metodos publicos para recuperar av e 
 *    expressao.  
 *
 */

package plp.orientadaObjetos1.comando;

import plp.orientadaObjetos1.memoria.AmbienteCompilacao;
import plp.orientadaObjetos1.memoria.AmbienteExecucao;
import plp.orientadaObjetos1.memoria.Objeto;
import plp.orientadaObjetos1.excecao.declaracao.ClasseNaoDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.ObjetoNaoDeclaradoException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelJaDeclaradaException;
import plp.orientadaObjetos1.excecao.declaracao.VariavelNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.Expressao;
import plp.orientadaObjetos1.expressao.leftExpression.AcessoAtributo;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.expressao.leftExpression.LeftExpression;
import plp.orientadaObjetos1.expressao.valor.ValorRef;
import plp.orientadaObjetos1.util.TipoClasse;

/**
 * Classe que representa um comando de atribui��o.
 */
public class Atribuicao implements Comando {
	/**
	 * Lado esquerdo do comando de atribui��o.
	 */
	private LeftExpression av;
	/**
	 * Express�o cujo valor ser� atribu�do ao lado esquerdo.
	 */
	private Expressao expressao;

	/**
	 * Construtor.
	 * 
	 * @param av
	 *            Lado esquerdo
	 * @param expressao
	 *            Express�o cujo valor ser� atribu�do ao lado esquerdo.
	 */
	public Atribuicao(LeftExpression av, Expressao expressao) {
		this.av = av;
		this.expressao = expressao;
	}

	/**
	 * Executa a atribui��o.
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return o ambiente modificado pela execu��o da atribui��o.
	 * 
	 */
	public AmbienteExecucao executar(AmbienteExecucao ambiente) throws VariavelJaDeclaradaException,
			VariavelNaoDeclaradaException, ObjetoNaoDeclaradoException {

		Id idVariavel = av.getId();
		if (av instanceof AcessoAtributo) {
			// se for acesso a atributo, tem de alterar o ambiente do objeto!
			Expressao expAV = ((AcessoAtributo) av).getExpressaoObjeto();
			ValorRef referencia = (ValorRef) expAV.avaliar(ambiente);
			Objeto obj = ambiente.getObjeto(referencia);
			AmbienteExecucao aux = obj.getEstado(); // recuperando o ambiente do
													// objeto
			aux.changeValor(idVariavel, expressao.avaliar(ambiente)); // alterando
																		// o
																		// ambiente
																		// do
																		// objeto
		} else
			ambiente.changeValor(idVariavel, expressao.avaliar(ambiente));
		return ambiente;
	}

	/**
	 * Um comando de atribui��o est� bem tipado, se o tipo do identificador � o
	 * mesmo da express�o. O tipo de um identificador � determinado pelo tipo da
	 * express�o que o inicializou (na declara��o).
	 * 
	 * @param ambiente
	 *            o ambiente que contem o mapeamento entre identificadores e
	 *            valores.
	 * @return <code>true</code> se os tipos da atribui��o s�o v�lidos;
	 *         <code>false</code> caso contrario.
	 * 
	 */
	public boolean checaTipo(AmbienteCompilacao ambiente) throws VariavelNaoDeclaradaException,
			ClasseNaoDeclaradaException {

		return expressao.checaTipo(ambiente)
				&& (av.getTipo(ambiente).equals(expressao.getTipo(ambiente)) || expressao.getTipo(ambiente).equals(
						TipoClasse.TIPO_NULL));
	}

	public LeftExpression getAv() {
		return av;
	}

	public Expressao getExpressao() {
		return expressao;
	}

}