/* Generated By:JavaCC: Do not edit this line. InterfaceClasseAbstrataParser.java */
package plp.interfaceclasseabstrata.parser;
import plp.imperative1.util.Lista;
import plp.orientadaObjetos1.util.*;
import plp.orientadaObjetos1.expressao.*;
import plp.orientadaObjetos1.expressao.leftExpression.*;
import plp.orientadaObjetos1.expressao.binaria.*;
import plp.orientadaObjetos1.expressao.unaria.*;
import plp.orientadaObjetos1.expressao.valor.*;
import plp.orientadaObjetos1.comando.*;
import plp.orientadaObjetos1.declaracao.variavel.*;
import plp.orientadaObjetos1.declaracao.procedimento.*;
import plp.orientadaObjetos1.memoria.colecao.*;
import plp.orientadaObjetos2.comando.*;
import plp.orientadaObjetos2.expressao.*;
import plp.orientadaObjetos2.expressao.binaria.*;
import plp.orientadaObjetos2.expressao.leftExpression.*;
import plp.orientadaObjetos2.declaracao.procedimento.*;
import plp.orientadaObjetos2.comando.ChamadaMetodoOO2;
import plp.orientadaObjetos2.comando.AtribuicaoOO2;
import plp.interfaceclasseabstrata.*;
import plp.interfaceclasseabstrata.declaracao.*;

import plp.interfaceclasseabstrata.declaracao.interfaces.*;
import plp.interfaceclasseabstrata.assinatura.*;
import plp.interfaceclasseabstrata.declaracao.classes.*;
import plp.interfaceclasseabstrata.memoria.*;

import plp.interfaceclasseabstrata.declaracao.CorpoClasse;
import plp.interfaceclasseabstrata.declaracao.ListaCorpoClasse;

import plp.interfaceclasseabstrata.declaracao.procedimentos.DecProcedimentoAbstrato;
import plp.interfaceclasseabstrata.declaracao.procedimentos.DecProcedimentoConcreto;



import java.util.List;
/**
 * Parser para a Linguagem de Programa��o Orientada a Objetos
 */
public class InterfaceClasseAbstrataParser implements InterfaceClasseAbstrataParserConstants {
  /**
     * M�todo principal que executa um dado programa que pode ser fornecido
     * atrav�s da entrada padr�o ou em um arquivo cujo nome entra como par�metro
     * para esse m�todo.
     * @param args Argumentos para o m�todo.
     */
public static void main(String args[]){
    InterfaceClasseAbstrataParser parser = null;
    if (args.length == 0){
      System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Reading from standard input . . .");
      parser = new InterfaceClasseAbstrataParser(System.in);
    }
    else if (args.length == 1){
      System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Reading from file "+args[0]+" . . .");
      try {
        parser = new InterfaceClasseAbstrataParser(new java.io.FileInputStream(args[0]));
      }
      catch (java.io.FileNotFoundException e){
        System.out.println("Java Parser Version 1.0.2:  File "+args[0]+" not found.");
        return ;
      }
    }
    else {
      System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Usage is one of:");
      System.out.println("         java InterfaceClasseAbstrata < inputfile");
      System.out.println("OR");
      System.out.println("         java InterfaceClasseAbstrata inputfile");
      return ;
    }
    try {
      Programa programa = parser.processaEntrada();
      System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Interface Classe Abstrata program parsed successfully.");
      try {
              if (programa.checaTipo(new ContextoCompilacaoICABS(new ListaValor()))){
                try {
                  programa.executar(new ContextoExecucaoICABS());
                }
                catch (Exception e){
                  System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Encountered errors during execution.");
                  System.out.println(e.getMessage());
                  e.printStackTrace();
                }
              }
              else {
                  System.out.println("Erro de tipo");
          }
      } catch (Exception e) {
          System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Encountered errors during type checking.");
          System.out.println(e.getMessage());
          e.printStackTrace();
      }
    }
    catch (Exception e){
      System.out.println("Interface Classe Abstrata PLP Parser Version 0.0.1:  Encountered errors during parse.");
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
  }
  public static ListaValor criaListaValor(List valores){
    if (valores.size() == 0){
      return new ListaValor();
    }
    Valor primeiro = (Valor)valores.get(0);
    valores.remove(0);
    return new ListaValor(primeiro, criaListaValor(valores));
  }

/**
 * M�todo chamado com o intuito de processar a entrada fornecida ao parser gerando
 * objeto do tipo Programa.
 **/
  final public Programa processaEntrada() throws ParseException {
  Programa retorno;
    retorno = PPrograma();
    jj_consume_token(0);
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/*
 * A partir de agora, serão expostos através desse tipo de comentário
 * as partes da BNF envolvidas no codigo mostrado em seguida.
 */
/**
 * Programa ::= "{" [ Declaração ";" ] Comando "}"
 **/
  final public Programa PPrograma() throws ParseException {
  plp.interfaceclasseabstrata.declaracao.Declaracao declaracoes = null;
  Comando comando = null;
    if (jj_2_1(2147483647)) {
      jj_consume_token(LBRACE);
      declaracoes = PDeclaracoes();
      jj_consume_token(SEMICOLON);
      comando = PComando();
      jj_consume_token(RBRACE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        jj_consume_token(LBRACE);
        comando = PComando();
        jj_consume_token(RBRACE);
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return new Programa(declaracoes, comando);}
    throw new Error("Missing return statement in function");
  }

  final public plp.interfaceclasseabstrata.declaracao.Declaracao PDeclaracoes() throws ParseException {
  plp.interfaceclasseabstrata.declaracao.Declaracao retorno;
    if (jj_2_2(2147483647)) {
      retorno = PDeclaracoesComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASSE:
      case INTERFACE:
      case ABSTRACT:
        retorno = PDeclaracoesAtomica();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

  final public DeclaracaoComposta PDeclaracoesComposta() throws ParseException {
  plp.interfaceclasseabstrata.declaracao.Declaracao d1;
  plp.interfaceclasseabstrata.declaracao.Declaracao d2;
  DeclaracaoComposta retorno;
    d1 = PDeclaracoesAtomica();
    jj_consume_token(COMMA);
    d2 = PDeclaracoes();
    retorno = new DeclaracaoComposta(d1, d2);
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

  final public plp.interfaceclasseabstrata.declaracao.Declaracao PDeclaracoesAtomica() throws ParseException {
  plp.interfaceclasseabstrata.declaracao.Declaracao retorno;
    if (jj_2_3(2147483647)) {
      retorno = PDecInterfaceAtomica();
    } else if (jj_2_4(2147483647)) {
      retorno = PDecClasseAtomica();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * Comando::= ComandoSimples | ComandoSequencial
 **/
  final public Comando PComando() throws ParseException {
  Comando retorno;
    if (jj_2_5(2147483647)) {
      retorno = PComandoSequencial();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMAND_SKIP:
      case WHILE:
      case READ:
      case WRITE:
      case IF:
      case THIS:
      case SUPER:
      case IDENTIFIER:
      case LPAREN:
      case LBRACE:
        retorno = PComandoSimples();
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ComandoSequencial ::= ComandoSimples ";" Comando
 **/
  final public Sequencial PComandoSequencial() throws ParseException {
  Comando c1;
  Comando c2;
    c1 = PComandoSimples();
    jj_consume_token(SEMICOLON);
    c2 = PComando();
    {if (true) return new Sequencial(c1, c2);}
    throw new Error("Missing return statement in function");
  }

/**
 *
 * ComandoSimples ::= Skip
 *           		| ComDeclaracao
 *           		| While
 *           		| IfThenElse
 *           		| IO
 *           		| ChamadaMetodo
 *           		| New
 *                  | Cast
 *          		| Atribuicao
 *                  | "("Comando")
 **/
  final public Comando PComandoSimples() throws ParseException {
  Comando retorno;
    if (jj_2_6(2147483647)) {
      retorno = PSkip();
    } else if (jj_2_7(2147483647)) {
      retorno = PComDeclaracao();
    } else if (jj_2_8(2147483647)) {
      retorno = PWhile();
    } else if (jj_2_9(2147483647)) {
      retorno = PIfThenElse();
    } else if (jj_2_10(2147483647)) {
      retorno = PIO();
    } else if (jj_2_11(2147483647)) {
      retorno = PChamadaMetodo();
    } else if (jj_2_12(2147483647)) {
      retorno = PNew();
    } else if (jj_2_13(2147483647)) {
      retorno = PCast();
    } else if (jj_2_14(2147483647)) {
      retorno = PAtribuicao();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        retorno = PComando();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * Skip::=
 **/
  final public Skip PSkip() throws ParseException {
    jj_consume_token(COMAND_SKIP);
    {if (true) return new Skip();}
    throw new Error("Missing return statement in function");
  }

/**
 * ComDeclaracao :: = "{" DecVariavel ";" Comando "}"
 **/
  final public ComDeclaracao PComDeclaracao() throws ParseException {
  Declaracao dec;
  Comando comando;
    jj_consume_token(LBRACE);
    dec = PDecVariavel();
    jj_consume_token(SEMICOLON);
    comando = PComando();
    jj_consume_token(RBRACE);
    {if (true) return new ComDeclaracao(dec, comando);}
    throw new Error("Missing return statement in function");
  }

/**
 * While ::= "while" Expressao do" "{" Comando "}"
 **/
  final public While PWhile() throws ParseException {
  Expressao expressao;
  Comando comando;
    jj_consume_token(WHILE);
    expressao = PExpressao();
    jj_consume_token(DO);
    jj_consume_token(LBRACE);
    comando = PComando();
    jj_consume_token(RBRACE);
    {if (true) return new While(expressao, comando);}
    throw new Error("Missing return statement in function");
  }

/**
 * IfThenElse ::= "if" Expressao "then" "{" Comando "}"
 *				| "if" Expressao "then" "{" Comando "}" "else" "{" Comando "}"
 **/
  final public IfThenElse PIfThenElse() throws ParseException {
  Expressao expressao;
  Comando comandoThen;
  Comando comandoElse;
  IfThenElse resposta;
    if (jj_2_15(2147483647)) {
      jj_consume_token(IF);
      expressao = PExpressao();
      jj_consume_token(THEN);
      jj_consume_token(LBRACE);
      comandoThen = PComando();
      jj_consume_token(RBRACE);
      jj_consume_token(ELSE);
      jj_consume_token(LBRACE);
      comandoElse = PComando();
      jj_consume_token(RBRACE);
    resposta = new IfThenElse(expressao, comandoThen, comandoElse);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
        jj_consume_token(IF);
        expressao = PExpressao();
        jj_consume_token(THEN);
        jj_consume_token(LBRACE);
        comandoThen = PComando();
        jj_consume_token(RBRACE);
    resposta = new IfThenElse(expressao, comandoThen, new Skip());
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return resposta;}
    throw new Error("Missing return statement in function");
  }

/**
 * ChamadaMetodo ::= ExpressaoChamadora "." Id "(" ListaExpressao ")"
 *                 | ExpressaoChamadora "." Id "("")"
 **/
  final public ChamadaMetodoOO2 PChamadaMetodo() throws ParseException {
  Expressao expressao;
  Id nomeMetodo;
  ListaExpressao parametros = null;
    if (jj_2_16(2147483647)) {
      expressao = PExpressaoChamadora();
      jj_consume_token(DOT);
      nomeMetodo = PId();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case THIS:
      case SUPER:
      case IDENTIFIER:
      case LPAREN:
        expressao = PExpressaoChamadora();
        jj_consume_token(DOT);
        nomeMetodo = PId();
        jj_consume_token(LPAREN);
        parametros = PListaExpressao();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (parametros == null){
      parametros = new ListaExpressao();
    }
    {if (true) return new ChamadaMetodoOO2(expressao, nomeMetodo, parametros);}
    throw new Error("Missing return statement in function");
  }

/**
 * ListaExpressao ::= Expressao | Expressao "," ListaExpressao
 **/
  final public ListaExpressao PListaExpressao() throws ParseException {
  ListaExpressao retorno;
  Expressao exp;
    if (jj_2_17(2147483647)) {
      retorno = PListaExpressaoComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
      case LENGTH:
      case TRUE:
      case FALSE:
      case THIS:
      case SUPER:
      case NULL:
      case INTEGER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case MINUS:
        exp = PListaExpressaoAtomica();
    retorno = new ListaExpressao(exp);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Expressao "," ListaExpressao
 **/
  final public ListaExpressao PListaExpressaoComposta() throws ParseException {
  Expressao e1;
  ListaExpressao e2;
    e1 = PListaExpressaoAtomica();
    jj_consume_token(COMMA);
    e2 = PListaExpressao();
    {if (true) return new ListaExpressao(e1, e2);}
    throw new Error("Missing return statement in function");
  }

/**
 * ...Expressao
 **/
  final public Expressao PListaExpressaoAtomica() throws ParseException {
  Expressao retorno;
    retorno = PExpressao();
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * New ::= LeftExpression ":=" "new" Id
 **/
  final public New PNew() throws ParseException {
  LeftExpression av;
  Id idClasse;
    av = PLeftExpression();
    jj_consume_token(ATTRIB);
    jj_consume_token(NEW);
    idClasse = PId();
    {if (true) return new New(av, idClasse);}
    throw new Error("Missing return statement in function");
  }

/**
 * Cast ::= LeftExpression ":=" "("idClasseCast")" Id
 **/
  final public plp.orientadaObjetos2.comando.Cast PCast() throws ParseException {
  LeftExpression av;
  Id idObjeto;
  Tipo idClasseCast;
    av = PLeftExpression();
    jj_consume_token(ATTRIB);
    jj_consume_token(LPAREN);
    idClasseCast = PTipoClasse();
    jj_consume_token(RPAREN);
    idObjeto = PId();
    {if (true) return new Cast(av, idObjeto, idClasseCast);}
    throw new Error("Missing return statement in function");
  }

/**
 * Atribuicao ::= LeftExpression ":=" Expressao
 **/
  final public AtribuicaoOO2 PAtribuicao() throws ParseException {
  LeftExpression av;
  Expressao exp;
    av = PLeftExpression();
    jj_consume_token(ATTRIB);
    exp = PExpressao();
    {if (true) return new AtribuicaoOO2(av, exp);}
    throw new Error("Missing return statement in function");
  }

/**
 * IO ::= "write" "(" Expressao ")" | "read" "(" Id ")"
 **/
  final public IO PIO() throws ParseException {
  IO retorno;
    if (jj_2_18(2147483647)) {
      retorno = PWrite();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case READ:
        retorno = PRead();
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "read" "(" Id ")"
 **/
  final public Read PRead() throws ParseException {
  Id id;
    jj_consume_token(READ);
    jj_consume_token(LPAREN);
    id = PId();
    jj_consume_token(RPAREN);
    {if (true) return new Read(id);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "write" "(" Expressao ")"
 **/
  final public Write PWrite() throws ParseException {
  Expressao exp;
    jj_consume_token(WRITE);
    jj_consume_token(LPAREN);
    exp = PExpressao();
    jj_consume_token(RPAREN);
    {if (true) return new Write(exp);}
    throw new Error("Missing return statement in function");
  }

/**
 * Expressao ::= ExpUnaria | ExpBinaria | ExpPrimaria
 **/
  final public Expressao PExpressao() throws ParseException {
  Expressao retorno;
    retorno = PExpBinaria();
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ExpPrimaria ::= Valor | LeftExpression | this | "("Expressao")"
 **/
  final public Expressao PExpPrimaria() throws ParseException {
  Expressao retorno;
    if (jj_2_19(2147483647)) {
      retorno = PLeftExpression();
    } else if (jj_2_20(2147483647)) {
      retorno = PThis();
    } else if (jj_2_21(2147483647)) {
      retorno = PSuper();
    } else if (jj_2_22(2147483647)) {
      jj_consume_token(LPAREN);
      retorno = PExpressao();
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
      case FALSE:
      case NULL:
      case INTEGER_LITERAL:
      case STRING_LITERAL:
        retorno = PValor();
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * Valor ::= ValorInteiro | ValorNull  | ValorBooleano | ValorString
 **/
  final public Valor PValor() throws ParseException {
  Valor retorno;
    if (jj_2_23(2147483647)) {
      retorno = PValorNull();
    } else if (jj_2_24(2147483647)) {
      retorno = PValorInteiro();
    } else if (jj_2_25(2147483647)) {
      retorno = PValorBooleano();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        retorno = PValorString();
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... ValorInteiro
 **/
  final public Valor PValorInteiro() throws ParseException {
  Token token;
    token = jj_consume_token(INTEGER_LITERAL);
    {if (true) return new ValorInteiro(Integer.parseInt(token.toString()));}
    throw new Error("Missing return statement in function");
  }

/**
 * ... ValorNull
 **/
  final public ValorNull PValorNull() throws ParseException {
    jj_consume_token(NULL);
    {if (true) return new ValorNull();}
    throw new Error("Missing return statement in function");
  }

/**
 * ... ValorBooleano
 **/
  final public Valor PValorBooleano() throws ParseException {
    if (jj_2_26(2147483647)) {
      jj_consume_token(FALSE);
    {if (true) return new ValorBooleano(false);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
    {if (true) return new ValorBooleano(true);}
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * ... ValorString
 **/
  final public Valor PValorString() throws ParseException {
  Token token;
    token = jj_consume_token(STRING_LITERAL);
    String tokenStr = token.toString();
    //a seguir, serao retiradas as aspas do literal string
tokenStr = tokenStr.substring(1, tokenStr.length()-1);
    {if (true) return new ValorString(tokenStr);}
    throw new Error("Missing return statement in function");
  }

/**
 * ExpUnaria ::= "-" Expressao | "not" Expressao | "length" Expressao | ExpPrimaria
 **/
  final public Expressao PExpUnaria() throws ParseException {
  Expressao retorno;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      retorno = PExpMenos();
      break;
    case NOT:
      retorno = PExpNot();
      break;
    case LENGTH:
      retorno = PExpLength();
      break;
    case TRUE:
    case FALSE:
    case THIS:
    case SUPER:
    case NULL:
    case INTEGER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case LPAREN:
      retorno = PExpPrimaria();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "-" Expressao
 **/
  final public Expressao PExpMenos() throws ParseException {
  Expressao retorno;
    jj_consume_token(MINUS);
    retorno = PExpressao();
    {if (true) return new ExpMenos(retorno);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "not" Expressao
 **/
  final public Expressao PExpNot() throws ParseException {
  Expressao retorno;
    jj_consume_token(NOT);
    retorno = PExpressao();
    {if (true) return new ExpNot(retorno);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "length" Expressao
 **/
  final public Expressao PExpLength() throws ParseException {
  Expressao retorno;
    jj_consume_token(LENGTH);
    retorno = PExpressao();
    {if (true) return new ExpLength(retorno);}
    throw new Error("Missing return statement in function");
  }

/**
 * ExpBinaria ::= ExpUnaria
 *        ( "+" ExpUnaria
 * 				| "-" ExpUnaria
 * 				| "and" ExpUnaria
 * 				| "or" ExpUnaria
 * 				| "==" ExpUnaria
 * 				| "++" Expressao)*
 **/
  final public Expressao PExpBinaria() throws ParseException {
  Expressao retorno, param2;
    retorno = PExpUnaria();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
      case OR:
      case INSTANCEOF:
      case EQ:
      case CONCAT:
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT:
        jj_consume_token(CONCAT);
        param2 = PExpUnaria();
    retorno = new ExpConcat(retorno, param2);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        param2 = PExpUnaria();
    retorno = new ExpSub(retorno, param2);
        break;
      case AND:
        jj_consume_token(AND);
        param2 = PExpUnaria();
    retorno = new ExpAnd(retorno, param2);
        break;
      case OR:
        jj_consume_token(OR);
        param2 = PExpUnaria();
    retorno = new ExpOr(retorno, param2);
        break;
      case EQ:
        jj_consume_token(EQ);
        param2 = PExpUnaria();
    retorno = new ExpEquals(retorno, param2);
        break;
      case PLUS:
        jj_consume_token(PLUS);
        param2 = PExpUnaria();
    retorno = new ExpSoma(retorno, param2);
        break;
      case INSTANCEOF:
        jj_consume_token(INSTANCEOF);
        param2 = PExpUnaria();
    retorno = new ExpInstanceOf(retorno, param2);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... this
 **/
  final public This PThis() throws ParseException {
    jj_consume_token(THIS);
    {if (true) return new This();}
    throw new Error("Missing return statement in function");
  }

/**
 * ... super
 **/
  final public Super PSuper() throws ParseException {
    jj_consume_token(SUPER);
    {if (true) return new Super();}
    throw new Error("Missing return statement in function");
  }

/**
 * LeftExpression ::= Id | AcessoAtributo
 **/
  final public LeftExpression PLeftExpression() throws ParseException {
  LeftExpression retorno;
    if (jj_2_27(2147483647)) {
      retorno = PAcessoAtributoId();
    } else if (jj_2_28(2147483647)) {
      retorno = PAcessoAtributoThis();
    } else if (jj_2_29(2147483647)) {
      retorno = PAcessoAtributoSuper();
    } else if (jj_2_30(2147483647)) {
      retorno = PId();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Id
 **/
  final public Id PId() throws ParseException {
  Token token;
    token = jj_consume_token(IDENTIFIER);
    {if (true) return new Id(token.toString());}
    throw new Error("Missing return statement in function");
  }

/**
 * AcessoAtributo ::= this.Id | (this).id | (super).id | "("LeftExpression")".Id | Id.Id
 **/
  final public AcessoAtributo PAcessoAtributo() throws ParseException {
  AcessoAtributo retorno;
    if (jj_2_31(2147483647)) {
      retorno = PAcessoAtributoThis();
    } else if (jj_2_32(2147483647)) {
      retorno = PAcessoAtributoSuper();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case LPAREN:
        retorno = PAcessoAtributoId();
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... this.Id | (this).id
 **/
  final public AcessoAtributoThis PAcessoAtributoThis() throws ParseException {
  This t;
  Id id;
    if (jj_2_33(2147483647)) {
      jj_consume_token(LPAREN);
      t = PThis();
      jj_consume_token(RPAREN);
      jj_consume_token(DOT);
      id = PId();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case THIS:
        t = PThis();
        jj_consume_token(DOT);
        id = PId();
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return new AcessoAtributoThis(t, id);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... super.Id | (super).id
 **/
  final public AcessoAtributoSuper PAcessoAtributoSuper() throws ParseException {
  Super t;
  Id id;
    if (jj_2_34(2147483647)) {
      jj_consume_token(LPAREN);
      t = PSuper();
      jj_consume_token(RPAREN);
      jj_consume_token(DOT);
      id = PId();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUPER:
        t = PSuper();
        jj_consume_token(DOT);
        id = PId();
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return new AcessoAtributoSuper(t, id);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "("LeftExpression")".Id | Id.Id
 **/
  final public AcessoAtributoId PAcessoAtributoId() throws ParseException {
  LeftExpression av;
  Id id;
    if (jj_2_35(2147483647)) {
      jj_consume_token(LPAREN);
      av = PLeftExpression();
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        av = PId();
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(DOT);
    id = PId();
    {if (true) return new AcessoAtributoId(av, id);}
    throw new Error("Missing return statement in function");
  }

/**
 * Uma expressao chamadora eh aquela que chama um m�todo. Ela sabe separar
 * o acesso de atributo, que � o que ela retorna, da chamada do m�todo em si
 * (<DOT><IDENTIFIER><LPAREN>).
 *
 * PExpressaoChamadora:: this | super | id | LeftExpressionChamadora
 *
 */
  final public Expressao PExpressaoChamadora() throws ParseException {
  Expressao exp;
    if (jj_2_36(2147483647)) {
      exp = PThis();
    } else if (jj_2_37(2147483647)) {
      exp = PSuper();
    } else if (jj_2_38(2147483647)) {
      exp = PId();
    } else if (jj_2_39(2147483647)) {
      exp = PLeftExpressionChamadora();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

/**
 * LeftExpressionChamadora ::=  AcessoAtributoChamador | AcessoAtributoThis | id
 **/
  final public LeftExpression PLeftExpressionChamadora() throws ParseException {
  LeftExpression retorno;
    if (jj_2_40(2147483647)) {
      retorno = PAcessoAtributoIdChamador();
    } else if (jj_2_41(2147483647)) {
      retorno = PAcessoAtributoThis();
    } else if (jj_2_42(2147483647)) {
      retorno = PAcessoAtributoSuper();
    } else if (jj_2_43(2147483647)) {
      retorno = PId();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "("LeftExpressionChamadora")".Id | Id.Id
 **/
  final public AcessoAtributoId PAcessoAtributoIdChamador() throws ParseException {
  LeftExpression av;
  Id id;
    if (jj_2_44(2147483647)) {
      jj_consume_token(LPAREN);
      av = PLeftExpressionChamadora();
      jj_consume_token(RPAREN);
      jj_consume_token(DOT);
      id = PId();
    } else if (jj_2_45(2147483647)) {
      av = PId();
      jj_consume_token(DOT);
      id = PId();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return new AcessoAtributoId(av, id);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... DecClasse ::= DecClasseAbstrata
 *         | DecClasseConcreta  
 **/
  final public DeclaracaoClasse PDecClasseAtomica() throws ParseException {
  DeclaracaoClasse resposta;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSE:
      resposta = PDecClasseConcreta();
    {if (true) return resposta;}
      break;
    case ABSTRACT:
      resposta = PDecClasseAbstrata();
    {if (true) return resposta;}
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * ... "classe" Id ["extends" Id] ["implements" Id] "{" DecVariavel ";" DecProcedimento "}" 
 **/
  final public DeclaracaoClasse PDecClasseConcreta() throws ParseException {
  Id nomeClasse;
  Id nomeSuperClasse = null;
  ListaInterface listaInterface = null;
  DecVariavel atributos;
  DecProcedimento metodos;
  DeclaracaoClasse resposta;
  ListaCorpoClasse lcc;
  ListaInterface interfaces;
    if (jj_2_46(2147483647)) {
      jj_consume_token(CLASSE);
      nomeClasse = PId();
      jj_consume_token(EXTENDS);
      nomeSuperClasse = PId();
      jj_consume_token(IMPLEMENTS);
      listaInterface = PListaInterface();
      jj_consume_token(LBRACE);
      lcc = PListaCorpoClasseConcreta();
      jj_consume_token(RBRACE);
                        resposta = new DecClasseConcreta(nomeClasse, nomeSuperClasse, listaInterface, lcc.getAtributos(), lcc.getMetodos());
    } else if (jj_2_47(2147483647)) {
      jj_consume_token(CLASSE);
      nomeClasse = PId();
      jj_consume_token(EXTENDS);
      nomeSuperClasse = PId();
      jj_consume_token(LBRACE);
      lcc = PListaCorpoClasseConcreta();
      jj_consume_token(RBRACE);
                resposta = new DecClasseConcreta(nomeClasse, nomeSuperClasse, listaInterface, lcc.getAtributos(), lcc.getMetodos());
    } else if (jj_2_48(2147483647)) {
      jj_consume_token(CLASSE);
      nomeClasse = PId();
      jj_consume_token(IMPLEMENTS);
      listaInterface = PListaInterface();
      jj_consume_token(LBRACE);
      lcc = PListaCorpoClasseConcreta();
      jj_consume_token(RBRACE);
                resposta = new DecClasseConcreta(nomeClasse, nomeSuperClasse, listaInterface, lcc.getAtributos(), lcc.getMetodos());
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLASSE:
        jj_consume_token(CLASSE);
        nomeClasse = PId();
        jj_consume_token(LBRACE);
        lcc = PListaCorpoClasseConcreta();
        jj_consume_token(RBRACE);
                    resposta = new DecClasseConcreta(nomeClasse, null, listaInterface, lcc.getAtributos(), lcc.getMetodos());
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return resposta;}
    throw new Error("Missing return statement in function");
  }

  final public DeclaracaoClasse PDecClasseAbstrata() throws ParseException {
  Id nomeClasse;
  Id nomeSuperClasse = null;
  DecVariavel atributos;
  DecProcedimento metodos;
  DeclaracaoClasse resposta;
  ListaCorpoClasse lcc;
    if (jj_2_49(2147483647)) {
      jj_consume_token(ABSTRACT);
      jj_consume_token(CLASSE);
      nomeClasse = PId();
      jj_consume_token(EXTENDS);
      nomeSuperClasse = PId();
      jj_consume_token(LBRACE);
      lcc = PListaCorpoClasseAbstrata();
      jj_consume_token(RBRACE);
    resposta = new DecClasseAbstrata(nomeClasse, nomeSuperClasse, null, lcc.getAtributos(), lcc.getMetodos());
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
        jj_consume_token(CLASSE);
        nomeClasse = PId();
        jj_consume_token(LBRACE);
        lcc = PListaCorpoClasseAbstrata();
        jj_consume_token(RBRACE);
    resposta = new DecClasseAbstrata(nomeClasse, null, null, lcc.getAtributos(), lcc.getMetodos());
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return resposta;}
    throw new Error("Missing return statement in function");
  }

  final public ListaCorpoClasse PListaCorpoClasseAbstrata() throws ParseException {
  ListaCorpoClasse retorno;

  CorpoClasse corpo;
    if (jj_2_50(2147483647)) {
      retorno = PCorpoClasseAbstrataComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
      case BOOLEAN:
      case STRING:
      case PRIVATE:
      case PUBLIC:
      case ABSTRACT:
      case IDENTIFIER:
      case LPAREN:
        corpo = PCorpoClasseAbstrataAtomica();
    retorno = new ListaCorpoClasse(corpo);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... 
 **/
  final public ListaCorpoClasse PCorpoClasseAbstrataComposta() throws ParseException {
  CorpoClasse corpo;
    ListaCorpoClasse listaCorpo;
    corpo = PCorpoClasseAbstrataAtomica();
    jj_consume_token(SEMICOLON);
    listaCorpo = PListaCorpoClasseAbstrata();
    {if (true) return new ListaCorpoClasse(corpo, listaCorpo);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... 
 **/
  final public CorpoClasse PCorpoClasseAbstrataAtomica() throws ParseException {
  CorpoClasse retorno;
  DecVariavel decVar;
  DecProcedimento decProc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
    case BOOLEAN:
    case STRING:
    case IDENTIFIER:
    case LPAREN:
      decVar = PDecVariavelAtomica();
    {if (true) return decVar;}
      break;
    case PRIVATE:
    case PUBLIC:
    case ABSTRACT:
      decProc = PDecProcedimentoSimples();
    {if (true) return decProc;}
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ListaCorpoClasse PListaCorpoClasseConcreta() throws ParseException {
  ListaCorpoClasse retorno;

  CorpoClasse corpo;
    if (jj_2_51(2147483647)) {
      retorno = PCorpoClasseConcretaComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
      case BOOLEAN:
      case STRING:
      case PRIVATE:
      case PUBLIC:
      case IDENTIFIER:
      case LPAREN:
        corpo = PCorpoClasseConcretaAtomica();
    retorno = new ListaCorpoClasse(corpo);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... 
 **/
  final public ListaCorpoClasse PCorpoClasseConcretaComposta() throws ParseException {
  CorpoClasse corpo;
    ListaCorpoClasse listaCorpo;
    corpo = PCorpoClasseConcretaAtomica();
    jj_consume_token(SEMICOLON);
    listaCorpo = PListaCorpoClasseConcreta();
    {if (true) return new ListaCorpoClasse(corpo, listaCorpo);}
    throw new Error("Missing return statement in function");
  }

/**
 * ...
 **/
  final public CorpoClasse PCorpoClasseConcretaAtomica() throws ParseException {
  CorpoClasse retorno;
  DecVariavel decVar;
  DecProcedimento decProc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INT:
    case BOOLEAN:
    case STRING:
    case IDENTIFIER:
    case LPAREN:
      decVar = PDecVariavelAtomica();
    {if (true) return decVar;}
      break;
    case PRIVATE:
    case PUBLIC:
      decProc = PDecProcConcreto();
    {if (true) return decProc;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * DecVariavel ::= Tipo Id "=" Expressao
 *				 | DecVariavel "," DecVariavel
 *               | Tipo Id ":=" "new" Id
 *               | "("DecVariavel")"
 **/
  final public DecVariavel PDecVariavel() throws ParseException {
  DecVariavel retorno;
    if (jj_2_52(2147483647)) {
      retorno = PCompostaDecVariavel();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
      case BOOLEAN:
      case STRING:
      case IDENTIFIER:
      case LPAREN:
        retorno = PDecVariavelAtomica();
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... DecVariavel "," DecVariavel
 **/
  final public CompostaDecVariavel PCompostaDecVariavel() throws ParseException {
  DecVariavel d1;
  DecVariavel d2;
    d1 = PDecVariavelAtomica();
    jj_consume_token(COMMA);
    d2 = PDecVariavel();
    {if (true) return new CompostaDecVariavel(d1, d2);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Tipo Id "=" Expressao | Tipo Id ":=" "new" Id | "("DecVariavel")"
 **/
  final public DecVariavel PDecVariavelAtomica() throws ParseException {
  DecVariavel retorno;
    if (jj_2_53(2147483647)) {
      retorno = PDecVariavelObjeto();
    } else if (jj_2_54(2147483647)) {
      jj_consume_token(LPAREN);
      retorno = PDecVariavel();
      jj_consume_token(RPAREN);
    } else if (jj_2_55(2147483647)) {
      retorno = PSimplesDecVariavel();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Tipo Id ":=" "new" Id
 **/
  final public DecVariavelObjeto PDecVariavelObjeto() throws ParseException {
  Id id, idClasse;
  Tipo tipo;
    tipo = PTipo();
    id = PId();
    jj_consume_token(ATTRIB);
    jj_consume_token(NEW);
    idClasse = PId();
    {if (true) return new DecVariavelObjeto(tipo, id, idClasse);}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Tipo Id "=" Expressao
 **/
  final public SimplesDecVariavel PSimplesDecVariavel() throws ParseException {
  Id id;
  Expressao exp;
  SimplesDecVariavel retorno;
  Tipo tipo;
    tipo = PTipo();
    id = PId();
    jj_consume_token(ASSIGN);
    exp = PExpressao();
    retorno = new SimplesDecVariavel(tipo, id, exp);
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

  final public DecProcedimento PDecProcedimentoSimples() throws ParseException {
  Comando comando;
  AssinaturaMetodo assinatura;
  DecProcedimento procConcreto,procAbstrato;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSTRACT:
      //Declaracao de procedimento abstrato
        procAbstrato = PDecProcAbstrato();
                {if (true) return procAbstrato;}
      break;
    case PRIVATE:
    case PUBLIC:
      procConcreto = PDecProcConcreto();
       {if (true) return procConcreto;}
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
*
*  DecProcConcreto ::= AssinaturaMetodo "{" Comando "}" 
*
**/
  final public DecProcedimento PDecProcConcreto() throws ParseException {
  Comando comando;
  AssinaturaMetodo assinatura;
    //declaracao de procedimento concreto
      assinatura = PAssinaturaMetodo();
    jj_consume_token(LBRACE);
    comando = PComando();
    jj_consume_token(RBRACE);
    {if (true) return new DecProcedimentoConcreto(assinatura.getId(), assinatura.getParametrosFormais(),
                                                                         comando, assinatura.getModificador());}
    throw new Error("Missing return statement in function");
  }

/**
*  DecProcAbstrato::="abstract" AssinaturaMetodo
*
**/
  final public DecProcedimento PDecProcAbstrato() throws ParseException {
  Comando comando;
  AssinaturaMetodo assinatura;
    jj_consume_token(ABSTRACT);
    assinatura = PAssinaturaMetodo();
    {if (true) return new DecProcedimentoAbstrato(assinatura.getId(), assinatura.getParametrosFormais(),
                                                                         assinatura.getModificador());}
    throw new Error("Missing return statement in function");
  }

  final public String PDecModificador() throws ParseException {
  Token token = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PUBLIC:
      token = jj_consume_token(PUBLIC);
    {if (true) return token.toString();}
      break;
    case PRIVATE:
      token = jj_consume_token(PRIVATE);
    {if (true) return token.toString();}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * ListaDeclaracaoParametro ::= Tipo Id | Tipo Id "," ListaDeclaracaoParametro
 **/
  final public ListaDeclaracaoParametro PListaDeclaracaoParametro() throws ParseException {
  ListaDeclaracaoParametro retorno;
  DecParametro decPar;
    if (jj_2_56(2147483647)) {
      retorno = PDecParametroComposto();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INT:
      case BOOLEAN:
      case STRING:
      case IDENTIFIER:
        decPar = PDecParametroAtomico();
    retorno = new ListaDeclaracaoParametro(decPar);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Tipo Id "," ListaDeclaracaoParametro
 **/
  final public ListaDeclaracaoParametro PDecParametroComposto() throws ParseException {
  DecParametro d1;
  ListaDeclaracaoParametro d2;
    d1 = PDecParametroAtomico();
    jj_consume_token(COMMA);
    d2 = PListaDeclaracaoParametro();
    {if (true) return new ListaDeclaracaoParametro(d1, d2);}
    throw new Error("Missing return statement in function");
  }

/**
 * ...Tipo Id
 **/
  final public DecParametro PDecParametroAtomico() throws ParseException {
  DecParametro retorno;
  Tipo tipo;
  Id id;
    tipo = PTipo();
    id = PId();
    {if (true) return new DecParametro(id, tipo);}
    throw new Error("Missing return statement in function");
  }

/**
 * Tipo ::= TipoClasse | TipoPrimitivo
 **/
  final public Tipo PTipo() throws ParseException {
  Tipo tipo;
    if (jj_2_57(2147483647)) {
      tipo = PTipoPrimitivo();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        tipo = PTipoClasse();
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return tipo;}
    throw new Error("Missing return statement in function");
  }

/**
 * TipoPrimitivo ::= "string" | "int" | "boolean"
 **/
  final public Tipo PTipoPrimitivo() throws ParseException {
  Tipo retorno;
    if (jj_2_58(2147483647)) {
      jj_consume_token(INT);
    retorno = TipoPrimitivo.TIPO_INTEIRO;
    } else if (jj_2_59(2147483647)) {
      jj_consume_token(BOOLEAN);
    retorno = TipoPrimitivo.TIPO_BOOLEANO;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        jj_consume_token(STRING);
    retorno = TipoPrimitivo.TIPO_STRING;
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * TipoClasse ::= Id
 **/
  final public Tipo PTipoClasse() throws ParseException {
  Tipo retorno;
  Id id;
    id = PId();
    retorno = new TipoClasse(id);
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/*Modificações Interface e Classe Abstrata*/
/*
 * "interface" Id "extends" Id "{" ListaAssinaturasMetodos "}" | "interface" Id "extends" Id "{" ListaAssinaturasMetodos "}" 
 */
  final public DeclaracaoInterface PDecInterfaceAtomica() throws ParseException {
  Id nomeInterface;
  Id nomeSuperInterface;
  ListaAssinaturaMetodo assinaturas;
  DeclaracaoInterface resposta;
    if (jj_2_60(2147483647)) {
      jj_consume_token(INTERFACE);
      nomeInterface = PId();
      jj_consume_token(EXTENDS);
      nomeSuperInterface = PId();
      jj_consume_token(LBRACE);
      assinaturas = PListaAssinaturaMetodo();
      jj_consume_token(RBRACE);
    RelacaoClasseInterface.getInstancia().map(nomeInterface, nomeSuperInterface, RelacaoClasseInterface.INTERFACE);

    resposta = new DeclaracaoInterface(nomeInterface, nomeSuperInterface, assinaturas);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERFACE:
        jj_consume_token(INTERFACE);
        nomeInterface = PId();
        jj_consume_token(LBRACE);
        assinaturas = PListaAssinaturaMetodo();
        jj_consume_token(RBRACE);
    resposta = new DeclaracaoInterface(nomeInterface, null, assinaturas);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return resposta;}
    throw new Error("Missing return statement in function");
  }

  final public ListaAssinaturaMetodo PListaAssinaturaMetodo() throws ParseException {
  ListaAssinaturaMetodo retorno;
  //criar classe
AssinaturaMetodo assinatura;
    if (jj_2_61(2147483647)) {
      retorno = ListaAssinaturaMetodoComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIVATE:
      case PUBLIC:
        assinatura = ListaAssinaturaMetodoAtomica();
    retorno = new ListaAssinaturaMetodo(assinatura);
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... AssinaturaMetodo "," ListaAssinaturaMetodos
 **/
  final public ListaAssinaturaMetodo ListaAssinaturaMetodoComposta() throws ParseException {
  AssinaturaMetodo am1;
  ListaAssinaturaMetodo le2;
    am1 = ListaAssinaturaMetodoAtomica();
    jj_consume_token(COMMA);
    le2 = PListaAssinaturaMetodo();
    {if (true) return new ListaAssinaturaMetodo(am1, le2);}
    throw new Error("Missing return statement in function");
  }

/**
 * ...AssinaturaMetodo
 **/
  final public AssinaturaMetodo ListaAssinaturaMetodoAtomica() throws ParseException {
  AssinaturaMetodo retorno;
    retorno = PAssinaturaMetodo();
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/*
 * ListaInterface = Id | Id, ListaInterface
 */
  final public ListaInterface PListaInterface() throws ParseException {
  ListaInterface retorno;
  //criar classe
Id nomeInterface;
    if (jj_2_62(2147483647)) {
      retorno = PListaInterfaceComposta();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        nomeInterface = PListaInterfaceAtomica();
    retorno = new ListaInterface(nomeInterface);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... Id "," ListaInterface
 **/
  final public ListaInterface PListaInterfaceComposta() throws ParseException {
  Id nomeInterface;
  ListaInterface listaInterface;
    nomeInterface = PListaInterfaceAtomica();
    jj_consume_token(COMMA);
    listaInterface = PListaInterface();
    {if (true) return new ListaInterface(nomeInterface, listaInterface);}
    throw new Error("Missing return statement in function");
  }

/**
 * ...Id
 **/
  final public Id PListaInterfaceAtomica() throws ParseException {
  Id retorno;
    retorno = PId();
    {if (true) return retorno;}
    throw new Error("Missing return statement in function");
  }

/**
 * ... "proc" Id "("")" | "proc" Id "(" ListaDeclaracaoParametro ")"
 **/
  final public AssinaturaMetodo PAssinaturaMetodo() throws ParseException {
  String modificador;
  Id nome;
  ListaDeclaracaoParametro listaPar = null;
    if (jj_2_63(2147483647)) {
      modificador = PDecModificador();
      jj_consume_token(PROC);
      nome = PId();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIVATE:
      case PUBLIC:
        modificador = PDecModificador();
        jj_consume_token(PROC);
        nome = PId();
        jj_consume_token(LPAREN);
        listaPar = PListaDeclaracaoParametro();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (listaPar == null){
      listaPar = new ListaDeclaracaoParametro();
    }
    {if (true) return new AssinaturaMetodo(nome, listaPar, modificador);}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_3_14() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_10()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(COMAND_SKIP)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_7()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) return true;
    }
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_3R_151()) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(COMAND_SKIP)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_3R_22()) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_22()) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_22()) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_12()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_3R_22()) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_6()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_104()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_6()) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_5()) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) return true;
    }
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_4()) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_99()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_3R_21()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_5()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_3R_4()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_21()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    }
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_3R_3()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_2()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_3()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(LENGTH)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_3()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_2()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    }
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_149()) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_3R_148()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_3R_20()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_3R_147()) return true;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_27()) return true;
    if (jj_scan_token(PROC)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_20()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_3R_27()) return true;
    if (jj_scan_token(PROC)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_27()) return true;
    if (jj_scan_token(PROC)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_3R_169()) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) return true;
    }
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) return true;
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_101()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_3R_26()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_141()) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_26()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) return true;
    }
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_3R_168()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_3R_180()) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_3R_179()) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_3R_178()) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_3R_177()) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_3R_170()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) return true;
    }
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_3R_172()) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_3R_25()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_143()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_3R_25()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_143()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_140()) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(WRITE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(IMPLEMENTS)) return true;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(READ)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_scan_token(WRITE)) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) return true;
    }
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_145()) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(IMPLEMENTS)) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) return true;
    }
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(CLASSE)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_142()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_10()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(ATTRIB)) return true;
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_17()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_8()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_17()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_22()) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_3R_13()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_13()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(SUPER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_3R_24()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_139()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_3R_171()) return true;
    return false;
  }

  final private boolean jj_3R_146() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_24()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_7()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_3R_167()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_3R_7()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_146()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_3R_7()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    }
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_9()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_97()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_97()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    return false;
  }

  final private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_96()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_96()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_3R_11()) return true;
    if (jj_scan_token(DO)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_3R_80()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  public InterfaceClasseAbstrataParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[35];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x8000000,0x63b0000,0x0,0x200000,0x6000000,0x16007800,0x80000,0x10006000,0x0,0x2000,0x16007800,0x40000600,0x40000600,0x0,0x2000000,0x4000000,0x0,0x8000000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x40000,0xa0,0x52000,0x10000,0x0,0x12000,0x13100,0x0,0x1100,0x1000,0x0,0x13100,0x0,0x0,0x12000,0x0,0x0,0x2000,0x80,0x0,0x80,0x1209f,0x1209f,0x1201f,0x1201f,0x12007,0x98,0x18,0x2007,0x2000,0x4,0x20,0x18,0x2000,0x18,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x200,0x382,0x382,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[63];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public InterfaceClasseAbstrataParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public InterfaceClasseAbstrataParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new InterfaceClasseAbstrataParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public InterfaceClasseAbstrataParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new InterfaceClasseAbstrataParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public InterfaceClasseAbstrataParser(InterfaceClasseAbstrataParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(InterfaceClasseAbstrataParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 35; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[80];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 35; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 80; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 63; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
