/* Arquivo DefInterface.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 14/04/08: Criação da classe.
 */

package plp.interfaceclasseabstrata.memoria;

import plp.interfaceclasseabstrata.assinatura.AssinaturaMetodo;
import plp.interfaceclasseabstrata.assinatura.ListaAssinaturaMetodo;
import plp.interfaceclasseabstrata.excecoes.AssinaturaNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;

public class DefInterface {

	/**
	 * Identificador da interface.
	 */
	private Id idInterface;

	private Id superInterface;

	private ListaAssinaturaMetodo assinaturas;

	public DefInterface(Id idInterface, Id superInterface, ListaAssinaturaMetodo assinaturas) {
		this.idInterface = idInterface;
		this.superInterface = superInterface;
		this.assinaturas = assinaturas;
	}

	/**
	 * Obtém as assinaturas dos métodos.
	 * 
	 * @return as Lista de assinaturas dos métodos.
	 */
	public ListaAssinaturaMetodo assinaturas() {
		return assinaturas;
	}

	/**
	 * Retorna Uma assinatura de procedimento a partir de seu identificador
	 * 
	 * @param idAssinatura
	 *            Identificador da assinatura
	 * @return a assinatura desejada
	 * @throws AssinaturaNaoDeclaradaException
	 */
	public AssinaturaMetodo getMetodo(Id idAssinatura) throws AssinaturaNaoDeclaradaException {
		ListaAssinaturaMetodo aux = assinaturas;
		AssinaturaMetodo ass = null;
		while ((ass = (AssinaturaMetodo) aux.getHead()) != null) {
			if (ass.getId().equals(idAssinatura))
				return ass;
			ass = aux.getTail().getHead();
		}
		throw new AssinaturaNaoDeclaradaException(idAssinatura);
	}

	public Id getIdInterface() {
		return idInterface;
	}

	public Id getSuperInterface() {
		return superInterface;
	}
}
