/* Arquivo ContextoExecucaoICABS.java
 * Trabalho: Adição de Interface e Classe Abstratas
 * Equipe: Carlos Eduardo Pontual, Filipe Motta, Fernanda D'amorin, Leopoldo Teixeira
 * Histórico de modificações:
 * 
 * Carlos Eduardo Pontual - 15/04/08: Criação do arquivo
 * Carlos Eduardo Pontual - 20/04/08: Os métodos mapDefInterface e 
 * 		getDefInterface foram movidos de ContextoExecucao.java para esta classe.
 */

package plp.interfaceclasseabstrata.memoria;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import plp.imperative1.util.Lista;
import plp.interfaceclasseabstrata.declaracao.interfaces.ListaInterface;
import plp.interfaceclasseabstrata.excecoes.InterfaceJaDeclaradaException;
import plp.interfaceclasseabstrata.excecoes.InterfaceNaoDeclaradaException;
import plp.orientadaObjetos1.expressao.leftExpression.Id;
import plp.orientadaObjetos1.memoria.colecao.ListaValor;
import plp.orientadaObjetos2.memoria.ContextoExecucaoOO2;

public class ContextoExecucaoICABS extends ContextoExecucaoOO2 implements AmbienteExecucaoICABS {

	private Map<Id, ListaInterface> mapInterfaces;

	/**
	 * A pilha de classes do contexto.
	 */
	private Stack<HashMap<Id, DefInterface>> pilhaDefInterface;

	public ContextoExecucaoICABS() {
		super();
		mapInterfaces = new HashMap<Id, ListaInterface>();

		pilhaDefInterface = new Stack<HashMap<Id, DefInterface>>();
		pilhaDefInterface.push(new HashMap<Id, DefInterface>());

	}

	public ContextoExecucaoICABS(ListaValor entrada) {
		super(entrada);
		mapInterfaces = new HashMap<Id, ListaInterface>();

		pilhaDefInterface = new Stack<HashMap<Id, DefInterface>>();
		pilhaDefInterface.push(new HashMap<Id, DefInterface>());
	}

	public Lista<DefInterface> getImplementsInterface(Id classe) throws InterfaceNaoDeclaradaException {
		// TODO Auto-generated method stub
		return getDefInterface(mapInterfaces.get(classe));
	}

	public Map<Id, ListaInterface> getMapClasseInterface() {
		// TODO Auto-generated method stub
		return mapInterfaces;
	}

	public void mapImplementsInterface(Id classe, ListaInterface listaInterface) {
		mapInterfaces.put(classe, listaInterface);

	}

	public Lista<DefInterface> getDefInterface(ListaInterface listaInterface) throws InterfaceNaoDeclaradaException {
		Lista<DefInterface> resultado = new Lista<DefInterface>();
		DefInterface defInterface;
		while ((listaInterface != null) && (listaInterface.getHead() != null)) {
			defInterface = null;
			for (int i = 1; i <= pilhaDefInterface.size(); i++) {
				HashMap<Id, DefInterface> aux = pilhaDefInterface.elementAt(pilhaDefInterface.size() - i);
				defInterface = aux.get(listaInterface.getHead().getId());
				if (defInterface != null) {
					resultado = new Lista<DefInterface>(defInterface, resultado);
					break;
				}
			}
			if (defInterface == null)
				throw new InterfaceNaoDeclaradaException(listaInterface.getHead().getId());
			listaInterface = (ListaInterface) listaInterface.getTail();
		}
		return resultado;
	}

	public DefInterface getDefInterface(Id idArg) throws InterfaceNaoDeclaradaException {
		DefInterface resultado = null;
		for (int i = 1; i <= pilhaDefInterface.size(); i++) {
			HashMap<Id, DefInterface> aux = pilhaDefInterface.elementAt(pilhaDefInterface.size() - i);
			resultado = aux.get(idArg);
			if (resultado != null)
				break;
		}
		if (resultado == null)
			throw new InterfaceNaoDeclaradaException(idArg);
		return resultado;
	}

	public void mapDefInterface(Id idArg, DefInterface defInterface) throws InterfaceJaDeclaradaException {
		HashMap<Id, DefInterface> aux = pilhaDefInterface.peek();
		if (aux.put(idArg, defInterface) != null) {
			throw new InterfaceJaDeclaradaException(idArg);
		}

	}
}
